/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.management.ObjectName;
import sun.management.Util;
import sun.management.VMManagement;

class ThreadImpl
implements ThreadMXBean {
    private final VMManagement jvm;
    private boolean contentionMonitoringEnabled = false;
    private boolean cpuTimeEnabled;

    ThreadImpl(VMManagement vMManagement) {
        this.jvm = vMManagement;
        this.cpuTimeEnabled = this.jvm.isThreadCpuTimeEnabled();
    }

    @Override
    public int getThreadCount() {
        return this.jvm.getLiveThreadCount();
    }

    @Override
    public int getPeakThreadCount() {
        return this.jvm.getPeakThreadCount();
    }

    @Override
    public long getTotalStartedThreadCount() {
        return this.jvm.getTotalThreadCount();
    }

    @Override
    public int getDaemonThreadCount() {
        return this.jvm.getDaemonThreadCount();
    }

    @Override
    public boolean isThreadContentionMonitoringSupported() {
        return this.jvm.isThreadContentionMonitoringSupported();
    }

    @Override
    public synchronized boolean isThreadContentionMonitoringEnabled() {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException("Thread contention monitoring is not supported.");
        }
        return this.contentionMonitoringEnabled;
    }

    @Override
    public boolean isThreadCpuTimeSupported() {
        return this.jvm.isOtherThreadCpuTimeSupported();
    }

    @Override
    public boolean isCurrentThreadCpuTimeSupported() {
        return this.jvm.isCurrentThreadCpuTimeSupported();
    }

    @Override
    public boolean isThreadCpuTimeEnabled() {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported");
        }
        return this.cpuTimeEnabled;
    }

    @Override
    public long[] getAllThreadIds() {
        Util.checkMonitorAccess();
        Thread[] threadArray = ThreadImpl.getThreads();
        int n = threadArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            Thread thread = threadArray[i];
            lArray[i] = thread.getId();
        }
        return lArray;
    }

    @Override
    public ThreadInfo getThreadInfo(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Invalid thread ID parameter: " + l);
        }
        long[] lArray = new long[]{l};
        ThreadInfo[] threadInfoArray = this.getThreadInfo(lArray, 0);
        return threadInfoArray[0];
    }

    @Override
    public ThreadInfo getThreadInfo(long l, int n) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Invalid thread ID parameter: " + l);
        }
        if (n < 0) {
            throw new IllegalArgumentException("Invalid maxDepth parameter: " + n);
        }
        long[] lArray = new long[]{l};
        ThreadInfo[] threadInfoArray = this.getThreadInfo(lArray, n);
        return threadInfoArray[0];
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] lArray) {
        return this.getThreadInfo(lArray, 0);
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] lArray, int n) {
        if (lArray == null) {
            throw new NullPointerException("Null ids parameter.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Invalid maxDepth parameter: " + n);
        }
        Util.checkMonitorAccess();
        ThreadInfo[] threadInfoArray = new ThreadInfo[lArray.length];
        if (n == Integer.MAX_VALUE) {
            ThreadImpl.getThreadInfo0(lArray, -1, threadInfoArray);
        } else {
            ThreadImpl.getThreadInfo0(lArray, n, threadInfoArray);
        }
        return threadInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadContentionMonitoringEnabled(boolean bl) {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException("Thread contention monitoring is not supported");
        }
        Util.checkControlAccess();
        ThreadImpl threadImpl = this;
        synchronized (threadImpl) {
            if (this.contentionMonitoringEnabled != bl) {
                if (bl) {
                    ThreadImpl.resetContentionTimes0(0L);
                }
                ThreadImpl.setThreadContentionMonitoringEnabled0(bl);
                this.contentionMonitoringEnabled = bl;
            }
        }
    }

    @Override
    public long getCurrentThreadCpuTime() {
        if (!this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Current thread CPU time measurement is not supported.");
        }
        if (!this.isThreadCpuTimeEnabled()) {
            return -1L;
        }
        return ThreadImpl.getThreadTotalCpuTime0(0L);
    }

    @Override
    public long getThreadCpuTime(long l) {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU Time Measurement is not supported.");
        }
        if (!this.isThreadCpuTimeSupported() && l != Thread.currentThread().getId()) {
            throw new UnsupportedOperationException("Thread CPU Time Measurement is only supported for the current thread.");
        }
        if (l <= 0L) {
            throw new IllegalArgumentException("Invalid thread ID parameter: " + l);
        }
        if (!this.isThreadCpuTimeEnabled()) {
            return -1L;
        }
        if (l == Thread.currentThread().getId()) {
            return ThreadImpl.getThreadTotalCpuTime0(0L);
        }
        return ThreadImpl.getThreadTotalCpuTime0(l);
    }

    @Override
    public long getCurrentThreadUserTime() {
        if (!this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Current thread CPU time measurement is not supported.");
        }
        if (!this.isThreadCpuTimeEnabled()) {
            return -1L;
        }
        return ThreadImpl.getThreadUserCpuTime0(0L);
    }

    @Override
    public long getThreadUserTime(long l) {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported.");
        }
        if (!this.isThreadCpuTimeSupported() && l != Thread.currentThread().getId()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is only supported for the current thread.");
        }
        if (l <= 0L) {
            throw new IllegalArgumentException("Invalid thread ID parameter: " + l);
        }
        if (!this.isThreadCpuTimeEnabled()) {
            return -1L;
        }
        if (l == Thread.currentThread().getId()) {
            return ThreadImpl.getThreadUserCpuTime0(0L);
        }
        return ThreadImpl.getThreadUserCpuTime0(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadCpuTimeEnabled(boolean bl) {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported");
        }
        Util.checkControlAccess();
        ThreadImpl threadImpl = this;
        synchronized (threadImpl) {
            if (this.cpuTimeEnabled != bl) {
                ThreadImpl.setThreadCpuTimeEnabled0(bl);
                this.cpuTimeEnabled = bl;
            }
        }
    }

    @Override
    public long[] findMonitorDeadlockedThreads() {
        Util.checkMonitorAccess();
        Thread[] threadArray = ThreadImpl.findMonitorDeadlockedThreads0();
        if (threadArray == null) {
            return null;
        }
        long[] lArray = new long[threadArray.length];
        for (int i = 0; i < threadArray.length; ++i) {
            Thread thread = threadArray[i];
            lArray[i] = thread.getId();
        }
        return lArray;
    }

    @Override
    public long[] findDeadlockedThreads() {
        if (!this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of Synchronizer Usage is not supported.");
        }
        Util.checkMonitorAccess();
        Thread[] threadArray = ThreadImpl.findDeadlockedThreads0();
        if (threadArray == null) {
            return null;
        }
        long[] lArray = new long[threadArray.length];
        for (int i = 0; i < threadArray.length; ++i) {
            Thread thread = threadArray[i];
            lArray[i] = thread.getId();
        }
        return lArray;
    }

    @Override
    public void resetPeakThreadCount() {
        Util.checkControlAccess();
        ThreadImpl.resetPeakThreadCount0();
    }

    @Override
    public boolean isObjectMonitorUsageSupported() {
        return this.jvm.isObjectMonitorUsageSupported();
    }

    @Override
    public boolean isSynchronizerUsageSupported() {
        return this.jvm.isSynchronizerUsageSupported();
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] lArray, boolean bl, boolean bl2) {
        if (lArray == null) {
            throw new NullPointerException("Null ids parameter.");
        }
        if (bl && !this.isObjectMonitorUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of Object Monitor Usage is not supported.");
        }
        if (bl2 && !this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of Synchronizer Usage is not supported.");
        }
        Util.checkMonitorAccess();
        return ThreadImpl.dumpThreads0(lArray, bl, bl2);
    }

    @Override
    public ThreadInfo[] dumpAllThreads(boolean bl, boolean bl2) {
        if (bl && !this.isObjectMonitorUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of Object Monitor Usage is not supported.");
        }
        if (bl2 && !this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of Synchronizer Usage is not supported.");
        }
        Util.checkMonitorAccess();
        return ThreadImpl.dumpThreads0(null, bl, bl2);
    }

    private static native Thread[] getThreads();

    private static native void getThreadInfo0(long[] var0, int var1, ThreadInfo[] var2);

    private static native long getThreadTotalCpuTime0(long var0);

    private static native long getThreadUserCpuTime0(long var0);

    private static native void setThreadCpuTimeEnabled0(boolean var0);

    private static native void setThreadContentionMonitoringEnabled0(boolean var0);

    private static native Thread[] findMonitorDeadlockedThreads0();

    private static native Thread[] findDeadlockedThreads0();

    private static native void resetPeakThreadCount0();

    private static native ThreadInfo[] dumpThreads0(long[] var0, boolean var1, boolean var2);

    private static native void resetContentionTimes0(long var0);

    @Override
    public ObjectName getObjectName() {
        return ObjectName.valueOf("java.lang:type=Threading");
    }
}

