/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.XBaseMenuWindow;
import sun.awt.X11.XCheckboxMenuItemPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XMenuItemPeer;
import sun.awt.X11.XMenuPeer;
import sun.awt.X11.XToolkit;

public class XMenuWindow
extends XBaseMenuWindow {
    private static Logger log = Logger.getLogger("sun.awt.X11.XMenuWindow");
    private XMenuPeer menuPeer;
    private static final int WINDOW_SPACING_LEFT = 2;
    private static final int WINDOW_SPACING_RIGHT = 2;
    private static final int WINDOW_SPACING_TOP = 2;
    private static final int WINDOW_SPACING_BOTTOM = 2;
    private static final int WINDOW_ITEM_INDENT = 15;
    private static final int WINDOW_ITEM_MARGIN_LEFT = 2;
    private static final int WINDOW_ITEM_MARGIN_RIGHT = 2;
    private static final int WINDOW_ITEM_MARGIN_TOP = 2;
    private static final int WINDOW_ITEM_MARGIN_BOTTOM = 2;
    private static final int WINDOW_SHORTCUT_SPACING = 10;
    private static final int CHECKMARK_SIZE = 128;
    private static final int[] CHECKMARK_X = new int[]{1, 25, 56, 124, 124, 85, 64};
    private static final int[] CHECKMARK_Y = new int[]{59, 35, 67, 0, 12, 66, 123};

    XMenuWindow(XMenuPeer xMenuPeer) {
        if (xMenuPeer != null) {
            this.menuPeer = xMenuPeer;
            this.target = xMenuPeer.getContainer().target;
            Vector vector = null;
            vector = this.getMenuTargetItems();
            this.reloadItems(vector);
        }
    }

    @Override
    void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
    }

    @Override
    protected XBaseMenuWindow getParentMenuWindow() {
        return this.menuPeer != null ? this.menuPeer.getContainer() : null;
    }

    @Override
    protected MappingData map() {
        Object object;
        int n;
        int n2;
        if (!this.isCreated()) {
            MappingData mappingData = new MappingData(new XMenuItemPeer[0], new Rectangle(0, 0, 0, 0), new Dimension(0, 0), 0, 0, 0);
            return mappingData;
        }
        XMenuItemPeer[] xMenuItemPeerArray = this.copyItems();
        int n3 = xMenuItemPeerArray.length;
        Dimension dimension = this.getCaptionSize();
        int n4 = dimension != null ? dimension.width : 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        XMenuItemPeer.TextMetrics[] textMetricsArray = new XMenuItemPeer.TextMetrics[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            XMenuItemPeer xMenuItemPeer = xMenuItemPeerArray[n2];
            textMetricsArray[n2] = xMenuItemPeerArray[n2].getTextMetrics();
            Dimension dimension2 = textMetricsArray[n2].getTextDimension();
            if (dimension2 == null) continue;
            if (xMenuItemPeerArray[n2] instanceof XCheckboxMenuItemPeer) {
                n5 = Math.max(n5, dimension2.height);
            } else if (xMenuItemPeerArray[n2] instanceof XMenuPeer) {
                n6 = Math.max(n6, dimension2.height);
            }
            n4 = Math.max(n4, dimension2.width);
            n7 = Math.max(n7, textMetricsArray[n2].getShortcutWidth());
        }
        n2 = 2;
        int n8 = 4 + n5 + n4;
        if (n7 > 0) {
            n8 += 10;
        }
        int n9 = n8 + n7;
        int n10 = n9 + n6 + 2;
        int n11 = 2 + n10 + 2;
        Rectangle rectangle = null;
        if (dimension != null) {
            rectangle = new Rectangle(2, n2, n10, dimension.height);
            n2 += dimension.height;
        } else {
            rectangle = new Rectangle(2, n2, n4, 0);
        }
        for (n = 0; n < n3; ++n) {
            Cloneable cloneable;
            object = xMenuItemPeerArray[n];
            XMenuItemPeer.TextMetrics textMetrics = textMetricsArray[n];
            Dimension dimension3 = textMetrics.getTextDimension();
            if (dimension3 != null) {
                int n12 = 2 + dimension3.height + 2;
                cloneable = new Rectangle(2, n2, n10, n12);
                int n13 = (n12 + dimension3.height) / 2 - textMetrics.getTextBaseline();
                Point point = new Point(4 + n5, n2 + n13);
                n2 += n12;
                ((XMenuItemPeer)object).map((Rectangle)cloneable, point);
                continue;
            }
            Rectangle rectangle2 = new Rectangle(2, n2, 0, 0);
            cloneable = new Point(4 + n5, n2);
            ((XMenuItemPeer)object).map(rectangle2, (Point)cloneable);
        }
        n = n2 + 2;
        object = new MappingData(xMenuItemPeerArray, rectangle, new Dimension(n11, n), n5, n8, n9);
        return object;
    }

    @Override
    protected Rectangle getSubmenuBounds(Rectangle rectangle, Dimension dimension) {
        Dimension dimension2;
        Rectangle rectangle2 = this.toGlobal(rectangle);
        Rectangle rectangle3 = this.fitWindowRight(rectangle2, dimension, dimension2 = Toolkit.getDefaultToolkit().getScreenSize());
        if (rectangle3 != null) {
            return rectangle3;
        }
        rectangle3 = this.fitWindowBelow(rectangle2, dimension, dimension2);
        if (rectangle3 != null) {
            return rectangle3;
        }
        rectangle3 = this.fitWindowAbove(rectangle2, dimension, dimension2);
        if (rectangle3 != null) {
            return rectangle3;
        }
        rectangle3 = this.fitWindowLeft(rectangle2, dimension, dimension2);
        if (rectangle3 != null) {
            return rectangle3;
        }
        return this.fitWindowToScreen(dimension, dimension2);
    }

    @Override
    protected void updateSize() {
        this.resetMapping();
        if (this.isShowing()) {
            XToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

                @Override
                public void run() {
                    Dimension dimension = XMenuWindow.this.getDesiredSize();
                    XMenuWindow.this.reshape(XMenuWindow.this.x, XMenuWindow.this.y, dimension.width, dimension.height);
                }
            });
        }
    }

    protected Dimension getCaptionSize() {
        return null;
    }

    protected void paintCaption(Graphics graphics, Rectangle rectangle) {
    }

    XMenuPeer getMenuPeer() {
        return this.menuPeer;
    }

    Vector getMenuTargetItems() {
        return this.menuPeer.getTargetItems();
    }

    Dimension getDesiredSize() {
        MappingData mappingData = (MappingData)this.getMappingData();
        return mappingData.getDesiredSize();
    }

    boolean isCreated() {
        return this.getWindow() != 0L;
    }

    boolean ensureCreated() {
        if (!this.isCreated()) {
            XCreateWindowParams xCreateWindowParams = this.getDelayedParams();
            xCreateWindowParams.remove("delayed");
            xCreateWindowParams.add((Object)"overrideRedirect", Boolean.TRUE);
            xCreateWindowParams.add((Object)"target", this.target);
            this.init(xCreateWindowParams);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void show(Rectangle rectangle) {
        if (!this.isCreated()) {
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("showing menu window + " + this.getWindow() + " at " + rectangle);
        }
        XToolkit.awtLock();
        try {
            this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.xSetVisible(true);
            this.toFront();
            this.selectItem(this.getFirstSelectableItem(), false);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    void hide() {
        this.selectItem(null, false);
        this.xSetVisible(false);
    }

    @Override
    public void paint(Graphics graphics) {
        this.resetColors();
        int n = this.getWidth();
        int n2 = this.getHeight();
        this.flush();
        graphics.setColor(this.getBackgroundColor());
        graphics.fillRect(1, 1, n - 2, n2 - 2);
        this.draw3DRect(graphics, 0, 0, n, n2, true);
        MappingData mappingData = (MappingData)this.getMappingData();
        this.paintCaption(graphics, mappingData.getCaptionRect());
        XMenuItemPeer[] xMenuItemPeerArray = mappingData.getItems();
        Dimension dimension = mappingData.getDesiredSize();
        XMenuItemPeer xMenuItemPeer = this.getSelectedItem();
        for (int i = 0; i < xMenuItemPeerArray.length; ++i) {
            int n3;
            int n4;
            int n5;
            int n6;
            XMenuItemPeer xMenuItemPeer2 = xMenuItemPeerArray[i];
            XMenuItemPeer.TextMetrics textMetrics = xMenuItemPeer2.getTextMetrics();
            Rectangle rectangle = xMenuItemPeer2.getBounds();
            if (xMenuItemPeer2.isSeparator()) {
                this.draw3DRect(graphics, rectangle.x, rectangle.y + rectangle.height / 2, rectangle.width, 2, false);
                continue;
            }
            graphics.setFont(xMenuItemPeer2.getTargetFont());
            Point point = xMenuItemPeer2.getTextOrigin();
            Dimension dimension2 = textMetrics.getTextDimension();
            if (xMenuItemPeer2 == xMenuItemPeer) {
                graphics.setColor(this.getSelectedColor());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.draw3DRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            }
            graphics.setColor(xMenuItemPeer2.isTargetItemEnabled() ? this.getForegroundColor() : this.getDisabledColor());
            graphics.drawString(xMenuItemPeer2.getTargetLabel(), point.x, point.y);
            String string = xMenuItemPeer2.getShortcutText();
            if (string != null) {
                graphics.drawString(string, mappingData.getShortcutOrigin(), point.y);
            }
            if (xMenuItemPeer2 instanceof XMenuPeer) {
                n6 = dimension2.height * 4 / 5;
                n5 = dimension2.height * 4 / 5;
                n4 = rectangle.x + rectangle.width - n6 - 2 - 2;
                n3 = rectangle.y + (rectangle.height - n5) / 2;
                graphics.setColor(xMenuItemPeer2.isTargetItemEnabled() ? this.getDarkShadowColor() : this.getDisabledColor());
                graphics.drawLine(n4, n3 + n5, n4 + n6, n3 + n5 / 2);
                graphics.setColor(xMenuItemPeer2.isTargetItemEnabled() ? this.getLightShadowColor() : this.getDisabledColor());
                graphics.drawLine(n4, n3, n4 + n6, n3 + n5 / 2);
                graphics.drawLine(n4, n3, n4, n3 + n5);
                continue;
            }
            if (!(xMenuItemPeer2 instanceof XCheckboxMenuItemPeer)) continue;
            n6 = dimension2.height * 4 / 5;
            n5 = dimension2.height * 4 / 5;
            n4 = 4;
            n3 = rectangle.y + (rectangle.height - n5) / 2;
            boolean bl = ((XCheckboxMenuItemPeer)xMenuItemPeer2).getTargetState();
            if (bl) {
                graphics.setColor(this.getSelectedColor());
                graphics.fillRect(n4, n3, n6, n5);
                this.draw3DRect(graphics, n4, n3, n6, n5, false);
                int[] nArray = new int[CHECKMARK_X.length];
                int[] nArray2 = new int[CHECKMARK_X.length];
                for (int j = 0; j < CHECKMARK_X.length; ++j) {
                    nArray[j] = n4 + CHECKMARK_X[j] * n6 / 128;
                    nArray2[j] = n3 + CHECKMARK_Y[j] * n5 / 128;
                }
                graphics.setColor(xMenuItemPeer2.isTargetItemEnabled() ? this.getForegroundColor() : this.getDisabledColor());
                graphics.fillPolygon(nArray, nArray2, CHECKMARK_X.length);
                continue;
            }
            graphics.setColor(this.getBackgroundColor());
            graphics.fillRect(n4, n3, n6, n5);
            this.draw3DRect(graphics, n4, n3, n6, n5, true);
        }
        this.flush();
    }

    static class MappingData
    extends XBaseMenuWindow.MappingData {
        private Rectangle captionRect;
        private Dimension desiredSize;
        private int leftMarkWidth;
        private int shortcutOrigin;
        private int rightMarkOrigin;

        MappingData(XMenuItemPeer[] xMenuItemPeerArray, Rectangle rectangle, Dimension dimension, int n, int n2, int n3) {
            super(xMenuItemPeerArray);
            this.captionRect = rectangle;
            this.desiredSize = dimension;
            this.leftMarkWidth = n;
            this.shortcutOrigin = n2;
            this.rightMarkOrigin = n3;
        }

        MappingData() {
            this.desiredSize = new Dimension(0, 0);
            this.leftMarkWidth = 0;
            this.shortcutOrigin = 0;
            this.rightMarkOrigin = 0;
        }

        public Rectangle getCaptionRect() {
            return this.captionRect;
        }

        public Dimension getDesiredSize() {
            return this.desiredSize;
        }

        public int getShortcutOrigin() {
            return this.shortcutOrigin;
        }

        public int getLeftMarkWidth() {
            return this.leftMarkWidth;
        }

        public int getRightMarkOrigin() {
            return this.rightMarkOrigin;
        }
    }
}

