/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.InvocationEvent;
import sun.awt.ComponentAccessor;
import sun.awt.SunToolkit;

public abstract class GlobalCursorManager {
    private final NativeUpdater nativeUpdater = new NativeUpdater();
    private long lastUpdateMillis;
    private final Object lastUpdateLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCursorImmediately() {
        NativeUpdater nativeUpdater = this.nativeUpdater;
        synchronized (nativeUpdater) {
            this.nativeUpdater.pending = false;
        }
        this._updateCursor(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCursorImmediately(InputEvent inputEvent) {
        boolean bl;
        Object object = this.lastUpdateLock;
        synchronized (object) {
            bl = inputEvent.getWhen() >= this.lastUpdateMillis;
        }
        if (bl) {
            this._updateCursor(true);
        }
    }

    public void updateCursorLater(Component component) {
        this.nativeUpdater.postIfNotPending(component, new InvocationEvent((Object)Toolkit.getDefaultToolkit(), this.nativeUpdater));
    }

    protected GlobalCursorManager() {
    }

    protected abstract void setCursor(Component var1, Cursor var2, boolean var3);

    protected abstract void getCursorPos(Point var1);

    protected abstract Component findComponentAt(Container var1, int var2, int var3);

    protected abstract Point getLocationOnScreen(Component var1);

    protected abstract Component findHeavyweightUnderCursor(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateCursor(boolean bl) {
        Object object = this.lastUpdateLock;
        synchronized (object) {
            this.lastUpdateMillis = System.currentTimeMillis();
        }
        object = null;
        Point point = null;
        try {
            Component component = this.findHeavyweightUnderCursor(bl);
            if (component == null) {
                this.updateCursorOutOfJava();
                return;
            }
            if (component instanceof Window) {
                point = ComponentAccessor.getLocation_NoClientCode(component);
            } else if (component instanceof Container) {
                point = this.getLocationOnScreen(component);
            }
            if (point != null) {
                object = new Point();
                this.getCursorPos((Point)object);
                Component component2 = this.findComponentAt((Container)component, ((Point)object).x - point.x, ((Point)object).y - point.y);
                if (component2 != null) {
                    component = component2;
                }
            }
            this.setCursor(component, ComponentAccessor.getCursor_NoClientCode(component), bl);
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    protected void updateCursorOutOfJava() {
    }

    class NativeUpdater
    implements Runnable {
        boolean pending = false;

        NativeUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = false;
            NativeUpdater nativeUpdater = this;
            synchronized (nativeUpdater) {
                if (this.pending) {
                    this.pending = false;
                    bl = true;
                }
            }
            if (bl) {
                GlobalCursorManager.this._updateCursor(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postIfNotPending(Component component, InvocationEvent invocationEvent) {
            boolean bl = false;
            NativeUpdater nativeUpdater = this;
            synchronized (nativeUpdater) {
                if (!this.pending) {
                    bl = true;
                    this.pending = true;
                }
            }
            if (bl) {
                SunToolkit.postEvent(SunToolkit.targetToAppContext(component), invocationEvent);
            }
        }
    }
}

