/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AudioFormat {
    protected Encoding encoding;
    protected float sampleRate;
    protected int sampleSizeInBits;
    protected int channels;
    protected int frameSize;
    protected float frameRate;
    protected boolean bigEndian;
    private HashMap<String, Object> properties;

    public AudioFormat(Encoding encoding, float f, int n, int n2, int n3, float f2, boolean bl) {
        this.encoding = encoding;
        this.sampleRate = f;
        this.sampleSizeInBits = n;
        this.channels = n2;
        this.frameSize = n3;
        this.frameRate = f2;
        this.bigEndian = bl;
        this.properties = null;
    }

    public AudioFormat(Encoding encoding, float f, int n, int n2, int n3, float f2, boolean bl, Map<String, Object> map) {
        this(encoding, f, n, n2, n3, f2, bl);
        this.properties = new HashMap<String, Object>(map);
    }

    public AudioFormat(float f, int n, int n2, boolean bl, boolean bl2) {
        this(bl ? Encoding.PCM_SIGNED : Encoding.PCM_UNSIGNED, f, n, n2, n2 == -1 || n == -1 ? -1 : (n + 7) / 8 * n2, f, bl2);
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleSizeInBits() {
        return this.sampleSizeInBits;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public Map<String, Object> properties() {
        Map map = this.properties == null ? new HashMap(0) : (Map)this.properties.clone();
        return Collections.unmodifiableMap(map);
    }

    public Object getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public boolean matches(AudioFormat audioFormat) {
        return !(!audioFormat.getEncoding().equals(this.getEncoding()) || audioFormat.getSampleRate() != -1.0f && audioFormat.getSampleRate() != this.getSampleRate() || audioFormat.getSampleSizeInBits() != this.getSampleSizeInBits() || audioFormat.getChannels() != this.getChannels() || audioFormat.getFrameSize() != this.getFrameSize() || audioFormat.getFrameRate() != -1.0f && audioFormat.getFrameRate() != this.getFrameRate() || audioFormat.getSampleSizeInBits() > 8 && audioFormat.isBigEndian() != this.isBigEndian());
    }

    public String toString() {
        String string = "";
        if (this.getEncoding() != null) {
            string = this.getEncoding().toString() + " ";
        }
        String string2 = this.getSampleRate() == -1.0f ? "unknown sample rate, " : "" + this.getSampleRate() + " Hz, ";
        String string3 = (float)this.getSampleSizeInBits() == -1.0f ? "unknown bits per sample, " : "" + this.getSampleSizeInBits() + " bit, ";
        String string4 = this.getChannels() == 1 ? "mono, " : (this.getChannels() == 2 ? "stereo, " : (this.getChannels() == -1 ? " unknown number of channels, " : "" + this.getChannels() + " channels, "));
        String string5 = (float)this.getFrameSize() == -1.0f ? "unknown frame size, " : "" + this.getFrameSize() + " bytes/frame, ";
        String string6 = "";
        if ((double)Math.abs(this.getSampleRate() - this.getFrameRate()) > 1.0E-5) {
            string6 = this.getFrameRate() == -1.0f ? "unknown frame rate, " : this.getFrameRate() + " frames/second, ";
        }
        String string7 = "";
        if ((this.getEncoding().equals(Encoding.PCM_SIGNED) || this.getEncoding().equals(Encoding.PCM_UNSIGNED)) && (this.getSampleSizeInBits() > 8 || this.getSampleSizeInBits() == -1)) {
            string7 = this.isBigEndian() ? "big-endian" : "little-endian";
        }
        return string + string2 + string3 + string4 + string5 + string6 + string7;
    }

    public static class Encoding {
        public static final Encoding PCM_SIGNED = new Encoding("PCM_SIGNED");
        public static final Encoding PCM_UNSIGNED = new Encoding("PCM_UNSIGNED");
        public static final Encoding ULAW = new Encoding("ULAW");
        public static final Encoding ALAW = new Encoding("ALAW");
        private String name;

        public Encoding(String string) {
            this.name = string;
        }

        public final boolean equals(Object object) {
            if (this.toString() == null) {
                return object != null && object.toString() == null;
            }
            if (object instanceof Encoding) {
                return this.toString().equals(object.toString());
            }
            return false;
        }

        public final int hashCode() {
            if (this.toString() == null) {
                return 0;
            }
            return this.toString().hashCode();
        }

        public final String toString() {
            return this.name;
        }
    }
}

