/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.InterruptibleChannel;
import sun.misc.SharedSecrets;
import sun.nio.ch.Interruptible;

public abstract class AbstractInterruptibleChannel
implements Channel,
InterruptibleChannel {
    private Object closeLock = new Object();
    private volatile boolean open = true;
    private Interruptible interruptor;
    private volatile boolean interrupted = false;

    protected AbstractInterruptibleChannel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.open) {
                return;
            }
            this.open = false;
            this.implCloseChannel();
        }
    }

    protected abstract void implCloseChannel() throws IOException;

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    protected final void begin() {
        if (this.interruptor == null) {
            this.interruptor = new Interruptible(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void interrupt() {
                    Object object = AbstractInterruptibleChannel.this.closeLock;
                    synchronized (object) {
                        if (!AbstractInterruptibleChannel.this.open) {
                            return;
                        }
                        AbstractInterruptibleChannel.this.interrupted = true;
                        AbstractInterruptibleChannel.this.open = false;
                        try {
                            AbstractInterruptibleChannel.this.implCloseChannel();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            };
        }
        AbstractInterruptibleChannel.blockedOn(this.interruptor);
        if (Thread.currentThread().isInterrupted()) {
            this.interruptor.interrupt();
        }
    }

    protected final void end(boolean bl) throws AsynchronousCloseException {
        AbstractInterruptibleChannel.blockedOn(null);
        if (bl) {
            this.interrupted = false;
            return;
        }
        if (this.interrupted) {
            throw new ClosedByInterruptException();
        }
        if (!this.open) {
            throw new AsynchronousCloseException();
        }
    }

    static void blockedOn(Interruptible interruptible) {
        SharedSecrets.getJavaLangAccess().blockedOn(Thread.currentThread(), interruptible);
    }
}

