/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyRep;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import sun.security.ec.ECPrivateKeyImpl;
import sun.security.ec.ECPublicKeyImpl;
import sun.security.internal.interfaces.TlsMasterSecret;
import sun.security.pkcs11.P11ECKeyFactory;
import sun.security.pkcs11.P11Util;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.SessionKeyRef;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.provider.DSAPrivateKey;
import sun.security.provider.DSAPublicKey;
import sun.security.rsa.RSAPublicKeyImpl;

abstract class P11Key
implements Key {
    private static final String PUBLIC = "public";
    private static final String PRIVATE = "private";
    private static final String SECRET = "secret";
    final String type;
    final Token token;
    final String algorithm;
    final long keyID;
    final int keyLength;
    final boolean tokenObject;
    final boolean sensitive;
    final boolean extractable;
    private final SessionKeyRef sessionKeyRef;
    private static final CK_ATTRIBUTE[] A0 = new CK_ATTRIBUTE[0];

    P11Key(String string, Session session, long l, String string2, int n, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
        this.type = string;
        this.token = session.token;
        this.keyID = l;
        this.algorithm = string2;
        this.keyLength = n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        int n2 = cK_ATTRIBUTEArray == null ? 0 : cK_ATTRIBUTEArray.length;
        for (int i = 0; i < n2; ++i) {
            CK_ATTRIBUTE cK_ATTRIBUTE = cK_ATTRIBUTEArray[i];
            if (cK_ATTRIBUTE.type == 1L) {
                bl = cK_ATTRIBUTE.getBoolean();
                continue;
            }
            if (cK_ATTRIBUTE.type == 259L) {
                bl2 = cK_ATTRIBUTE.getBoolean();
                continue;
            }
            if (cK_ATTRIBUTE.type != 354L) continue;
            bl3 = cK_ATTRIBUTE.getBoolean();
        }
        this.tokenObject = bl;
        this.sensitive = bl2;
        this.extractable = bl3;
        this.sessionKeyRef = !bl ? new SessionKeyRef(this, l, session) : null;
    }

    @Override
    public final String getAlgorithm() {
        this.token.ensureValid();
        return this.algorithm;
    }

    @Override
    public final byte[] getEncoded() {
        byte[] byArray = this.getEncodedInternal();
        return byArray == null ? null : (byte[])byArray.clone();
    }

    abstract byte[] getEncodedInternal();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!this.token.isValid()) {
            return false;
        }
        if (!(object instanceof Key)) {
            return false;
        }
        String string = this.getFormat();
        if (string == null) {
            return false;
        }
        Key key = (Key)object;
        if (!string.equals(key.getFormat())) {
            return false;
        }
        byte[] byArray = this.getEncodedInternal();
        byte[] byArray2 = object instanceof P11Key ? ((P11Key)key).getEncodedInternal() : key.getEncoded();
        return Arrays.equals(byArray, byArray2);
    }

    public int hashCode() {
        if (!this.token.isValid()) {
            return 0;
        }
        byte[] byArray = this.getEncodedInternal();
        if (byArray == null) {
            return 0;
        }
        int n = byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            n += (byArray[i] & 0xFF) * 37;
        }
        return n;
    }

    protected Object writeReplace() throws ObjectStreamException {
        KeyRep.Type type;
        String string = this.getFormat();
        if (this.isPrivate() && "PKCS#8".equals(string)) {
            type = KeyRep.Type.PRIVATE;
        } else if (this.isPublic() && "X.509".equals(string)) {
            type = KeyRep.Type.PUBLIC;
        } else if (this.isSecret() && "RAW".equals(string)) {
            type = KeyRep.Type.SECRET;
        } else {
            throw new NotSerializableException("Cannot serialize sensitive and unextractable keys");
        }
        return new KeyRep(type, this.getAlgorithm(), string, this.getEncoded());
    }

    public String toString() {
        this.token.ensureValid();
        String string = this.token.provider.getName() + " " + this.algorithm + " " + this.type + " key, " + this.keyLength + " bits";
        string = string + " (id " + this.keyID + ", " + (this.tokenObject ? "token" : "session") + " object";
        if (this.isPublic()) {
            string = string + ")";
        } else {
            string = string + ", " + (this.sensitive ? "" : "not ") + "sensitive";
            string = string + ", " + (this.extractable ? "" : "un") + "extractable)";
        }
        return string;
    }

    int keyLength() {
        return this.keyLength;
    }

    boolean isPublic() {
        return this.type == PUBLIC;
    }

    boolean isPrivate() {
        return this.type == PRIVATE;
    }

    boolean isSecret() {
        return this.type == SECRET;
    }

    void fetchAttributes(CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
        Session session = null;
        try {
            session = this.token.getOpSession();
            this.token.p11.C_GetAttributeValue(session.id(), this.keyID, cK_ATTRIBUTEArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException(pKCS11Exception);
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    private static CK_ATTRIBUTE[] getAttributes(Session session, long l, CK_ATTRIBUTE[] cK_ATTRIBUTEArray, CK_ATTRIBUTE[] cK_ATTRIBUTEArray2) {
        if (cK_ATTRIBUTEArray == null) {
            cK_ATTRIBUTEArray = A0;
        }
        for (int i = 0; i < cK_ATTRIBUTEArray2.length; ++i) {
            CK_ATTRIBUTE cK_ATTRIBUTE = cK_ATTRIBUTEArray2[i];
            for (CK_ATTRIBUTE cK_ATTRIBUTE2 : cK_ATTRIBUTEArray) {
                if (cK_ATTRIBUTE.type != cK_ATTRIBUTE2.type || cK_ATTRIBUTE2.pValue == null) continue;
                cK_ATTRIBUTE.pValue = cK_ATTRIBUTE2.pValue;
                break;
            }
            if (cK_ATTRIBUTE.pValue != null) continue;
            for (int j = 0; j < i; ++j) {
                cK_ATTRIBUTEArray2[j].pValue = null;
            }
            try {
                session.token.p11.C_GetAttributeValue(session.id(), l, cK_ATTRIBUTEArray2);
                break;
            }
            catch (PKCS11Exception pKCS11Exception) {
                throw new ProviderException(pKCS11Exception);
            }
        }
        return cK_ATTRIBUTEArray2;
    }

    static SecretKey secretKey(Session session, long l, String string, int n, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
        cK_ATTRIBUTEArray = P11Key.getAttributes(session, l, cK_ATTRIBUTEArray, new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L), new CK_ATTRIBUTE(259L), new CK_ATTRIBUTE(354L)});
        return new P11SecretKey(session, l, string, n, cK_ATTRIBUTEArray);
    }

    static SecretKey masterSecretKey(Session session, long l, String string, int n, CK_ATTRIBUTE[] cK_ATTRIBUTEArray, int n2, int n3) {
        cK_ATTRIBUTEArray = P11Key.getAttributes(session, l, cK_ATTRIBUTEArray, new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L), new CK_ATTRIBUTE(259L), new CK_ATTRIBUTE(354L)});
        return new P11TlsMasterSecretKey(session, l, string, n, cK_ATTRIBUTEArray, n2, n3);
    }

    static PublicKey publicKey(Session session, long l, String string, int n, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
        if (string.equals("RSA")) {
            return new P11RSAPublicKey(session, l, string, n, cK_ATTRIBUTEArray);
        }
        if (string.equals("DSA")) {
            return new P11DSAPublicKey(session, l, string, n, cK_ATTRIBUTEArray);
        }
        if (string.equals("DH")) {
            return new P11DHPublicKey(session, l, string, n, cK_ATTRIBUTEArray);
        }
        if (string.equals("EC")) {
            return new P11ECPublicKey(session, l, string, n, cK_ATTRIBUTEArray);
        }
        throw new ProviderException("Unknown public key algorithm " + string);
    }

    static PrivateKey privateKey(Session session, long l, String string, int n, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
        if ((cK_ATTRIBUTEArray = P11Key.getAttributes(session, l, cK_ATTRIBUTEArray, new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L), new CK_ATTRIBUTE(259L), new CK_ATTRIBUTE(354L)}))[1].getBoolean() || !cK_ATTRIBUTEArray[2].getBoolean()) {
            return new P11PrivateKey(session, l, string, n, cK_ATTRIBUTEArray);
        }
        if (string.equals("RSA")) {
            boolean bl;
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(290L)};
            try {
                session.token.p11.C_GetAttributeValue(session.id(), l, cK_ATTRIBUTEArray2);
                bl = cK_ATTRIBUTEArray2[0].pValue instanceof byte[];
            }
            catch (PKCS11Exception pKCS11Exception) {
                bl = false;
            }
            if (bl) {
                return new P11RSAPrivateKey(session, l, string, n, cK_ATTRIBUTEArray);
            }
            return new P11RSAPrivateNonCRTKey(session, l, string, n, cK_ATTRIBUTEArray);
        }
        if (string.equals("DSA")) {
            return new P11DSAPrivateKey(session, l, string, n, cK_ATTRIBUTEArray);
        }
        if (string.equals("DH")) {
            return new P11DHPrivateKey(session, l, string, n, cK_ATTRIBUTEArray);
        }
        if (string.equals("EC")) {
            return new P11ECPrivateKey(session, l, string, n, cK_ATTRIBUTEArray);
        }
        throw new ProviderException("Unknown private key algorithm " + string);
    }

    private static final class P11ECPublicKey
    extends P11Key
    implements ECPublicKey {
        private ECPoint w;
        private ECParameterSpec params;
        private byte[] encoded;

        P11ECPublicKey(Session session, long l, String string, int n, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
            super(P11Key.PUBLIC, session, l, string, n, cK_ATTRIBUTEArray);
        }

        private synchronized void fetchValues() {
            this.token.ensureValid();
            if (this.w != null) {
                return;
            }
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L), new CK_ATTRIBUTE(384L)};
            this.fetchAttributes(cK_ATTRIBUTEArray);
            try {
                this.params = P11ECKeyFactory.decodeParameters(cK_ATTRIBUTEArray[1].getByteArray());
                this.w = P11ECKeyFactory.decodePoint(cK_ATTRIBUTEArray[0].getByteArray(), this.params.getCurve());
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not parse key values", exception);
            }
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            return "X.509";
        }

        @Override
        synchronized byte[] getEncodedInternal() {
            this.token.ensureValid();
            if (this.encoded == null) {
                this.fetchValues();
                try {
                    ECPublicKeyImpl eCPublicKeyImpl = new ECPublicKeyImpl(this.w, this.params);
                    this.encoded = eCPublicKeyImpl.getEncoded();
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new ProviderException(invalidKeyException);
                }
            }
            return this.encoded;
        }

        @Override
        public ECPoint getW() {
            this.fetchValues();
            return this.w;
        }

        @Override
        public ECParameterSpec getParams() {
            this.fetchValues();
            return this.params;
        }

        @Override
        public String toString() {
            this.fetchValues();
            return super.toString() + "\n  public x coord: " + this.w.getAffineX() + "\n  public y coord: " + this.w.getAffineY() + "\n  parameters: " + this.params;
        }
    }

    private static final class P11ECPrivateKey
    extends P11Key
    implements ECPrivateKey {
        private BigInteger s;
        private ECParameterSpec params;
        private byte[] encoded;

        P11ECPrivateKey(Session session, long l, String string, int n, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
            super(P11Key.PRIVATE, session, l, string, n, cK_ATTRIBUTEArray);
        }

        private synchronized void fetchValues() {
            this.token.ensureValid();
            if (this.s != null) {
                return;
            }
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(384L, this.params)};
            this.fetchAttributes(cK_ATTRIBUTEArray);
            this.s = cK_ATTRIBUTEArray[0].getBigInteger();
            try {
                this.params = P11ECKeyFactory.decodeParameters(cK_ATTRIBUTEArray[1].getByteArray());
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not parse key values", exception);
            }
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            return "PKCS#8";
        }

        @Override
        synchronized byte[] getEncodedInternal() {
            this.token.ensureValid();
            if (this.encoded == null) {
                this.fetchValues();
                try {
                    ECPrivateKeyImpl eCPrivateKeyImpl = new ECPrivateKeyImpl(this.s, this.params);
                    this.encoded = eCPrivateKeyImpl.getEncoded();
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new ProviderException(invalidKeyException);
                }
            }
            return this.encoded;
        }

        @Override
        public BigInteger getS() {
            this.fetchValues();
            return this.s;
        }

        @Override
        public ECParameterSpec getParams() {
            this.fetchValues();
            return this.params;
        }

        @Override
        public String toString() {
            this.fetchValues();
            return super.toString() + "\n  private value:  " + this.s + "\n  parameters: " + this.params;
        }
    }

    private static final class P11DHPublicKey
    extends P11Key
    implements DHPublicKey {
        private BigInteger y;
        private DHParameterSpec params;
        private byte[] encoded;

        P11DHPublicKey(Session session, long l, String string, int n, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
            super(P11Key.PUBLIC, session, l, string, n, cK_ATTRIBUTEArray);
        }

        private synchronized void fetchValues() {
            this.token.ensureValid();
            if (this.y != null) {
                return;
            }
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(304L), new CK_ATTRIBUTE(306L)};
            this.fetchAttributes(cK_ATTRIBUTEArray);
            this.y = cK_ATTRIBUTEArray[0].getBigInteger();
            this.params = new DHParameterSpec(cK_ATTRIBUTEArray[1].getBigInteger(), cK_ATTRIBUTEArray[2].getBigInteger());
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            return "X.509";
        }

        @Override
        synchronized byte[] getEncodedInternal() {
            this.token.ensureValid();
            if (this.encoded == null) {
                this.fetchValues();
                try {
                    DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(this.y, this.params.getP(), this.params.getG());
                    KeyFactory keyFactory = KeyFactory.getInstance("DH", P11Util.getSunJceProvider());
                    PublicKey publicKey = keyFactory.generatePublic(dHPublicKeySpec);
                    this.encoded = publicKey.getEncoded();
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new ProviderException(generalSecurityException);
                }
            }
            return this.encoded;
        }

        @Override
        public BigInteger getY() {
            this.fetchValues();
            return this.y;
        }

        @Override
        public DHParameterSpec getParams() {
            this.fetchValues();
            return this.params;
        }

        @Override
        public String toString() {
            this.fetchValues();
            return super.toString() + "\n  y: " + this.y + "\n  p: " + this.params.getP() + "\n  g: " + this.params.getG();
        }
    }

    private static final class P11DHPrivateKey
    extends P11Key
    implements DHPrivateKey {
        private BigInteger x;
        private DHParameterSpec params;
        private byte[] encoded;

        P11DHPrivateKey(Session session, long l, String string, int n, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
            super(P11Key.PRIVATE, session, l, string, n, cK_ATTRIBUTEArray);
        }

        private synchronized void fetchValues() {
            this.token.ensureValid();
            if (this.x != null) {
                return;
            }
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(304L), new CK_ATTRIBUTE(306L)};
            this.fetchAttributes(cK_ATTRIBUTEArray);
            this.x = cK_ATTRIBUTEArray[0].getBigInteger();
            this.params = new DHParameterSpec(cK_ATTRIBUTEArray[1].getBigInteger(), cK_ATTRIBUTEArray[2].getBigInteger());
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            return "PKCS#8";
        }

        @Override
        synchronized byte[] getEncodedInternal() {
            this.token.ensureValid();
            if (this.encoded == null) {
                this.fetchValues();
                try {
                    DHPrivateKeySpec dHPrivateKeySpec = new DHPrivateKeySpec(this.x, this.params.getP(), this.params.getG());
                    KeyFactory keyFactory = KeyFactory.getInstance("DH", P11Util.getSunJceProvider());
                    PrivateKey privateKey = keyFactory.generatePrivate(dHPrivateKeySpec);
                    this.encoded = privateKey.getEncoded();
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new ProviderException(generalSecurityException);
                }
            }
            return this.encoded;
        }

        @Override
        public BigInteger getX() {
            this.fetchValues();
            return this.x;
        }

        @Override
        public DHParameterSpec getParams() {
            this.fetchValues();
            return this.params;
        }

        @Override
        public String toString() {
            this.fetchValues();
            return super.toString() + "\n  x: " + this.x + "\n  p: " + this.params.getP() + "\n  g: " + this.params.getG();
        }
    }

    private static final class P11DSAPrivateKey
    extends P11Key
    implements java.security.interfaces.DSAPrivateKey {
        private BigInteger x;
        private DSAParams params;
        private byte[] encoded;

        P11DSAPrivateKey(Session session, long l, String string, int n, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
            super(P11Key.PRIVATE, session, l, string, n, cK_ATTRIBUTEArray);
        }

        private synchronized void fetchValues() {
            this.token.ensureValid();
            if (this.x != null) {
                return;
            }
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(304L), new CK_ATTRIBUTE(305L), new CK_ATTRIBUTE(306L)};
            this.fetchAttributes(cK_ATTRIBUTEArray);
            this.x = cK_ATTRIBUTEArray[0].getBigInteger();
            this.params = new DSAParameterSpec(cK_ATTRIBUTEArray[1].getBigInteger(), cK_ATTRIBUTEArray[2].getBigInteger(), cK_ATTRIBUTEArray[3].getBigInteger());
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            return "PKCS#8";
        }

        @Override
        synchronized byte[] getEncodedInternal() {
            this.token.ensureValid();
            if (this.encoded == null) {
                this.fetchValues();
                try {
                    DSAPrivateKey dSAPrivateKey = new DSAPrivateKey(this.x, this.params.getP(), this.params.getQ(), this.params.getG());
                    this.encoded = dSAPrivateKey.getEncoded();
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new ProviderException(invalidKeyException);
                }
            }
            return this.encoded;
        }

        @Override
        public BigInteger getX() {
            this.fetchValues();
            return this.x;
        }

        @Override
        public DSAParams getParams() {
            this.fetchValues();
            return this.params;
        }

        @Override
        public String toString() {
            this.fetchValues();
            return super.toString() + "\n  x: " + this.x + "\n  p: " + this.params.getP() + "\n  q: " + this.params.getQ() + "\n  g: " + this.params.getG();
        }
    }

    private static final class P11DSAPublicKey
    extends P11Key
    implements java.security.interfaces.DSAPublicKey {
        private BigInteger y;
        private DSAParams params;
        private byte[] encoded;

        P11DSAPublicKey(Session session, long l, String string, int n, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
            super(P11Key.PUBLIC, session, l, string, n, cK_ATTRIBUTEArray);
        }

        private synchronized void fetchValues() {
            this.token.ensureValid();
            if (this.y != null) {
                return;
            }
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(304L), new CK_ATTRIBUTE(305L), new CK_ATTRIBUTE(306L)};
            this.fetchAttributes(cK_ATTRIBUTEArray);
            this.y = cK_ATTRIBUTEArray[0].getBigInteger();
            this.params = new DSAParameterSpec(cK_ATTRIBUTEArray[1].getBigInteger(), cK_ATTRIBUTEArray[2].getBigInteger(), cK_ATTRIBUTEArray[3].getBigInteger());
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            return "X.509";
        }

        @Override
        synchronized byte[] getEncodedInternal() {
            this.token.ensureValid();
            if (this.encoded == null) {
                this.fetchValues();
                try {
                    DSAPublicKey dSAPublicKey = new DSAPublicKey(this.y, this.params.getP(), this.params.getQ(), this.params.getG());
                    this.encoded = dSAPublicKey.getEncoded();
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new ProviderException(invalidKeyException);
                }
            }
            return this.encoded;
        }

        @Override
        public BigInteger getY() {
            this.fetchValues();
            return this.y;
        }

        @Override
        public DSAParams getParams() {
            this.fetchValues();
            return this.params;
        }

        @Override
        public String toString() {
            this.fetchValues();
            return super.toString() + "\n  y: " + this.y + "\n  p: " + this.params.getP() + "\n  q: " + this.params.getQ() + "\n  g: " + this.params.getG();
        }
    }

    private static final class P11RSAPublicKey
    extends P11Key
    implements RSAPublicKey {
        private BigInteger n;
        private BigInteger e;
        private byte[] encoded;

        P11RSAPublicKey(Session session, long l, String string, int n, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
            super(P11Key.PUBLIC, session, l, string, n, cK_ATTRIBUTEArray);
        }

        private synchronized void fetchValues() {
            this.token.ensureValid();
            if (this.n != null) {
                return;
            }
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L), new CK_ATTRIBUTE(290L)};
            this.fetchAttributes(cK_ATTRIBUTEArray);
            this.n = cK_ATTRIBUTEArray[0].getBigInteger();
            this.e = cK_ATTRIBUTEArray[1].getBigInteger();
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            return "X.509";
        }

        @Override
        synchronized byte[] getEncodedInternal() {
            this.token.ensureValid();
            if (this.encoded == null) {
                this.fetchValues();
                try {
                    this.encoded = new RSAPublicKeyImpl(this.n, this.e).getEncoded();
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new ProviderException(invalidKeyException);
                }
            }
            return this.encoded;
        }

        @Override
        public BigInteger getModulus() {
            this.fetchValues();
            return this.n;
        }

        @Override
        public BigInteger getPublicExponent() {
            this.fetchValues();
            return this.e;
        }

        @Override
        public String toString() {
            this.fetchValues();
            return super.toString() + "\n  modulus: " + this.n + "\n  public exponent: " + this.e;
        }
    }

    private static final class P11RSAPrivateNonCRTKey
    extends P11Key
    implements RSAPrivateKey {
        private BigInteger n;
        private BigInteger d;
        private byte[] encoded;

        P11RSAPrivateNonCRTKey(Session session, long l, String string, int n, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
            super(P11Key.PRIVATE, session, l, string, n, cK_ATTRIBUTEArray);
        }

        private synchronized void fetchValues() {
            this.token.ensureValid();
            if (this.n != null) {
                return;
            }
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L), new CK_ATTRIBUTE(291L)};
            this.fetchAttributes(cK_ATTRIBUTEArray);
            this.n = cK_ATTRIBUTEArray[0].getBigInteger();
            this.d = cK_ATTRIBUTEArray[1].getBigInteger();
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            return "PKCS#8";
        }

        @Override
        synchronized byte[] getEncodedInternal() {
            this.token.ensureValid();
            if (this.encoded == null) {
                this.fetchValues();
                try {
                    KeyFactory keyFactory = KeyFactory.getInstance("RSA", P11Util.getSunRsaSignProvider());
                    Key key = keyFactory.translateKey(this);
                    this.encoded = key.getEncoded();
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new ProviderException(generalSecurityException);
                }
            }
            return this.encoded;
        }

        @Override
        public BigInteger getModulus() {
            this.fetchValues();
            return this.n;
        }

        @Override
        public BigInteger getPrivateExponent() {
            this.fetchValues();
            return this.d;
        }

        @Override
        public String toString() {
            this.fetchValues();
            StringBuilder stringBuilder = new StringBuilder(super.toString());
            stringBuilder.append("\n  modulus:          ");
            stringBuilder.append(this.n);
            stringBuilder.append("\n  private exponent: ");
            stringBuilder.append(this.d);
            return stringBuilder.toString();
        }
    }

    private static final class P11RSAPrivateKey
    extends P11Key
    implements RSAPrivateCrtKey {
        private BigInteger n;
        private BigInteger e;
        private BigInteger d;
        private BigInteger p;
        private BigInteger q;
        private BigInteger pe;
        private BigInteger qe;
        private BigInteger coeff;
        private byte[] encoded;

        P11RSAPrivateKey(Session session, long l, String string, int n, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
            super(P11Key.PRIVATE, session, l, string, n, cK_ATTRIBUTEArray);
        }

        private synchronized void fetchValues() {
            this.token.ensureValid();
            if (this.n != null) {
                return;
            }
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L), new CK_ATTRIBUTE(290L), new CK_ATTRIBUTE(291L), new CK_ATTRIBUTE(292L), new CK_ATTRIBUTE(293L), new CK_ATTRIBUTE(294L), new CK_ATTRIBUTE(295L), new CK_ATTRIBUTE(296L)};
            this.fetchAttributes(cK_ATTRIBUTEArray);
            this.n = cK_ATTRIBUTEArray[0].getBigInteger();
            this.e = cK_ATTRIBUTEArray[1].getBigInteger();
            this.d = cK_ATTRIBUTEArray[2].getBigInteger();
            this.p = cK_ATTRIBUTEArray[3].getBigInteger();
            this.q = cK_ATTRIBUTEArray[4].getBigInteger();
            this.pe = cK_ATTRIBUTEArray[5].getBigInteger();
            this.qe = cK_ATTRIBUTEArray[6].getBigInteger();
            this.coeff = cK_ATTRIBUTEArray[7].getBigInteger();
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            return "PKCS#8";
        }

        @Override
        synchronized byte[] getEncodedInternal() {
            this.token.ensureValid();
            if (this.encoded == null) {
                this.fetchValues();
                try {
                    KeyFactory keyFactory = KeyFactory.getInstance("RSA", P11Util.getSunRsaSignProvider());
                    Key key = keyFactory.translateKey(this);
                    this.encoded = key.getEncoded();
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new ProviderException(generalSecurityException);
                }
            }
            return this.encoded;
        }

        @Override
        public BigInteger getModulus() {
            this.fetchValues();
            return this.n;
        }

        @Override
        public BigInteger getPublicExponent() {
            this.fetchValues();
            return this.e;
        }

        @Override
        public BigInteger getPrivateExponent() {
            this.fetchValues();
            return this.d;
        }

        @Override
        public BigInteger getPrimeP() {
            this.fetchValues();
            return this.p;
        }

        @Override
        public BigInteger getPrimeQ() {
            this.fetchValues();
            return this.q;
        }

        @Override
        public BigInteger getPrimeExponentP() {
            this.fetchValues();
            return this.pe;
        }

        @Override
        public BigInteger getPrimeExponentQ() {
            this.fetchValues();
            return this.qe;
        }

        @Override
        public BigInteger getCrtCoefficient() {
            this.fetchValues();
            return this.coeff;
        }

        @Override
        public String toString() {
            this.fetchValues();
            StringBuilder stringBuilder = new StringBuilder(super.toString());
            stringBuilder.append("\n  modulus:          ");
            stringBuilder.append(this.n);
            stringBuilder.append("\n  public exponent:  ");
            stringBuilder.append(this.e);
            stringBuilder.append("\n  private exponent: ");
            stringBuilder.append(this.d);
            stringBuilder.append("\n  prime p:          ");
            stringBuilder.append(this.p);
            stringBuilder.append("\n  prime q:          ");
            stringBuilder.append(this.q);
            stringBuilder.append("\n  prime exponent p: ");
            stringBuilder.append(this.pe);
            stringBuilder.append("\n  prime exponent q: ");
            stringBuilder.append(this.qe);
            stringBuilder.append("\n  crt coefficient:  ");
            stringBuilder.append(this.coeff);
            return stringBuilder.toString();
        }
    }

    private static class P11TlsMasterSecretKey
    extends P11SecretKey
    implements TlsMasterSecret {
        private final int majorVersion;
        private final int minorVersion;

        P11TlsMasterSecretKey(Session session, long l, String string, int n, CK_ATTRIBUTE[] cK_ATTRIBUTEArray, int n2, int n3) {
            super(session, l, string, n, cK_ATTRIBUTEArray);
            this.majorVersion = n2;
            this.minorVersion = n3;
        }

        @Override
        public int getMajorVersion() {
            return this.majorVersion;
        }

        @Override
        public int getMinorVersion() {
            return this.minorVersion;
        }
    }

    private static class P11SecretKey
    extends P11Key
    implements SecretKey {
        private volatile byte[] encoded;

        P11SecretKey(Session session, long l, String string, int n, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
            super(P11Key.SECRET, session, l, string, n, cK_ATTRIBUTEArray);
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            if (this.sensitive || !this.extractable) {
                return null;
            }
            return "RAW";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        byte[] getEncodedInternal() {
            this.token.ensureValid();
            if (this.getFormat() == null) {
                return null;
            }
            byte[] byArray = this.encoded;
            if (byArray == null) {
                P11SecretKey p11SecretKey = this;
                synchronized (p11SecretKey) {
                    byArray = this.encoded;
                    if (byArray == null) {
                        Session session = null;
                        try {
                            session = this.token.getOpSession();
                            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
                            this.token.p11.C_GetAttributeValue(session.id(), this.keyID, cK_ATTRIBUTEArray);
                            byArray = cK_ATTRIBUTEArray[0].getByteArray();
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            throw new ProviderException(pKCS11Exception);
                        }
                        finally {
                            this.token.releaseSession(session);
                        }
                        this.encoded = byArray;
                    }
                }
            }
            return byArray;
        }
    }

    private static final class P11PrivateKey
    extends P11Key
    implements PrivateKey {
        P11PrivateKey(Session session, long l, String string, int n, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
            super(P11Key.PRIVATE, session, l, string, n, cK_ATTRIBUTEArray);
        }

        @Override
        public String getFormat() {
            this.token.ensureValid();
            return null;
        }

        @Override
        byte[] getEncodedInternal() {
            this.token.ensureValid();
            return null;
        }
    }
}

