/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.ServicePermission;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.internal.EncTicketPart;
import sun.security.krb5.internal.Ticket;
import sun.security.ssl.Debug;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.KerberosPreMasterSecret;
import sun.security.ssl.ProtocolVersion;

final class KerberosClientKeyExchange
extends HandshakeMessage {
    private KerberosPreMasterSecret preMaster;
    private byte[] encodedTicket;
    private KerberosPrincipal peerPrincipal;
    private KerberosPrincipal localPrincipal;

    KerberosClientKeyExchange(String string, boolean bl, AccessControlContext accessControlContext, ProtocolVersion protocolVersion, SecureRandom secureRandom) throws IOException {
        KerberosTicket kerberosTicket = KerberosClientKeyExchange.getServiceTicket(string, bl, accessControlContext);
        this.encodedTicket = kerberosTicket.getEncoded();
        this.peerPrincipal = kerberosTicket.getServer();
        this.localPrincipal = kerberosTicket.getClient();
        EncryptionKey encryptionKey = new EncryptionKey(kerberosTicket.getSessionKeyType(), kerberosTicket.getSessionKey().getEncoded());
        this.preMaster = new KerberosPreMasterSecret(protocolVersion, secureRandom, encryptionKey);
    }

    KerberosClientKeyExchange(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, SecureRandom secureRandom, HandshakeInStream handshakeInStream, KerberosKey[] kerberosKeyArray) throws IOException {
        this.encodedTicket = handshakeInStream.getBytes16();
        if (debug != null && Debug.isOn("verbose")) {
            Debug.println(System.out, "encoded Kerberos service ticket", this.encodedTicket);
        }
        EncryptionKey encryptionKey = null;
        try {
            Ticket ticket = new Ticket(this.encodedTicket);
            EncryptedData encryptedData = ticket.encPart;
            PrincipalName principalName = ticket.sname;
            Realm realm = ticket.realm;
            String string = kerberosKeyArray[0].getPrincipal().getName();
            String string2 = principalName.toString().concat("@" + realm.toString());
            if (!string2.equals(string)) {
                if (debug != null && Debug.isOn("handshake")) {
                    System.out.println("Service principal in Ticket does not match associated principal in KerberosKey");
                }
                throw new IOException("Server principal is " + string + " but ticket is for " + string2);
            }
            int n = encryptedData.getEType();
            KerberosKey kerberosKey = KerberosClientKeyExchange.findKey(n, kerberosKeyArray);
            if (kerberosKey == null) {
                throw new IOException("Cannot find key of appropriate type to decrypt ticket - need etype " + n);
            }
            EncryptionKey encryptionKey2 = new EncryptionKey(n, kerberosKey.getEncoded());
            byte[] byArray = encryptedData.decrypt(encryptionKey2, 2);
            byte[] byArray2 = encryptedData.reset(byArray, true);
            EncTicketPart encTicketPart = new EncTicketPart(byArray2);
            this.peerPrincipal = new KerberosPrincipal(encTicketPart.cname.getName());
            this.localPrincipal = new KerberosPrincipal(principalName.getName());
            encryptionKey = encTicketPart.key;
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("server principal: " + string);
                System.out.println("realm: " + encTicketPart.crealm.toString());
                System.out.println("cname: " + encTicketPart.cname.toString());
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("KerberosWrapper error getting session key, generating random secret (" + exception.getMessage() + ")");
            }
            encryptionKey = null;
        }
        handshakeInStream.getBytes16();
        this.preMaster = encryptionKey != null ? new KerberosPreMasterSecret(protocolVersion, protocolVersion2, secureRandom, handshakeInStream, encryptionKey) : new KerberosPreMasterSecret(protocolVersion, secureRandom);
    }

    @Override
    int messageType() {
        return 16;
    }

    @Override
    int messageLength() {
        return 6 + this.encodedTicket.length + this.preMaster.getEncrypted().length;
    }

    @Override
    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        handshakeOutStream.putBytes16(this.encodedTicket);
        handshakeOutStream.putBytes16(null);
        handshakeOutStream.putBytes16(this.preMaster.getEncrypted());
    }

    @Override
    void print(PrintStream printStream) throws IOException {
        printStream.println("*** ClientKeyExchange, Kerberos");
        if (debug != null && Debug.isOn("verbose")) {
            Debug.println(printStream, "Kerberos service ticket", this.encodedTicket);
            Debug.println(printStream, "Random Secret", this.preMaster.getUnencrypted());
            Debug.println(printStream, "Encrypted random Secret", this.preMaster.getEncrypted());
        }
    }

    private static KerberosTicket getServiceTicket(String string, boolean bl, final AccessControlContext accessControlContext) throws IOException {
        PrincipalName principalName;
        String string2;
        String string3 = string;
        if (bl) {
            string3 = string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String string;
                    try {
                        string = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException unknownHostException) {
                        string = "localhost";
                    }
                    return string;
                }
            });
        }
        string2 = "host/" + string3;
        try {
            principalName = new PrincipalName(string2, 3);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Invalid service principal name: " + string2);
            iOException.initCause(exception);
            throw iOException;
        }
        String string4 = principalName.getRealmAsString();
        final String string5 = principalName.toString();
        final String string6 = "krbtgt/" + string4 + "@" + string4;
        final String string7 = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ServicePermission(string5, "initiate"), accessControlContext);
        }
        try {
            KerberosTicket kerberosTicket = AccessController.doPrivileged(new PrivilegedExceptionAction<KerberosTicket>(){

                @Override
                public KerberosTicket run() throws Exception {
                    return Krb5Util.getTicketFromSubjectAndTgs((GSSCaller)GSSCaller.CALLER_SSL_CLIENT, (String)string7, (String)string5, (String)string6, (AccessControlContext)accessControlContext);
                }
            });
            if (kerberosTicket == null) {
                throw new IOException("Failed to find any kerberos service ticket for " + string5);
            }
            return kerberosTicket;
        }
        catch (PrivilegedActionException privilegedActionException) {
            IOException iOException = new IOException("Attempt to obtain kerberos service ticket for " + string5 + " failed!");
            iOException.initCause(privilegedActionException);
            throw iOException;
        }
    }

    KerberosPreMasterSecret getPreMasterSecret() {
        return this.preMaster;
    }

    KerberosPrincipal getPeerPrincipal() {
        return this.peerPrincipal;
    }

    KerberosPrincipal getLocalPrincipal() {
        return this.localPrincipal;
    }

    private static KerberosKey findKey(int n, KerberosKey[] kerberosKeyArray) {
        int n2;
        int n3;
        for (n3 = 0; n3 < kerberosKeyArray.length; ++n3) {
            n2 = kerberosKeyArray[n3].getKeyType();
            if (n != n2) continue;
            return kerberosKeyArray[n3];
        }
        if (n == 1 || n == 3) {
            for (n3 = 0; n3 < kerberosKeyArray.length; ++n3) {
                n2 = kerberosKeyArray[n3].getKeyType();
                if (n2 != 1 && n2 != 3) continue;
                return new KerberosKey(kerberosKeyArray[n3].getPrincipal(), kerberosKeyArray[n3].getEncoded(), n, kerberosKeyArray[n3].getVersionNumber());
            }
        }
        return null;
    }
}

