/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.HashMap;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmUrlToBounds {
    public static Bounds parse(String url) {
        int i = url.indexOf(63);
        if (i == -1) {
            return null;
        }
        String[] args = url.substring(i + 1).split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String arg : args) {
            int eq = arg.indexOf(61);
            if (eq == -1) continue;
            map.put(arg.substring(0, eq), arg.substring(eq + 1));
        }
        Bounds b = null;
        try {
            if (map.containsKey("bbox")) {
                String[] bbox = ((String)map.get("bbox")).split(",");
                b = new Bounds(new LatLon(Double.parseDouble(bbox[1]), Double.parseDouble(bbox[0])), new LatLon(Double.parseDouble(bbox[3]), Double.parseDouble(bbox[2])));
            } else if (map.containsKey("minlat")) {
                String s = (String)map.get("minlat");
                Double minlat = Double.parseDouble(s);
                s = (String)map.get("minlon");
                Double minlon = Double.parseDouble(s);
                s = map.get("maxlat");
                Double maxlat = Double.parseDouble(s);
                s = map.get("maxlon");
                Double maxlon = Double.parseDouble(s);
                b = new Bounds(new LatLon(minlat, minlon), new LatLon(maxlat, maxlon));
            } else {
                double size = 180.0 / Math.pow(2.0, Integer.parseInt((String)map.get("zoom")));
                b = new Bounds(new LatLon(OsmUrlToBounds.parseDouble(map, "lat") - size / 2.0, OsmUrlToBounds.parseDouble(map, "lon") - size), new LatLon(OsmUrlToBounds.parseDouble(map, "lat") + size / 2.0, OsmUrlToBounds.parseDouble(map, "lon") + size));
            }
        }
        catch (NumberFormatException x) {
        }
        catch (NullPointerException x) {
            // empty catch block
        }
        return b;
    }

    private static double parseDouble(HashMap<String, String> map, String key) {
        if (map.containsKey(key)) {
            return Double.parseDouble(map.get(key));
        }
        return Double.parseDouble(map.get("m" + key));
    }

    public static int getZoom(Bounds b) {
        int zoom;
        double latMin = Math.log(Math.tan(0.7853981633974483 + b.min.lat() / 180.0 * Math.PI / 2.0)) * 180.0 / Math.PI;
        double latMax = Math.log(Math.tan(0.7853981633974483 + b.max.lat() / 180.0 * Math.PI / 2.0)) * 180.0 / Math.PI;
        double size = Math.max(Math.abs(latMax - latMin), Math.abs(b.max.lon() - b.min.lon()));
        for (zoom = 0; zoom <= 20 && !(size >= 180.0); size *= 2.0, ++zoom) {
        }
        return zoom;
    }

    public static String getURL(Bounds b) {
        return OsmUrlToBounds.getURL(b.getCenter(), OsmUrlToBounds.getZoom(b));
    }

    public static String getURL(LatLon pos, int zoom) {
        int decimals = (int)Math.pow(10.0, zoom / 3);
        double lat = Math.round(pos.lat() * (double)decimals);
        double lon = Math.round(pos.lon() * (double)decimals);
        return new String("http://www.openstreetmap.org/?lat=" + (lat /= (double)decimals) + "&lon=" + (lon /= (double)decimals) + "&zoom=" + zoom);
    }
}

