/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.DateUtils;

public class OsmWriter
extends XmlWriter
implements Visitor {
    public final String DEFAULT_API_VERSION = "0.6";
    private long newIdCounter = -1L;
    public HashMap<OsmPrimitive, Long> usedNewIds = new HashMap();
    private boolean osmConform;
    private boolean withBody = true;
    private String version;
    private Changeset changeset;

    public OsmWriter(PrintWriter out, boolean osmConform, String version) {
        super(out);
        this.osmConform = osmConform;
        this.version = version == null ? "0.6" : version;
    }

    public void setWithBody(boolean wb) {
        this.withBody = wb;
    }

    public void setChangeset(Changeset cs) {
        this.changeset = cs;
    }

    public void setVersion(String v) {
        this.version = v;
    }

    public void header() {
        this.out.println("<?xml version='1.0' encoding='UTF-8'?>");
        this.out.print("<osm version='");
        this.out.print(this.version);
        this.out.println("' generator='JOSM'>");
    }

    public void footer() {
        this.out.println("</osm>");
    }

    public void writeContent(DataSet ds) {
        for (Node n : ds.nodes) {
            if (!this.shouldWrite(n)) continue;
            this.visit(n);
        }
        for (Way w : ds.ways) {
            if (!this.shouldWrite(w)) continue;
            this.visit(w);
        }
        for (Relation e : ds.relations) {
            if (!this.shouldWrite(e)) continue;
            this.visit(e);
        }
    }

    private boolean shouldWrite(OsmPrimitive osm) {
        return !osm.isNew() || !osm.isDeleted();
    }

    public void writeDataSources(DataSet ds) {
        for (DataSource s : ds.dataSources) {
            this.out.println("  <bounds minlat='" + s.bounds.min.lat() + "' minlon='" + s.bounds.min.lon() + "' maxlat='" + s.bounds.max.lat() + "' maxlon='" + s.bounds.max.lon() + "' origin='" + XmlWriter.encode(s.origin) + "' />");
        }
    }

    public void visit(Node n) {
        if (n.incomplete) {
            return;
        }
        this.addCommon(n, "node");
        this.out.print(" lat='" + n.getCoor().lat() + "' lon='" + n.getCoor().lon() + "'");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.addTags(n, "node", true);
        }
    }

    public void visit(Way w) {
        if (w.incomplete) {
            return;
        }
        this.addCommon(w, "way");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.out.println(">");
            for (Node n : w.getNodes()) {
                this.out.println("    <nd ref='" + this.getUsedId(n) + "' />");
            }
            this.addTags(w, "way", false);
        }
    }

    public void visit(Relation e) {
        if (e.incomplete) {
            return;
        }
        this.addCommon(e, "relation");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.out.println(">");
            for (RelationMember em : e.getMembers()) {
                this.out.print("    <member type='");
                this.out.print(OsmPrimitiveType.from(em.getMember()).getAPIName());
                this.out.println("' ref='" + this.getUsedId(em.getMember()) + "' role='" + XmlWriter.encode(em.getRole()) + "' />");
            }
            this.addTags(e, "relation", false);
        }
    }

    public void visit(Changeset cs) {
        this.out.print("  <changeset ");
        this.out.print(" id='" + cs.getId() + "'");
        if (cs.getUser() != null) {
            this.out.print(" user='" + cs.getUser().getName() + "'");
            this.out.print(" uid='" + cs.getUser().getId() + "'");
        }
        if (cs.getCreatedAt() != null) {
            this.out.print(" created_at='" + DateUtils.fromDate(cs.getCreatedAt()) + "'");
        }
        if (cs.getClosedAt() != null) {
            this.out.print(" closed_at='" + DateUtils.fromDate(cs.getClosedAt()) + "'");
        }
        this.out.print(" open='" + (cs.isOpen() ? "true" : "false") + "'");
        if (cs.getMin() != null) {
            this.out.print(" min_lon='" + cs.getMin().lonToString(CoordinateFormat.DECIMAL_DEGREES) + "'");
            this.out.print(" min_lat='" + cs.getMin().latToString(CoordinateFormat.DECIMAL_DEGREES) + "'");
        }
        if (cs.getMax() != null) {
            this.out.print(" max_lon='" + cs.getMin().lonToString(CoordinateFormat.DECIMAL_DEGREES) + "'");
            this.out.print(" max_lat='" + cs.getMin().latToString(CoordinateFormat.DECIMAL_DEGREES) + "'");
        }
        this.out.println(">");
        this.addTags(cs, "changeset", false);
    }

    private long getUsedId(OsmPrimitive osm) {
        long l;
        if (!osm.isNew()) {
            return osm.getId();
        }
        if (this.usedNewIds.containsKey(osm)) {
            return this.usedNewIds.get(osm);
        }
        this.usedNewIds.put(osm, this.newIdCounter);
        if (this.osmConform) {
            l = 0L;
        } else {
            long l2 = this.newIdCounter;
            l = l2;
            this.newIdCounter = l2 - 1L;
        }
        return l;
    }

    private void addTags(Tagged osm, String tagname, boolean tagOpen) {
        if (osm.hasKeys()) {
            if (tagOpen) {
                this.out.println(">");
            }
            for (Map.Entry<String, String> e : osm.getKeys().entrySet()) {
                if (!(osm instanceof Changeset) && "created_by".equals(e.getKey())) continue;
                this.out.println("    <tag k='" + XmlWriter.encode(e.getKey()) + "' v='" + XmlWriter.encode(e.getValue()) + "' />");
            }
            this.out.println("  </" + tagname + ">");
        } else if (tagOpen) {
            this.out.println(" />");
        } else {
            this.out.println("  </" + tagname + ">");
        }
    }

    private void addCommon(OsmPrimitive osm, String tagname) {
        long id = this.getUsedId(osm);
        this.out.print("  <" + tagname);
        if (id != 0L) {
            this.out.print(" id='" + this.getUsedId(osm) + "'");
        }
        if (!this.osmConform) {
            String action = null;
            if (osm.isDeleted()) {
                action = "delete";
            } else if (osm.isModified()) {
                action = "modify";
            }
            if (action != null) {
                this.out.print(" action='" + action + "'");
            }
        }
        if (!osm.isTimestampEmpty()) {
            this.out.print(" timestamp='" + DateUtils.fromDate(osm.getTimestamp()) + "'");
        }
        if (osm.getUser() != null) {
            if (osm.getUser().isLocalUser()) {
                this.out.print(" user='" + XmlWriter.encode(osm.getUser().getName()) + "'");
            } else if (osm.getUser().isOsmUser()) {
                this.out.print(" uid='" + osm.getUser().getId() + "'");
                this.out.print(" user='" + XmlWriter.encode(osm.getUser().getName()) + "'");
            }
        }
        this.out.print(" visible='" + osm.isVisible() + "'");
        if (osm.getVersion() != 0L) {
            this.out.print(" version='" + osm.getVersion() + "'");
        }
        if (this.changeset != null && this.changeset.getId() != 0L) {
            this.out.print(" changeset='" + this.changeset.getId() + "'");
        }
    }

    public void close() {
        this.out.close();
    }

    public void flush() {
        this.out.flush();
    }
}

