/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.util.List;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmChangesetParser;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmServerChangesetReader
extends OsmServerReader {
    public OsmServerChangesetReader() {
        this.setDoAuthenticate(false);
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public List<Changeset> queryChangesets(ChangesetQuery query, ProgressMonitor monitor) throws OsmTransferException {
        if (query == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "query"));
        }
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            List<Changeset> changesets;
            monitor.beginTask(I18n.tr("Reading changesets..."));
            StringBuffer sb = new StringBuffer();
            sb.append("changesets?").append(query.getQueryString());
            InputStream in = this.getInputStream(sb.toString(), monitor.createSubTaskMonitor(1, true));
            if (in == null) {
                List<Changeset> list = null;
                return list;
            }
            monitor.indeterminateSubTask(I18n.tr("Downloading changesets ..."));
            List<Changeset> list = changesets = OsmChangesetParser.parse(in, monitor.createSubTaskMonitor(1, true));
            return list;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (IllegalDataException e) {
            throw new OsmTransferException(e);
        }
        finally {
            monitor.finishTask();
        }
    }

    public Changeset readChangeset(long id, ProgressMonitor monitor) throws OsmTransferException {
        if (id <= 0L) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' > 0 expected. Got ''{1}''.", "id", id));
        }
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask(I18n.tr("Reading changeset {0} ...", id));
            StringBuffer sb = new StringBuffer();
            sb.append("changeset/").append(id);
            InputStream in = this.getInputStream(sb.toString(), monitor.createSubTaskMonitor(1, true));
            if (in == null) {
                Changeset changeset = null;
                return changeset;
            }
            monitor.indeterminateSubTask(I18n.tr("Downloading changeset {0} ...", id));
            List<Changeset> changesets = OsmChangesetParser.parse(in, monitor.createSubTaskMonitor(1, true));
            if (changesets == null || changesets.isEmpty()) {
                Changeset changeset = null;
                return changeset;
            }
            Changeset changeset = changesets.get(0);
            return changeset;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (IllegalDataException e) {
            throw new OsmTransferException(e);
        }
        finally {
            monitor.finishTask();
        }
    }

    public Changeset downloadChangeset(long id, ProgressMonitor monitor) throws OsmTransferException {
        return null;
    }
}

