/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.util.ArrayList;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.MergeVisitor;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class OsmServerBackreferenceReader
extends OsmServerReader {
    private long id;
    private OsmPrimitiveType primitiveType;
    private boolean readFull;

    public OsmServerBackreferenceReader(OsmPrimitive primitive) throws IllegalArgumentException {
        if (primitive == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "primitive"));
        }
        if (primitive.isNew()) {
            throw new IllegalArgumentException(I18n.tr("ID parameter ''{0}'' > 0 expected. Got ''{1}''.", "primitive", primitive.getId()));
        }
        this.id = primitive.getId();
        this.primitiveType = OsmPrimitiveType.from(primitive);
        this.readFull = false;
    }

    public OsmServerBackreferenceReader(long id, OsmPrimitiveType type) throws IllegalArgumentException {
        if (id <= 0L) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' > 0 expected. Got ''{1}''.", "id", id));
        }
        if (type == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "type"));
        }
        this.id = id;
        this.primitiveType = type;
        this.readFull = false;
    }

    public OsmServerBackreferenceReader(OsmPrimitive primitive, boolean readFull) {
        this(primitive);
        this.readFull = readFull;
    }

    public OsmServerBackreferenceReader(long id, OsmPrimitiveType type, boolean readFull) throws IllegalArgumentException {
        this(id, type);
        this.readFull = false;
    }

    public boolean isReadFull() {
        return this.readFull;
    }

    public void setReadFull(boolean readFull) {
        this.readFull = readFull;
    }

    protected DataSet getReferringWays(ProgressMonitor progressMonitor) throws OsmTransferException {
        InputStream in = null;
        progressMonitor.beginTask(null, 2);
        try {
            progressMonitor.indeterminateSubTask(I18n.tr("Downloading from OSM Server..."));
            StringBuffer sb = new StringBuffer();
            sb.append(this.primitiveType.getAPIName()).append("/").append(this.id).append("/ways");
            in = this.getInputStream(sb.toString(), progressMonitor.createSubTaskMonitor(1, true));
            if (in == null) {
                DataSet dataSet = null;
                return dataSet;
            }
            progressMonitor.subTask(I18n.tr("Downloading referring ways ..."));
            DataSet dataSet = OsmReader.parseDataSet(in, progressMonitor.createSubTaskMonitor(1, true));
            return dataSet;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.cancel) {
                DataSet dataSet = null;
                return dataSet;
            }
            throw new OsmTransferException(e);
        }
        finally {
            progressMonitor.finishTask();
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
                this.activeConnection = null;
            }
        }
    }

    protected DataSet getReferringRelations(ProgressMonitor progressMonitor) throws OsmTransferException {
        InputStream in = null;
        progressMonitor.beginTask(null, 2);
        try {
            progressMonitor.subTask(I18n.tr("Contacting OSM Server..."));
            StringBuffer sb = new StringBuffer();
            sb.append(this.primitiveType.getAPIName()).append("/").append(this.id).append("/relations");
            in = this.getInputStream(sb.toString(), progressMonitor.createSubTaskMonitor(1, true));
            if (in == null) {
                DataSet dataSet = null;
                return dataSet;
            }
            progressMonitor.subTask(I18n.tr("Downloading referring relations ..."));
            DataSet dataSet = OsmReader.parseDataSet(in, progressMonitor.createSubTaskMonitor(1, true));
            return dataSet;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.cancel) {
                DataSet dataSet = null;
                return dataSet;
            }
            throw new OsmTransferException(e);
        }
        finally {
            progressMonitor.finishTask();
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
                this.activeConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSet readIncompletePrimitives(DataSet ds, ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask(null, 2);
        try {
            ArrayList<Way> waysToCheck = new ArrayList<Way>(ds.ways);
            if (this.isReadFull() || this.primitiveType.equals((Object)OsmPrimitiveType.NODE)) {
                for (Way way : waysToCheck) {
                    if (way.isNew() || !way.incomplete) continue;
                    OsmServerObjectReader reader = new OsmServerObjectReader(way.getId(), OsmPrimitiveType.from(way), true);
                    DataSet wayDs = reader.parseOsm(progressMonitor.createSubTaskMonitor(1, false));
                    MergeVisitor visitor = new MergeVisitor(ds, wayDs);
                    visitor.merge();
                }
            }
            if (this.isReadFull()) {
                ArrayList<Relation> relationsToCheck = new ArrayList<Relation>(ds.relations);
                for (Relation relation : relationsToCheck) {
                    if (relation.isNew() || !relation.incomplete) continue;
                    OsmServerObjectReader reader = new OsmServerObjectReader(relation.getId(), OsmPrimitiveType.from(relation), true);
                    DataSet wayDs = reader.parseOsm(progressMonitor.createSubTaskMonitor(1, false));
                    MergeVisitor visitor = new MergeVisitor(ds, wayDs);
                    visitor.merge();
                }
            }
            DataSet dataSet = ds;
            return dataSet;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            MergeVisitor visitor;
            DataSet ds;
            progressMonitor.beginTask(null, 3);
            DataSet ret = new DataSet();
            if (this.primitiveType.equals((Object)OsmPrimitiveType.NODE)) {
                ds = this.getReferringWays(progressMonitor.createSubTaskMonitor(1, false));
                visitor = new MergeVisitor(ret, ds);
                visitor.merge();
                ret = visitor.getMyDataSet();
            }
            ds = this.getReferringRelations(progressMonitor.createSubTaskMonitor(1, false));
            visitor = new MergeVisitor(ret, ds);
            visitor.merge();
            ret = visitor.getMyDataSet();
            this.readIncompletePrimitives(ret, progressMonitor.createSubTaskMonitor(1, false));
            DataSet dataSet = ret;
            return dataSet;
        }
        finally {
            progressMonitor.finishTask();
        }
    }
}

