/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.NmeaReader;
import org.openstreetmap.josm.tools.I18n;

public class NMEAImporter
extends FileImporter {
    public NMEAImporter() {
        super(new ExtensionFileFilter("nmea,nme,nma,log,txt", "nmea", I18n.tr("NMEA-0183 Files") + " (*.nmea *.nme *.nma *.log *.txt)"));
    }

    public void importData(File file) throws IOException {
        String fn = file.getName();
        NmeaReader r = new NmeaReader(new FileInputStream(file), file.getAbsoluteFile().getParentFile());
        if (r.getNumberOfCoordinates() > 0) {
            r.data.storageFile = file;
            GpxLayer gpxLayer = new GpxLayer(r.data, fn, true);
            Main.main.addLayer(gpxLayer);
            if (Main.pref.getBoolean("marker.makeautomarkers", true)) {
                MarkerLayer ml = new MarkerLayer(r.data, I18n.tr("Markers from {0}", fn), file, gpxLayer);
                if (ml.data.size() > 0) {
                    Main.main.addLayer(ml);
                }
            }
        }
        this.showNmeaInfobox(r.getNumberOfCoordinates() > 0, r);
    }

    private void showNmeaInfobox(boolean success, NmeaReader r) {
        String msg = I18n.tr("Coordinates imported: ") + r.getNumberOfCoordinates() + "\n" + I18n.tr("Malformed sentences: ") + r.getParserMalformed() + "\n" + I18n.tr("Checksum errors: ") + r.getParserChecksumErrors() + "\n";
        if (!success) {
            msg = msg + I18n.tr("Unknown sentences: ") + r.getParserUnknown() + "\n";
        }
        msg = msg + I18n.tr("Zero coordinates: ") + r.getParserZeroCoordinates();
        if (success) {
            JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr("NMEA import success"), 1);
        } else {
            JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr("NMEA import failure!"), 0);
        }
    }
}

