/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.AWTException;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.gui.dialogs.relation.RunnableAction;
import org.openstreetmap.josm.gui.tagging.TagCellEditor;
import org.openstreetmap.josm.gui.tagging.TagCellRenderer;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionCache;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.tools.I18n;

public class TagTable
extends JTable {
    private static Logger logger = Logger.getLogger(TagTable.class.getName());
    private TagCellEditor editor = null;
    private RunnableAction deleteAction = null;
    private RunnableAction addAction = null;

    public RunnableAction getDeleteAction() {
        return this.deleteAction;
    }

    public RunnableAction getAddAction() {
        return this.addAction;
    }

    protected void init() {
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        this.setSelectionMode(1);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "selectNextColumnCell");
        this.getActionMap().put("selectNextColumnCell", new SelectNextColumnCellAction());
        this.getActionMap().put("selectPreviousColumnCell", new SelectPreviousColumnCellAction());
        this.deleteAction = new DeleteAction();
        this.addAction = new AddAction();
        this.getInputMap(1).put(KeyStroke.getKeyStroke(107, 2), "addTag");
        this.getActionMap().put("addTag", this.addAction);
        this.editor = new TagCellEditor();
        this.editor.setTagEditorModel((TagEditorModel)this.getModel());
        this.getColumnModel().getColumn(0).setCellEditor(this.editor);
        this.getColumnModel().getColumn(1).setCellEditor(this.editor);
    }

    public TagTable(TableModel model) {
        super(model, new TagTableColumnModel());
        this.init();
    }

    public Dimension getPreferredSize() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof JViewport); c = c.getParent()) {
        }
        if (c != null) {
            Dimension d = super.getPreferredSize();
            d.width = c.getSize().width;
            return d;
        }
        return super.getPreferredSize();
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.getKeyCode() == 127) {
            this.getDeleteAction().run();
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public void setAutoCompletionList(AutoCompletionList autoCompletionList) {
        if (autoCompletionList == null) {
            return;
        }
        if (this.editor != null) {
            this.editor.setAutoCompletionList(autoCompletionList);
        }
    }

    public void setAutoCompletionCache(AutoCompletionCache acCache) {
        if (acCache == null) {
            logger.warning("argument acCache should not be null. Aborting.");
            return;
        }
        if (this.editor != null) {
            this.editor.setAutoCompletionCache(acCache);
        }
    }

    public AutoCompletionList getAutoCompletionList() {
        if (this.editor != null) {
            return this.editor.getAutoCompletionList();
        }
        return null;
    }

    public TagCellEditor getTableCellEditor() {
        return this.editor;
    }

    public void addOKAccelatorListener(KeyListener l) {
        this.addKeyListener(l);
        if (this.editor == null) {
            logger.warning("editor is null. cannot register OK accelator listener.");
        }
        this.editor.getEditor().addKeyListener(l);
    }

    public void requestFocusInCell(int row, int col) {
        Rectangle r = this.getCellRect(row, col, false);
        Point p = new Point(r.x + r.width / 2, r.y + r.height / 2);
        SwingUtilities.convertPointToScreen(p, this);
        Point before = MouseInfo.getPointerInfo().getLocation();
        try {
            Robot robot = new Robot();
            robot.mouseMove(p.x, p.y);
            robot.mousePress(16);
            robot.mouseRelease(16);
            robot.mouseMove(before.x, before.y);
        }
        catch (AWTException e) {
            logger.log(Level.SEVERE, "failed to simulate mouse click event at (" + r.x + "," + r.y + "). Exception: " + e.toString());
            return;
        }
    }

    class AddAction
    extends RunnableAction {
        public AddAction() {
            this.putValue("Name", I18n.tr("Add"));
        }

        public void run() {
            TagTable.this.getCellEditor().stopCellEditing();
            ((TagEditorModel)TagTable.this.getModel()).appendNewTag();
            int rowIdx = TagTable.this.getModel().getRowCount() - 1;
            TagTable.this.requestFocusInCell(rowIdx, 0);
        }
    }

    class DeleteAction
    extends RunnableAction
    implements ListSelectionListener {
        protected void deleteTagNames() {
            int[] rows = TagTable.this.getSelectedRows();
            TagEditorModel model = (TagEditorModel)TagTable.this.getModel();
            model.deleteTagNames(rows);
        }

        protected void deleteTagValues() {
            int[] rows = TagTable.this.getSelectedRows();
            TagEditorModel model = (TagEditorModel)TagTable.this.getModel();
            model.deleteTagValues(rows);
        }

        protected void deleteTags() {
            int[] rows = TagTable.this.getSelectedRows();
            TagEditorModel model = (TagEditorModel)TagTable.this.getModel();
            model.deleteTags(rows);
        }

        public DeleteAction() {
            this.putValue("Name", I18n.tr("Delete"));
            TagTable.this.getSelectionModel().addListSelectionListener(this);
            TagTable.this.getColumnModel().getSelectionModel().addListSelectionListener(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            TagTable.this.getCellEditor().stopCellEditing();
            if (TagTable.this.getSelectedColumnCount() == 1) {
                if (TagTable.this.getSelectedColumn() == 0) {
                    this.deleteTagNames();
                } else {
                    if (TagTable.this.getSelectedColumn() != 1) throw new IllegalStateException("unexpected selected clolumn: getSelectedColumn() is " + TagTable.this.getSelectedColumn());
                    this.deleteTagValues();
                }
            } else if (TagTable.this.getSelectedColumnCount() == 2) {
                this.deleteTags();
            }
            TagEditorModel model = (TagEditorModel)TagTable.this.getModel();
            if (model.getRowCount() != 0) return;
            model.ensureOneTag();
            TagTable.this.requestFocusInCell(0, 0);
        }

        public void valueChanged(ListSelectionEvent e) {
            if (TagTable.this.isEditing() && TagTable.this.getSelectedColumnCount() == 1 && TagTable.this.getSelectedRowCount() == 1) {
                this.setEnabled(false);
            } else if (!TagTable.this.isEditing() && TagTable.this.getSelectedColumnCount() == 1 && TagTable.this.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else if (TagTable.this.getSelectedColumnCount() > 1 || TagTable.this.getSelectedRowCount() > 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class SelectPreviousColumnCellAction
    extends AbstractAction {
        SelectPreviousColumnCellAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int col = TagTable.this.getSelectedColumn();
            int row = TagTable.this.getSelectedRow();
            if (TagTable.this.getCellEditor() != null) {
                TagTable.this.getCellEditor().stopCellEditing();
            }
            if (col > 0 || row > 0) {
                if (col == 1) {
                    --col;
                } else {
                    col = 1;
                    --row;
                }
            }
            TagTable.this.changeSelection(row, col, false, false);
        }
    }

    class SelectNextColumnCellAction
    extends AbstractAction {
        SelectNextColumnCellAction() {
        }

        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        public void run() {
            int col = TagTable.this.getSelectedColumn();
            int row = TagTable.this.getSelectedRow();
            if (TagTable.this.getCellEditor() != null) {
                TagTable.this.getCellEditor().stopCellEditing();
            }
            if (col == 0) {
                ++col;
            } else if (col == 1 && row < TagTable.this.getRowCount() - 1) {
                col = 0;
                ++row;
            } else if (col == 1 && row == TagTable.this.getRowCount() - 1) {
                TagEditorModel model = (TagEditorModel)TagTable.this.getModel();
                model.appendNewTag();
                col = 0;
                ++row;
            }
            TagTable.this.changeSelection(row, col, false, false);
        }
    }

    static class TagTableColumnModel
    extends DefaultTableColumnModel {
        public TagTableColumnModel() {
            TableColumn col = null;
            TagCellRenderer renderer = new TagCellRenderer();
            col = new TableColumn(0);
            col.setHeaderValue(I18n.tr("Key"));
            col.setResizable(true);
            col.setCellRenderer(renderer);
            this.addColumn(col);
            col = new TableColumn(1);
            col.setHeaderValue(I18n.tr("Value"));
            col.setResizable(true);
            col.setCellRenderer(renderer);
            this.addColumn(col);
        }
    }
}

