/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.progress;

import javax.swing.SwingUtilities;
import org.openstreetmap.josm.gui.progress.AbstractProgressMonitor;
import org.openstreetmap.josm.gui.progress.CancelHandler;
import org.openstreetmap.josm.gui.progress.ProgressRenderer;
import org.openstreetmap.josm.tools.I18n;

public class SwingRenderingProgressMonitor
extends AbstractProgressMonitor {
    private static final int PROGRESS_BAR_MAX = 100;
    private int currentProgressValue = 0;
    private ProgressRenderer delegate;

    public SwingRenderingProgressMonitor(ProgressRenderer delegate) {
        super(new CancelHandler());
        if (delegate == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "delegate"));
        }
        this.delegate = delegate;
    }

    private void doInEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void doBeginTask() {
        this.doInEDT(new Runnable(){

            public void run() {
                SwingRenderingProgressMonitor.this.delegate.setCustomText("");
                SwingRenderingProgressMonitor.this.delegate.setMaximum(100);
            }
        });
    }

    public void doFinishTask() {
    }

    protected void updateProgress(double progressValue) {
        int newValue = (int)(progressValue * 100.0);
        if (newValue != this.currentProgressValue) {
            this.currentProgressValue = newValue;
            this.doInEDT(new Runnable(){

                public void run() {
                    SwingRenderingProgressMonitor.this.delegate.setValue(SwingRenderingProgressMonitor.this.currentProgressValue);
                }
            });
        }
    }

    protected void doSetCustomText(final String title) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        this.doInEDT(new Runnable(){

            public void run() {
                SwingRenderingProgressMonitor.this.delegate.setCustomText(title);
            }
        });
    }

    protected void doSetTitle(final String title) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        this.doInEDT(new Runnable(){

            public void run() {
                SwingRenderingProgressMonitor.this.delegate.setTaskTitle(title);
            }
        });
    }

    protected void doSetIntermediate(final boolean value) {
        this.doInEDT(new Runnable(){

            public void run() {
                SwingRenderingProgressMonitor.this.delegate.setIndeterminate(value);
            }
        });
    }

    protected void doSetErrorMessage(String message) {
    }
}

