/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolbarPreferences
implements PreferenceSettingFactory {
    private Map<String, Action> actions = new HashMap<String, Action>();
    private Map<String, Action> regactions = new HashMap<String, Action>();
    private DefaultMutableTreeNode rootActionsNode = new DefaultMutableTreeNode("Actions");
    public JToolBar control = new JToolBar();
    private static final String[] deftoolbar = new String[]{"open", "save", "download", "upload", "|", "undo", "redo", "|", "dialogs/search", "preference", "|", "splitway", "combineway", "wayflip", "|", "tagginggroup_Highways/Streets", "tagginggroup_Highways/Ways", "tagginggroup_Highways/Waypoints", "tagginggroup_Highways/Barriers", "|", "tagginggroup_Transport/Car", "tagginggroup_Transport/Public Transport", "|", "tagginggroup_Travel/Tourism", "tagginggroup_Travel/Food+Drinks", "|", "tagginggroup_Travel/Historic Places", "|", "tagginggroup_Man-Made/Man Made"};
    private static DataFlavor ACTION_FLAVOR = new DataFlavor(AbstractAction.class, "ActionItem");

    @Override
    public PreferenceSetting createPreferenceSetting() {
        return new Settings(this.rootActionsNode);
    }

    public ToolbarPreferences() {
        this.control.setFloatable(false);
    }

    private void loadAction(DefaultMutableTreeNode node, MenuElement menu) {
        Object userObject = null;
        MenuElement menuElement = menu;
        if (menu.getSubElements().length > 0 && menu.getSubElements()[0] instanceof JPopupMenu) {
            menuElement = menu.getSubElements()[0];
        }
        for (MenuElement item : menuElement.getSubElements()) {
            if (item instanceof JMenuItem) {
                JMenuItem menuItem = (JMenuItem)item;
                if (menuItem.getAction() != null) {
                    Action action = menuItem.getAction();
                    userObject = action;
                    this.actions.put((String)action.getValue("toolbar"), action);
                } else {
                    userObject = menuItem.getText();
                }
            }
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(userObject);
            node.add(newNode);
            this.loadAction(newNode, item);
        }
    }

    public Action getAction(String s) {
        Action e = this.actions.get(s);
        if (e == null) {
            e = this.regactions.get(s);
        }
        return e;
    }

    private void loadActions() {
        this.rootActionsNode.removeAllChildren();
        this.loadAction(this.rootActionsNode, Main.main.menu);
        for (Map.Entry<String, Action> a : this.regactions.entrySet()) {
            if (this.actions.get(a.getKey()) != null) continue;
            this.rootActionsNode.add(new DefaultMutableTreeNode(a.getValue()));
        }
        this.rootActionsNode.add(new DefaultMutableTreeNode(null));
    }

    private static Collection<String> getToolString() {
        return Main.pref.getCollection("toolbar", Arrays.asList(deftoolbar));
    }

    public Action register(Action action) {
        this.regactions.put((String)action.getValue("toolbar"), action);
        return action;
    }

    public void refreshToolbarControl() {
        this.loadActions();
        this.control.removeAll();
        for (String s : ToolbarPreferences.getToolString()) {
            if (s.equals("|")) {
                this.control.addSeparator();
                continue;
            }
            Action a = this.getAction(s);
            JButton b = this.control.add(a);
            String tt = (String)a.getValue("Optional tooltip text");
            if (tt == null) continue;
            b.setToolTipText(tt);
        }
        this.control.setVisible(this.control.getComponentCount() != 0);
    }

    public static class Settings
    implements PreferenceSetting {
        private final Move moveAction = new Move();
        private final DefaultListModel selected = new DefaultListModel();
        private final JList selectedList = new JList(this.selected);
        private final DefaultTreeModel actionsTreeModel;
        private final JTree actionsTree;
        private JButton upButton;
        private JButton downButton;
        private String movingComponent;

        public Settings(DefaultMutableTreeNode rootActionsNode) {
            this.actionsTreeModel = new DefaultTreeModel(rootActionsNode);
            this.actionsTree = new JTree(this.actionsTreeModel);
        }

        private JButton createButton(String name) {
            JButton b = new JButton();
            if (name.equals("up")) {
                b.setIcon(ImageProvider.get("dialogs", "up"));
            } else if (name.equals("down")) {
                b.setIcon(ImageProvider.get("dialogs", "down"));
            } else {
                b.setText(name);
            }
            b.addActionListener(this.moveAction);
            b.setActionCommand(name);
            return b;
        }

        public void addGui(PreferenceDialog gui) {
            this.actionsTree.setCellRenderer(new DefaultTreeCellRenderer(){

                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                    JLabel comp = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                    if (node.getUserObject() == null) {
                        comp.setText(I18n.tr("Separator"));
                        comp.setIcon(ImageProvider.get("preferences/separator"));
                    } else if (node.getUserObject() instanceof Action) {
                        Action action = (Action)node.getUserObject();
                        comp.setText((String)action.getValue("Name"));
                        comp.setIcon((Icon)action.getValue("SmallIcon"));
                    }
                    return comp;
                }
            });
            DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Icon i;
                    String s;
                    if (value != null) {
                        Action action = Main.toolbar.getAction((String)value);
                        s = (String)action.getValue("Name");
                        i = (Icon)action.getValue("SmallIcon");
                    } else {
                        i = ImageProvider.get("preferences/separator");
                        s = I18n.tr("Separator");
                    }
                    JLabel l = (JLabel)super.getListCellRendererComponent((JList<?>)list, s, index, isSelected, cellHasFocus);
                    l.setIcon(i);
                    return l;
                }
            };
            this.selectedList.setCellRenderer(renderer);
            this.selectedList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    boolean sel;
                    boolean bl = sel = Settings.this.selectedList.getSelectedIndex() != -1;
                    if (sel) {
                        Settings.this.actionsTree.clearSelection();
                    }
                    Settings.this.upButton.setEnabled(sel);
                    Settings.this.downButton.setEnabled(sel);
                }
            });
            this.selectedList.setDragEnabled(true);
            this.selectedList.setTransferHandler(new TransferHandler(){

                protected Transferable createTransferable(JComponent c) {
                    return new ActionTransferable(((JList)c).getSelectedValues());
                }

                public int getSourceActions(JComponent c) {
                    return 2;
                }

                public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                    for (DataFlavor f : transferFlavors) {
                        if (!ACTION_FLAVOR.equals(f)) continue;
                        return true;
                    }
                    return false;
                }

                public void exportAsDrag(JComponent comp, InputEvent e, int action) {
                    super.exportAsDrag(comp, e, action);
                    Settings.this.movingComponent = "list";
                }

                public boolean importData(JComponent comp, Transferable t) {
                    try {
                        int dropIndex = Settings.this.selectedList.locationToIndex(Settings.this.selectedList.getMousePosition(true));
                        Object[] draggedData = (Object[])t.getTransferData(ACTION_FLAVOR);
                        Object leadItem = dropIndex >= 0 ? (Object)Settings.this.selected.elementAt(dropIndex) : null;
                        int dataLength = draggedData.length;
                        if (leadItem != null) {
                            for (int i = 0; i < dataLength; ++i) {
                                if (!leadItem.equals(draggedData[i])) continue;
                                return false;
                            }
                        }
                        int dragLeadIndex = -1;
                        boolean localDrop = "list".equals(Settings.this.movingComponent);
                        if (localDrop) {
                            dragLeadIndex = Settings.this.selected.indexOf(draggedData[0]);
                            for (int i = 0; i < dataLength; ++i) {
                                Settings.this.selected.removeElement(draggedData[i]);
                            }
                        }
                        int[] indices = new int[dataLength];
                        if (localDrop) {
                            int adjustedLeadIndex = Settings.this.selected.indexOf(leadItem);
                            int insertionAdjustment = dragLeadIndex <= adjustedLeadIndex ? 1 : 0;
                            for (int i = 0; i < dataLength; ++i) {
                                Settings.this.selected.insertElementAt(draggedData[i], adjustedLeadIndex + insertionAdjustment + i);
                                indices[i] = adjustedLeadIndex + insertionAdjustment + i;
                            }
                        } else {
                            for (int i = 0; i < dataLength; ++i) {
                                Settings.this.selected.add(dropIndex, draggedData[i]);
                                indices[i] = dropIndex + i;
                            }
                        }
                        Settings.this.selectedList.clearSelection();
                        Settings.this.selectedList.setSelectedIndices(indices);
                        Settings.this.movingComponent = "";
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }

                protected void exportDone(JComponent source, Transferable data, int action) {
                    if (Settings.this.movingComponent.equals("list")) {
                        try {
                            Object[] draggedData = (Object[])data.getTransferData(ACTION_FLAVOR);
                            boolean localDrop = Settings.this.selected.contains(draggedData[0]);
                            if (localDrop) {
                                int[] indices = Settings.this.selectedList.getSelectedIndices();
                                Arrays.sort(indices);
                                for (int i = indices.length - 1; i >= 0; --i) {
                                    Settings.this.selected.remove(indices[i]);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        Settings.this.movingComponent = "";
                    }
                }
            });
            this.actionsTree.setTransferHandler(new TransferHandler(){
                private static final long serialVersionUID = 1L;

                public int getSourceActions(JComponent c) {
                    return 2;
                }

                protected void exportDone(JComponent source, Transferable data, int action) {
                }

                protected Transferable createTransferable(JComponent c) {
                    TreePath[] paths = Settings.this.actionsTree.getSelectionPaths();
                    LinkedList<String> dragActions = new LinkedList<String>();
                    for (TreePath path : paths) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                        Object obj = node.getUserObject();
                        if (obj == null) {
                            dragActions.add(null);
                            continue;
                        }
                        if (!(obj instanceof Action)) continue;
                        dragActions.add((String)((Action)obj).getValue("toolbar"));
                    }
                    return new ActionTransferable(dragActions.toArray());
                }
            });
            this.actionsTree.setDragEnabled(true);
            final JPanel left = new JPanel(new GridBagLayout());
            left.add((Component)new JLabel(I18n.tr("Toolbar")), GBC.eol());
            left.add((Component)new JScrollPane(this.selectedList), GBC.std().fill(1));
            final JPanel right = new JPanel(new GridBagLayout());
            right.add((Component)new JLabel(I18n.tr("Available")), GBC.eol());
            right.add((Component)new JScrollPane(this.actionsTree), GBC.eol().fill(1));
            final JPanel buttons = new JPanel(new GridLayout(6, 1));
            this.upButton = this.createButton("up");
            buttons.add(this.upButton);
            buttons.add(this.createButton("<"));
            buttons.add(this.createButton(">"));
            this.downButton = this.createButton("down");
            buttons.add(this.downButton);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            final JPanel p = new JPanel();
            p.setLayout(new LayoutManager(){

                public void addLayoutComponent(String name, Component comp) {
                }

                public void removeLayoutComponent(Component comp) {
                }

                public Dimension minimumLayoutSize(Container parent) {
                    Dimension l = left.getMinimumSize();
                    Dimension r = right.getMinimumSize();
                    Dimension b = buttons.getMinimumSize();
                    return new Dimension(l.width + b.width + 10 + r.width, l.height + b.height + 10 + r.height);
                }

                public Dimension preferredLayoutSize(Container parent) {
                    Dimension l = new Dimension(200, 200);
                    Dimension r = new Dimension(200, 200);
                    return new Dimension(l.width + r.width + 10 + buttons.getPreferredSize().width, Math.max(l.height, r.height));
                }

                public void layoutContainer(Container parent) {
                    Dimension d = p.getSize();
                    Dimension b = buttons.getPreferredSize();
                    int width = (d.width - 10 - b.width) / 2;
                    left.setBounds(new Rectangle(0, 0, width, d.height));
                    right.setBounds(new Rectangle(width + 10 + b.width, 0, width, d.height));
                    buttons.setBounds(new Rectangle(width + 5, d.height / 2 - b.height / 2, b.width, b.height));
                }
            });
            p.add(left);
            p.add(buttons);
            p.add(right);
            JPanel panel = gui.createPreferenceTab("toolbar", I18n.tr("Toolbar customization"), I18n.tr("Customize the elements on the toolbar."), false);
            panel.add((Component)p, GBC.eol().fill(1));
            this.selected.removeAllElements();
            for (String s : ToolbarPreferences.getToolString()) {
                if (s.equals("|")) {
                    this.selected.addElement(null);
                    continue;
                }
                if (Main.toolbar.getAction(s) == null) continue;
                this.selected.addElement(s);
            }
        }

        public boolean ok() {
            LinkedList<String> t = new LinkedList<String>();
            for (int i = 0; i < this.selected.size(); ++i) {
                if (this.selected.get(i) == null) {
                    t.add("|");
                    continue;
                }
                t.add((String)Main.toolbar.getAction((String)this.selected.get(i)).getValue("toolbar"));
            }
            Main.pref.putCollection("toolbar", t);
            Main.toolbar.refreshToolbarControl();
            return false;
        }

        private static class ActionTransferable
        implements Transferable {
            private DataFlavor[] flavors = new DataFlavor[]{ToolbarPreferences.access$300()};
            private Object[] actions;

            public ActionTransferable(Action action) {
                this.actions = new Action[]{action};
            }

            public ActionTransferable(Object[] actions) {
                this.actions = actions;
            }

            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                return this.actions;
            }

            public DataFlavor[] getTransferDataFlavors() {
                return this.flavors;
            }

            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return this.flavors[0] == flavor;
            }
        }

        private final class Move
        implements ActionListener {
            private Move() {
            }

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("<") && Settings.this.actionsTree.getSelectionCount() > 0) {
                    int leadItem = Settings.this.selected.getSize();
                    if (Settings.this.selectedList.getSelectedIndex() != -1) {
                        int[] indices = Settings.this.selectedList.getSelectedIndices();
                        leadItem = indices[indices.length - 1];
                    }
                    for (TreePath selectedAction : Settings.this.actionsTree.getSelectionPaths()) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedAction.getLastPathComponent();
                        if (node.getUserObject() == null) {
                            Settings.this.selected.add(leadItem++, null);
                            continue;
                        }
                        if (node.getUserObject() != null && !(node.getUserObject() instanceof Action)) continue;
                        Settings.this.selected.add(leadItem++, ((Action)node.getUserObject()).getValue("toolbar"));
                    }
                } else if (e.getActionCommand().equals(">") && Settings.this.selectedList.getSelectedIndex() != -1) {
                    while (Settings.this.selectedList.getSelectedIndex() != -1) {
                        Settings.this.selected.remove(Settings.this.selectedList.getSelectedIndex());
                    }
                } else if (e.getActionCommand().equals("up")) {
                    int i = Settings.this.selectedList.getSelectedIndex();
                    Object o = Settings.this.selected.get(i);
                    if (i != 0) {
                        Settings.this.selected.remove(i);
                        Settings.this.selected.add(i - 1, o);
                        Settings.this.selectedList.setSelectedIndex(i - 1);
                    }
                } else if (e.getActionCommand().equals("down")) {
                    int i = Settings.this.selectedList.getSelectedIndex();
                    Object o = Settings.this.selected.get(i);
                    if (i != Settings.this.selected.size() - 1) {
                        Settings.this.selected.remove(i);
                        Settings.this.selected.add(i + 1, o);
                        Settings.this.selectedList.setSelectedIndex(i + 1);
                    }
                }
            }
        }
    }
}

