/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionPreference
implements PreferenceSetting {
    private JComboBox projectionCombo = new JComboBox<Projection>(Projection.allProjections);
    private JComboBox coordinatesCombo = new JComboBox<CoordinateFormat>(CoordinateFormat.values());
    private JPanel projSubPrefPanel;
    private JLabel projectionCode = new JLabel();
    private JLabel bounds = new JLabel();
    private JPanel projPanel = new JPanel();
    private static GBC projSubPrefPanelGBC = GBC.eol().fill(1).insets(20, 5, 5, 5);

    @Override
    public void addGui(PreferenceDialog gui) {
        ProjectionPreference.clearSubProjPrefs();
        this.setupProjectionCombo();
        for (int i = 0; i < this.coordinatesCombo.getItemCount(); ++i) {
            if (!((CoordinateFormat)((Object)this.coordinatesCombo.getItemAt(i))).name().equals(Main.pref.get("coordinates"))) continue;
            this.coordinatesCombo.setSelectedIndex(i);
            break;
        }
        this.projPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.projPanel.setLayout(new GridBagLayout());
        this.projPanel.add((Component)new JLabel(I18n.tr("Display coordinates as")), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add((Component)this.coordinatesCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)new JLabel(I18n.tr("Projection method")), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add((Component)this.projectionCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)new JLabel(I18n.tr("Projection code")), GBC.std().insets(25, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add((Component)this.projectionCode, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)new JLabel(I18n.tr("Bounds")), GBC.std().insets(25, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add((Component)this.bounds, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)this.projSubPrefPanel, projSubPrefPanelGBC);
        JScrollPane scrollpane = new JScrollPane(this.projPanel);
        gui.mapcontent.addTab(I18n.tr("Map Projection"), scrollpane);
        this.projectionCode.setText(Main.proj.toCode());
        Bounds b = Main.proj.getWorldBoundsLatLon();
        CoordinateFormat cf = CoordinateFormat.getDefaultFormat();
        this.bounds.setText(b.min.latToString(cf) + "; " + b.min.lonToString(cf) + " : " + b.max.latToString(cf) + "; " + b.max.lonToString(cf));
    }

    @Override
    public boolean ok() {
        Projection proj = (Projection)this.projectionCombo.getSelectedItem();
        String projname = proj.getClass().getName();
        Collection<String> prefs = null;
        if (ProjectionPreference.projHasPrefs(proj)) {
            prefs = ((ProjectionSubPrefs)((Object)proj)).getPreferences();
        }
        if (Main.pref.put("projection", projname)) {
            ProjectionPreference.setProjection(projname, prefs);
        }
        if (Main.pref.put("coordinates", ((CoordinateFormat)((Object)this.coordinatesCombo.getSelectedItem())).name())) {
            CoordinateFormat.setCoordinateFormat((CoordinateFormat)((Object)this.coordinatesCombo.getSelectedItem()));
        }
        ProjectionPreference.clearSubProjPrefs();
        return false;
    }

    private static boolean projHasPrefs(Projection proj) {
        Class<?>[] ifaces = proj.getClass().getInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            if (!ifaces[i].getSimpleName().equals("ProjectionSubPrefs")) continue;
            return true;
        }
        return false;
    }

    public static void setProjection() {
        ProjectionPreference.setProjection(Main.pref.get("projection", Mercator.class.getName()), Main.pref.getCollection("projection.sub", null));
    }

    public static void setProjection(String name, Collection<String> coll) {
        Bounds b = Main.map != null && Main.map.mapView != null ? Main.map.mapView.getRealBounds() : null;
        Projection oldProj = Main.proj;
        try {
            Main.proj = (Projection)Class.forName(name).newInstance();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("The projection {0} could not be activated. Using Mercator", name), I18n.tr("Error"), 0);
            coll = null;
            Main.proj = new Mercator();
        }
        if (!Main.proj.equals(oldProj) && b != null) {
            Main.map.mapView.zoomTo(b);
        }
        Main.pref.putCollection("projection.sub", coll);
        if (coll != null && ProjectionPreference.projHasPrefs(Main.proj)) {
            ((ProjectionSubPrefs)((Object)Main.proj)).setPreferences(coll);
        }
    }

    private void selectedProjectionChanged(Projection proj) {
        if (!ProjectionPreference.projHasPrefs(proj)) {
            this.projSubPrefPanel = new JPanel();
        } else {
            ProjectionSubPrefs projPref = (ProjectionSubPrefs)((Object)proj);
            this.projSubPrefPanel = projPref.getPreferencePanel();
        }
        int size = this.projPanel.getComponentCount();
        if (size < 1) {
            return;
        }
        this.projPanel.remove(size - 1);
        this.projPanel.add((Component)this.projSubPrefPanel, projSubPrefPanelGBC);
        this.projPanel.revalidate();
    }

    private void setupProjectionCombo() {
        for (int i = 0; i < this.projectionCombo.getItemCount(); ++i) {
            Projection proj = (Projection)this.projectionCombo.getItemAt(i);
            if (!proj.getClass().getName().equals(Main.pref.get("projection", Mercator.class.getName()))) continue;
            this.projectionCombo.setSelectedIndex(i);
            this.selectedProjectionChanged(proj);
            break;
        }
        this.projectionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                Projection proj = (Projection)cb.getSelectedItem();
                ProjectionPreference.this.selectedProjectionChanged(proj);
            }
        });
    }

    private static void clearSubProjPrefs() {
        for (Projection proj : Projection.allProjections) {
            if (!ProjectionPreference.projHasPrefs(proj)) continue;
            ((ProjectionSubPrefs)((Object)proj)).destroyCachedPanel();
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new ProjectionPreference();
        }
    }
}

