/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.plugins.PluginDownloader;
import org.openstreetmap.josm.plugins.PluginSelection;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class PluginPreference
implements PreferenceSetting {
    private JPanel plugin;
    private JPanel pluginPanel = new NoHorizontalScrollPanel(new GridBagLayout());
    private PreferenceDialog gui;
    private JScrollPane pluginPane;
    private PluginSelection selection = new PluginSelection();
    private JTextField txtFilter;

    public void addGui(PreferenceDialog gui) {
        this.gui = gui;
        this.plugin = gui.createPreferenceTab("plugin", I18n.tr("Plugins"), I18n.tr("Configure available plugins."), false);
        this.txtFilter = new JTextField();
        JLabel lbFilter = new JLabel(I18n.tr("Search: "));
        lbFilter.setLabelFor(this.txtFilter);
        this.plugin.add(lbFilter);
        this.plugin.add((Component)this.txtFilter, GBC.eol().fill(2));
        this.txtFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this.action();
            }

            public void insertUpdate(DocumentEvent e) {
                this.action();
            }

            public void removeUpdate(DocumentEvent e) {
                this.action();
            }

            private void action() {
                PluginPreference.this.selection.drawPanel(PluginPreference.this.pluginPanel);
            }
        });
        this.plugin.add(GBC.glue(0, 10), GBC.eol());
        this.pluginPane = new JScrollPane(this.pluginPanel, 20, 30);
        this.pluginPane.setBorder(null);
        this.plugin.add((Component)this.pluginPane, GBC.eol().fill(1));
        this.plugin.add(GBC.glue(0, 10), GBC.eol());
        JButton morePlugins = new JButton(I18n.tr("Download List"));
        morePlugins.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginPreference.this.selection.updateDescription(PluginPreference.this.pluginPanel);
            }
        });
        this.plugin.add((Component)morePlugins, GBC.std().insets(0, 0, 10, 0));
        JButton update = new JButton(I18n.tr("Update"));
        update.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginPreference.this.selection.update(PluginPreference.this.pluginPanel);
            }
        });
        this.plugin.add((Component)update, GBC.std().insets(0, 0, 10, 0));
        JButton configureSites = new JButton(I18n.tr("Configure Sites..."));
        configureSites.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginPreference.this.configureSites();
            }
        });
        this.plugin.add((Component)configureSites, GBC.std());
        this.selection.passTxtFilter(this.txtFilter);
        this.selection.loadPlugins();
        this.selection.drawPanel(this.pluginPanel);
    }

    private void configureSites() {
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(I18n.tr("Add JOSM Plugin description URL.")), GBC.eol());
        final DefaultListModel<String> model = new DefaultListModel<String>();
        for (String s : PluginDownloader.getSites()) {
            model.addElement(s);
        }
        final JList list = new JList(model);
        p.add((Component)new JScrollPane(list), GBC.std().fill());
        JPanel buttons = new JPanel(new GridBagLayout());
        buttons.add((Component)new JButton(new AbstractAction(I18n.tr("Add")){

            public void actionPerformed(ActionEvent e) {
                String s = JOptionPane.showInputDialog(PluginPreference.this.gui, I18n.tr("Add JOSM Plugin description URL."), I18n.tr("Enter URL"), 3);
                if (s != null) {
                    model.addElement(s);
                }
            }
        }), GBC.eol().fill(2));
        buttons.add((Component)new JButton(new AbstractAction(I18n.tr("Edit")){

            public void actionPerformed(ActionEvent e) {
                if (list.getSelectedValue() == null) {
                    JOptionPane.showMessageDialog(PluginPreference.this.gui, I18n.tr("Please select an entry."), I18n.tr("Warning"), 2);
                    return;
                }
                String s = (String)JOptionPane.showInputDialog(Main.parent, I18n.tr("Edit JOSM Plugin description URL."), I18n.tr("JOSM Plugin description URL"), 3, null, null, list.getSelectedValue());
                model.setElementAt(s, list.getSelectedIndex());
            }
        }), GBC.eol().fill(2));
        buttons.add((Component)new JButton(new AbstractAction(I18n.tr("Delete")){

            public void actionPerformed(ActionEvent event) {
                if (list.getSelectedValue() == null) {
                    JOptionPane.showMessageDialog(PluginPreference.this.gui, I18n.tr("Please select an entry."), I18n.tr("Warning"), 2);
                    return;
                }
                model.removeElement(list.getSelectedValue());
            }
        }), GBC.eol().fill(2));
        p.add((Component)buttons, GBC.eol());
        int answer = JOptionPane.showConfirmDialog(this.gui, p, I18n.tr("Configure Plugin Sites"), 2, -1);
        if (answer != 0) {
            return;
        }
        LinkedList<String> sites = new LinkedList<String>();
        for (int i = 0; i < model.getSize(); ++i) {
            sites.add((String)model.getElementAt(i));
        }
        PluginDownloader.setSites(sites);
    }

    public boolean ok() {
        return this.selection.finish();
    }

    private static class NoHorizontalScrollPanel
    extends JPanel
    implements Scrollable {
        public NoHorizontalScrollPanel(GridBagLayout gridBagLayout) {
            super(gridBagLayout);
        }

        public Dimension getPreferredScrollableViewportSize() {
            return super.getPreferredSize();
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 30;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new PluginPreference();
        }
    }
}

