/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class AdvancedPreference
implements PreferenceSetting {
    private Map<String, String> orig;
    private Map<String, String> defaults;
    private DefaultTableModel model;
    protected Map<String, String> data;
    protected JTextField txtFilter;

    public void addGui(final PreferenceDialog gui) {
        JPanel p = gui.createPreferenceTab("advanced", I18n.tr("Advanced Preferences"), I18n.tr("Setting Preference entries directly. Use with caution!"), false);
        this.txtFilter = new JTextField();
        JLabel lbFilter = new JLabel(I18n.tr("Search: "));
        lbFilter.setLabelFor(this.txtFilter);
        p.add(lbFilter);
        p.add((Component)this.txtFilter, GBC.eol().fill(2));
        this.txtFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this.action();
            }

            public void insertUpdate(DocumentEvent e) {
                this.action();
            }

            public void removeUpdate(DocumentEvent e) {
                this.action();
            }

            private void action() {
                AdvancedPreference.this.dataToModel();
            }
        });
        this.model = new DefaultTableModel(new String[]{I18n.tr("Key"), I18n.tr("Value")}, 0){

            public boolean isCellEditable(int row, int column) {
                return column != 0;
            }

            public void fireTableCellUpdated(int row, int column) {
                super.fireTableCellUpdated(row, column);
                if (column == 1) {
                    AdvancedPreference.this.data.put((String)AdvancedPreference.this.model.getValueAt(row, 0), (String)AdvancedPreference.this.model.getValueAt(row, 1));
                }
            }
        };
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = new JLabel();
                String s = (String)AdvancedPreference.this.defaults.get(value);
                if (s != null) {
                    if (s.equals(AdvancedPreference.this.model.getValueAt(row, 1))) {
                        label.setToolTipText(I18n.tr("Current value is default."));
                    } else {
                        label.setToolTipText(I18n.tr("Default value is ''{0}''.", s));
                    }
                } else {
                    label.setToolTipText(I18n.tr("Default value currently unknown (setting has not been used yet)."));
                }
                label.setText((String)value);
                return label;
            }
        };
        final JTable list = new JTable(this.model);
        list.getColumn(I18n.tr("Key")).setCellRenderer(renderer);
        JScrollPane scroll = new JScrollPane(list);
        p.add((Component)scroll, GBC.eol().fill(1));
        scroll.setPreferredSize(new Dimension(400, 200));
        this.orig = Main.pref.getAllPrefix("");
        this.defaults = Main.pref.getDefaults();
        this.orig.remove("osm-server.password");
        this.defaults.remove("osm-server.password");
        this.prepareData();
        this.dataToModel();
        JButton add = new JButton(I18n.tr("Add"));
        p.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        p.add((Component)add, GBC.std().insets(0, 5, 0, 0));
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedPreference.this.addPreference(gui);
            }
        });
        JButton edit = new JButton(I18n.tr("Edit"));
        p.add((Component)edit, GBC.std().insets(5, 5, 5, 0));
        edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedPreference.this.editPreference(gui, list);
            }
        });
        JButton delete = new JButton(I18n.tr("Delete"));
        p.add((Component)delete, GBC.std().insets(0, 5, 0, 0));
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedPreference.this.removePreference(gui, list);
            }
        });
        list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AdvancedPreference.this.editPreference(gui, list);
                }
            }
        });
    }

    private void prepareData() {
        TreeSet<String> ts = new TreeSet<String>(this.orig.keySet());
        for (String s : this.defaults.keySet()) {
            if (ts.contains(s)) continue;
            ts.add(s);
        }
        this.data = new TreeMap<String, String>();
        for (String s : ts) {
            String val = Main.pref.get(s);
            if (val == null) {
                val = "";
            }
            this.data.put(s, val);
        }
    }

    private void dataToModel() {
        while (this.model.getRowCount() > 0) {
            this.model.removeRow(0);
        }
        for (String prefKey : this.data.keySet()) {
            String prefValue = this.data.get(prefKey);
            String[] input = this.txtFilter.getText().split("\\s+");
            boolean canHas = true;
            for (String bit : input) {
                if (prefKey.contains(bit) || prefValue.contains(bit)) continue;
                canHas = false;
            }
            if (!canHas) continue;
            this.model.addRow(new String[]{prefKey, prefValue});
        }
    }

    public boolean ok() {
        for (String string : this.data.keySet()) {
            String value = this.data.get(string);
            if (value.length() == 0) continue;
            String origValue = this.orig.get(string);
            if (origValue == null || !origValue.equals(value)) {
                Main.pref.put(string, value);
            }
            this.orig.remove(string);
        }
        for (Map.Entry entry : this.orig.entrySet()) {
            Main.pref.put((String)entry.getKey(), null);
        }
        return false;
    }

    private void editPreference(PreferenceDialog gui, JTable list) {
        if (list.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(gui, I18n.tr("Please select the row to edit."), I18n.tr("Warning"), 2);
            return;
        }
        String v = (String)JOptionPane.showInputDialog(Main.parent, I18n.tr("New value for {0}", this.model.getValueAt(list.getSelectedRow(), 0)), I18n.tr("New value"), 3, null, null, this.model.getValueAt(list.getSelectedRow(), 1));
        if (v != null) {
            this.data.put((String)this.model.getValueAt(list.getSelectedRow(), 0), v);
            this.model.setValueAt(v, list.getSelectedRow(), 1);
        }
    }

    private void removePreference(PreferenceDialog gui, JTable list) {
        if (list.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(gui, I18n.tr("Please select the row to delete."), I18n.tr("Warning"), 2);
            return;
        }
        for (int row : list.getSelectedRows()) {
            this.data.put((String)this.model.getValueAt(row, 0), "");
            this.model.setValueAt("", row, 1);
        }
    }

    private void addPreference(PreferenceDialog gui) {
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(I18n.tr("Key")), GBC.std().insets(0, 0, 5, 0));
        JTextField key = new JTextField(10);
        JTextField value = new JTextField(10);
        p.add((Component)key, GBC.eop().insets(5, 0, 0, 0).fill(2));
        p.add((Component)new JLabel(I18n.tr("Value")), GBC.std().insets(0, 0, 5, 0));
        p.add((Component)value, GBC.eol().insets(5, 0, 0, 0).fill(2));
        int answer = JOptionPane.showConfirmDialog(gui, p, I18n.tr("Enter a new key/value pair"), 2, -1);
        if (answer == 0) {
            this.data.put(key.getText(), value.getText());
            this.model.addRow(new String[]{key.getText(), value.getText()});
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new AdvancedPreference();
        }
    }
}

