/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTaskList;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.AudioUtil;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.UrlLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GpxLayer
extends Layer {
    public GpxData data;
    private final GpxLayer me;
    protected static final double PHI = Math.toRadians(15.0);
    private boolean computeCacheInSync;
    private int computeCacheMaxLineLengthUsed;
    private Color computeCacheColorUsed;
    private colorModes computeCacheColored;
    private int computeCacheColorTracksTune;
    private boolean isLocalFile;
    private static Color[] colors = new Color[256];
    private static int ll0;
    private static int sl4;
    private static int sl9;
    private static int[][] dir;

    public GpxLayer(GpxData d) {
        super((String)d.attr.get("name"));
        this.data = d;
        this.me = this;
        this.computeCacheInSync = false;
    }

    public GpxLayer(GpxData d, String name) {
        this(d);
        this.setName(name);
    }

    public GpxLayer(GpxData d, String name, boolean isLocal) {
        this(d);
        this.setName(name);
        this.isLocalFile = isLocal;
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "gpx_small");
    }

    @Override
    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public static Color getColor(String name) {
        return Main.pref.getColor(I18n.marktr("gps point"), name != null ? "layer " + name : null, Color.gray);
    }

    @Override
    public Component[] getMenuEntries() {
        JMenuItem line = new JMenuItem(I18n.tr("Customize line drawing"), ImageProvider.get("mapmode/addsegment"));
        line.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JRadioButton[] r = new JRadioButton[]{new JRadioButton(I18n.tr("Use global settings.")), new JRadioButton(I18n.tr("Draw lines between points for this layer.")), new JRadioButton(I18n.tr("Do not draw lines between points for this layer."))};
                ButtonGroup group = new ButtonGroup();
                Box panel = Box.createVerticalBox();
                for (JRadioButton b : r) {
                    group.add(b);
                    panel.add(b);
                }
                String propName = "draw.rawgps.lines.layer " + GpxLayer.this.getName();
                if (Main.pref.hasKey(propName)) {
                    group.setSelected(r[Main.pref.getBoolean(propName) ? 1 : 2].getModel(), true);
                } else {
                    group.setSelected(r[0].getModel(), true);
                }
                int answer = JOptionPane.showConfirmDialog(Main.parent, panel, I18n.tr("Select line drawing options"), 2, 3);
                switch (answer) {
                    case -1: 
                    case 2: {
                        return;
                    }
                }
                if (group.getSelection() == r[0].getModel()) {
                    Main.pref.put(propName, null);
                } else {
                    Main.pref.put(propName, group.getSelection() == r[1].getModel());
                }
                Main.map.repaint();
            }
        });
        JMenuItem color = new JMenuItem(I18n.tr("Customize Color"), ImageProvider.get("colorchooser"));
        color.putClientProperty("help", "Action/LayerCustomizeColor");
        color.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JColorChooser c = new JColorChooser(GpxLayer.getColor(GpxLayer.this.getName()));
                Object[] options = new Object[]{I18n.tr("OK"), I18n.tr("Cancel"), I18n.tr("Default")};
                int answer = JOptionPane.showOptionDialog(Main.parent, c, I18n.tr("Choose a color"), 2, -1, null, options, options[0]);
                switch (answer) {
                    case 0: {
                        Main.pref.putColor("layer " + GpxLayer.this.getName(), c.getColor());
                        break;
                    }
                    case 1: {
                        return;
                    }
                    case 2: {
                        Main.pref.putColor("layer " + GpxLayer.this.getName(), null);
                    }
                }
                Main.map.repaint();
            }
        });
        JMenuItem markersFromNamedTrackpoints = new JMenuItem(I18n.tr("Markers From Named Points"), ImageProvider.get("addmarkers"));
        markersFromNamedTrackpoints.putClientProperty("help", "Action/MarkersFromNamedPoints");
        markersFromNamedTrackpoints.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GpxData namedTrackPoints = new GpxData();
                for (GpxTrack track : GpxLayer.this.data.tracks) {
                    for (Collection<WayPoint> seg : track.trackSegs) {
                        for (WayPoint point : seg) {
                            if (!point.attr.containsKey("name") && !point.attr.containsKey("desc")) continue;
                            namedTrackPoints.waypoints.add(point);
                        }
                    }
                }
                MarkerLayer ml = new MarkerLayer(namedTrackPoints, I18n.tr("Named Trackpoints from {0}", GpxLayer.this.getName()), GpxLayer.this.getAssociatedFile(), GpxLayer.this.me);
                if (ml.data.size() > 0) {
                    Main.main.addLayer(ml);
                }
            }
        });
        JMenuItem importAudio = new JMenuItem(I18n.tr("Import Audio"), ImageProvider.get("importaudio"));
        importAudio.putClientProperty("help", "ImportAudio");
        importAudio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String dir = Main.pref.get("markers.lastaudiodirectory");
                JFileChooser fc = new JFileChooser(dir);
                fc.setFileSelectionMode(0);
                fc.setAcceptAllFileFilterUsed(false);
                fc.setFileFilter(new FileFilter(){

                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".wav");
                    }

                    public String getDescription() {
                        return I18n.tr("Wave Audio files (*.wav)");
                    }
                });
                fc.setMultiSelectionEnabled(true);
                if (fc.showOpenDialog(Main.parent) == 0) {
                    File[] sel;
                    if (!fc.getCurrentDirectory().getAbsolutePath().equals(dir)) {
                        Main.pref.put("markers.lastaudiodirectory", fc.getCurrentDirectory().getAbsolutePath());
                    }
                    if ((sel = fc.getSelectedFiles()) != null && sel.length > 1) {
                        Arrays.sort(sel, new Comparator<File>(){

                            @Override
                            public int compare(File a, File b) {
                                return a.lastModified() <= b.lastModified() ? -1 : 1;
                            }
                        });
                    }
                    String names = null;
                    for (int i = 0; i < sel.length; ++i) {
                        names = names == null ? " (" : names + ", ";
                        names = names + sel[i].getName();
                    }
                    names = names != null ? names + ")" : "";
                    MarkerLayer ml = new MarkerLayer(new GpxData(), I18n.tr("Audio markers from {0}", GpxLayer.this.getName()) + names, GpxLayer.this.getAssociatedFile(), GpxLayer.this.me);
                    if (sel != null) {
                        double firstStartTime = (double)sel[0].lastModified() / 1000.0 - AudioUtil.getCalibratedDuration(sel[0]);
                        Markers m = new Markers();
                        for (int i = 0; i < sel.length; ++i) {
                            GpxLayer.this.importAudio(sel[i], ml, firstStartTime, m);
                        }
                    }
                    Main.main.addLayer(ml);
                    Main.map.repaint();
                }
            }
        });
        JMenuItem tagimage = new JMenuItem(I18n.tr("Import images"), ImageProvider.get("tagimages"));
        tagimage.putClientProperty("help", "Action/ImportImages");
        tagimage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser(Main.pref.get("tagimages.lastdirectory"));
                fc.setFileSelectionMode(2);
                fc.setMultiSelectionEnabled(true);
                fc.setAcceptAllFileFilterUsed(false);
                fc.setFileFilter(new FileFilter(){

                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".jpg");
                    }

                    public String getDescription() {
                        return I18n.tr("JPEG images (*.jpg)");
                    }
                });
                fc.showOpenDialog(Main.parent);
                File[] sel = fc.getSelectedFiles();
                if (sel == null || sel.length == 0) {
                    return;
                }
                LinkedList<File> files = new LinkedList<File>();
                this.addRecursiveFiles(files, sel);
                Main.pref.put("tagimages.lastdirectory", fc.getCurrentDirectory().getPath());
                GeoImageLayer.create(files, GpxLayer.this);
            }

            private void addRecursiveFiles(LinkedList<File> files, File[] sel) {
                for (File f : sel) {
                    if (f.isDirectory()) {
                        this.addRecursiveFiles(files, f.listFiles());
                        continue;
                    }
                    if (!f.getName().toLowerCase().endsWith(".jpg")) continue;
                    files.add(f);
                }
            }
        });
        if (Main.applet) {
            return new Component[]{new JMenuItem(LayerListDialog.getInstance().createShowHideLayerAction(this)), new JMenuItem(LayerListDialog.getInstance().createDeleteLayerAction(this)), new JSeparator(), color, line, new JMenuItem(new ConvertToDataLayerAction()), new JSeparator(), new JMenuItem(new RenameLayerAction(this.getAssociatedFile(), this)), new JSeparator(), new JMenuItem(new LayerListPopup.InfoAction(this))};
        }
        return new Component[]{new JMenuItem(LayerListDialog.getInstance().createShowHideLayerAction(this)), new JMenuItem(LayerListDialog.getInstance().createDeleteLayerAction(this)), new JSeparator(), new JMenuItem(new Layer.LayerSaveAction(this)), new JMenuItem(new Layer.LayerSaveAsAction(this)), color, line, tagimage, importAudio, markersFromNamedTrackpoints, new JMenuItem(new ConvertToDataLayerAction()), new JMenuItem(new DownloadAlongTrackAction()), new JSeparator(), new JMenuItem(new RenameLayerAction(this.getAssociatedFile(), this)), new JSeparator(), new JMenuItem(new LayerListPopup.InfoAction(this))};
    }

    @Override
    public String getToolTipText() {
        StringBuilder info = new StringBuilder().append("<html>");
        if (this.data.attr.containsKey("name")) {
            info.append(I18n.tr("Name: {0}", this.data.attr.get("meta.name"))).append("<br>");
        }
        if (this.data.attr.containsKey("desc")) {
            info.append(I18n.tr("Description: {0}", this.data.attr.get("meta.desc"))).append("<br>");
        }
        if (this.data.tracks.size() > 0) {
            info.append("<table><thead align=\"center\"><tr><td colspan=\"5\">" + I18n.trn("{0} track", "{0} tracks", this.data.tracks.size(), this.data.tracks.size()) + "</td></tr><tr><td>" + I18n.tr("Name") + "</td><td>" + I18n.tr("Description") + "</td><td>" + I18n.tr("Timespan") + "</td><td>" + I18n.tr("Length") + "</td><td>" + I18n.tr("URL") + "</td></tr></thead>");
            for (GpxTrack trk : this.data.tracks) {
                WayPoint earliest = null;
                WayPoint latest = null;
                info.append("<tr><td>");
                if (trk.attr.containsKey("name")) {
                    info.append(trk.attr.get("name"));
                }
                info.append("</td><td>");
                if (trk.attr.containsKey("desc")) {
                    info.append(" ").append(trk.attr.get("desc"));
                }
                info.append("</td><td>");
                for (Collection<WayPoint> seg : trk.trackSegs) {
                    for (WayPoint pnt : seg) {
                        if (latest == null) {
                            latest = earliest = pnt;
                            continue;
                        }
                        if (pnt.compareTo(earliest) < 0) {
                            earliest = pnt;
                            continue;
                        }
                        latest = pnt;
                    }
                }
                if (earliest != null && latest != null) {
                    DateFormat df = DateFormat.getDateTimeInstance(2, 3);
                    info.append(df.format(new Date((long)(earliest.time * 1000.0))) + " - " + df.format(new Date((long)(latest.time * 1000.0))));
                    int diff = (int)(latest.time - earliest.time);
                    info.append(" (" + diff / 3600 + ":" + diff % 3600 / 60 + ")");
                }
                info.append("</td><td>");
                info.append(new DecimalFormat("#0.00").format(trk.length() / 1000.0) + "km");
                info.append("</td><td>");
                if (trk.attr.containsKey("url")) {
                    info.append(trk.attr.get("url"));
                }
                info.append("</td></tr>");
            }
            info.append("</table><br><br>");
        }
        info.append(I18n.tr("Length: ") + new DecimalFormat("#0.00").format(this.data.length() / 1000.0) + "km");
        info.append("<br>");
        info.append(I18n.trn("{0} route, ", "{0} routes, ", this.data.routes.size(), this.data.routes.size())).append(I18n.trn("{0} waypoint", "{0} waypoints", this.data.waypoints.size(), this.data.waypoints.size())).append("<br>");
        return info.append("</html>").toString();
    }

    @Override
    public boolean isMergable(Layer other) {
        return other instanceof GpxLayer;
    }

    @Override
    public void mergeFrom(Layer from) {
        this.data.mergeFrom(((GpxLayer)from).data);
        this.computeCacheInSync = false;
    }

    @Override
    public void paint(Graphics g, MapView mv) {
        Point screen;
        LatLon c;
        Point oldA;
        Point old;
        Color neutralColor = GpxLayer.getColor(this.getName());
        boolean forceLines = Main.pref.getBoolean("draw.rawgps.lines.force");
        boolean direction = Main.pref.getBoolean("draw.rawgps.direction");
        int lineWidth = Main.pref.getInteger("draw.rawgps.linewidth", 0);
        int maxLineLength = this.isLocalFile ? Main.pref.getInteger("draw.rawgps.max-line-length.local", -1) : Main.pref.getInteger("draw.rawgps.max-line-length", 200);
        boolean lines = Main.pref.getBoolean("draw.rawgps.lines", true) || Main.pref.getBoolean("draw.rawgps.lines.localfiles") && this.isLocalFile;
        String linesKey = "draw.rawgps.lines.layer " + this.getName();
        if (Main.pref.hasKey(linesKey)) {
            lines = Main.pref.getBoolean(linesKey);
        }
        boolean large = Main.pref.getBoolean("draw.rawgps.large");
        boolean hdopcircle = Main.pref.getBoolean("draw.rawgps.hdopcircle", true);
        colorModes colored = colorModes.none;
        try {
            colored = colorModes.values()[Main.pref.getInteger("draw.rawgps.colors", 0)];
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean alternatedirection = Main.pref.getBoolean("draw.rawgps.alternatedirection");
        int delta = Main.pref.getInteger("draw.rawgps.min-arrow-distance", 0);
        int colorTracksTune = Main.pref.getInteger("draw.rawgps.colorTracksTune", 45);
        if (lineWidth != 0) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(new BasicStroke(lineWidth, 1, 1));
        }
        if (this.computeCacheInSync && (this.computeCacheMaxLineLengthUsed != maxLineLength || !neutralColor.equals(this.computeCacheColorUsed) || this.computeCacheColored != colored || this.computeCacheColorTracksTune != colorTracksTune)) {
            this.computeCacheMaxLineLengthUsed = maxLineLength;
            this.computeCacheInSync = false;
            this.computeCacheColorUsed = neutralColor;
            this.computeCacheColored = colored;
            this.computeCacheColorTracksTune = colorTracksTune;
        }
        if (!this.computeCacheInSync) {
            WayPoint oldWp = null;
            for (GpxTrack trk : this.data.tracks) {
                if (!forceLines) {
                    oldWp = null;
                }
                for (Collection<WayPoint> segment : trk.trackSegs) {
                    for (WayPoint trkPnt : segment) {
                        LatLon c2 = trkPnt.getCoor();
                        if (Double.isNaN(c2.lat()) || Double.isNaN(c2.lon())) continue;
                        trkPnt.customColoring = neutralColor;
                        if (oldWp != null) {
                            double dist = c2.greatCircleDistance(oldWp.getCoor());
                            switch (colored) {
                                case velocity: {
                                    double dtime = trkPnt.time - oldWp.time;
                                    double vel = dist / dtime;
                                    double velColor = vel / (double)colorTracksTune * 255.0;
                                    if (dtime <= 0.0 || vel < 0.0 || velColor > 255.0) {
                                        trkPnt.customColoring = colors[255];
                                        break;
                                    }
                                    trkPnt.customColoring = colors[(int)velColor];
                                    break;
                                }
                                case dilution: {
                                    int hdoplvl;
                                    if (trkPnt.attr.get("hdop") == null) break;
                                    float hdop = ((Float)trkPnt.attr.get("hdop")).floatValue();
                                    if (hdop < 0.0f) {
                                        hdop = 0.0f;
                                    }
                                    int hdopcolor = 255 - ((hdoplvl = Math.round(hdop * (float)Main.pref.getInteger("hdop.factor", 25))) > 255 ? 255 : hdoplvl);
                                    trkPnt.customColoring = colors[hdopcolor];
                                }
                            }
                            if (maxLineLength == -1 || dist <= (double)maxLineLength) {
                                trkPnt.drawLine = true;
                                trkPnt.dir = (int)oldWp.getCoor().heading(trkPnt.getCoor());
                            } else {
                                trkPnt.drawLine = false;
                            }
                        } else {
                            trkPnt.drawLine = false;
                        }
                        oldWp = trkPnt;
                    }
                }
            }
            this.computeCacheInSync = true;
        }
        if (lines) {
            old = null;
            for (GpxTrack trk : this.data.tracks) {
                for (Collection<WayPoint> segment : trk.trackSegs) {
                    for (WayPoint trkPnt : segment) {
                        LatLon c2 = trkPnt.getCoor();
                        if (Double.isNaN(c2.lat()) || Double.isNaN(c2.lon())) continue;
                        Point screen3 = mv.getPoint(trkPnt.getEastNorth());
                        if (trkPnt.drawLine && old != null && (old.x != screen3.x || old.y != screen3.y)) {
                            g.setColor(trkPnt.customColoring);
                            g.drawLine(old.x, old.y, screen3.x, screen3.y);
                        }
                        old = screen3;
                    }
                }
            }
        }
        if (lines && direction && !alternatedirection) {
            old = null;
            oldA = null;
            for (GpxTrack gpxTrack : this.data.tracks) {
                for (Collection<WayPoint> segment : gpxTrack.trackSegs) {
                    for (WayPoint trkPnt : segment) {
                        LatLon c3 = trkPnt.getCoor();
                        if (Double.isNaN(c3.lat()) || Double.isNaN(c3.lon()) || !trkPnt.drawLine) continue;
                        Point screen2 = mv.getPoint(trkPnt.getEastNorth());
                        if (old != null && (oldA == null || screen2.x < oldA.x - delta || screen2.x > oldA.x + delta || screen2.y < oldA.y - delta || screen2.y > oldA.y + delta)) {
                            g.setColor(trkPnt.customColoring);
                            double t = Math.atan2(screen2.y - old.y, screen2.x - old.x) + Math.PI;
                            g.drawLine(screen2.x, screen2.y, (int)((double)screen2.x + 10.0 * Math.cos(t - PHI)), (int)((double)screen2.y + 10.0 * Math.sin(t - PHI)));
                            g.drawLine(screen2.x, screen2.y, (int)((double)screen2.x + 10.0 * Math.cos(t + PHI)), (int)((double)screen2.y + 10.0 * Math.sin(t + PHI)));
                            oldA = screen2;
                        }
                        old = screen2;
                    }
                }
            }
        }
        if (lines && direction && alternatedirection) {
            old = null;
            oldA = null;
            for (GpxTrack gpxTrack : this.data.tracks) {
                for (Collection<WayPoint> segment : gpxTrack.trackSegs) {
                    for (WayPoint trkPnt : segment) {
                        LatLon c4 = trkPnt.getCoor();
                        if (Double.isNaN(c4.lat()) || Double.isNaN(c4.lon()) || !trkPnt.drawLine) continue;
                        Point screen2 = mv.getPoint(trkPnt.getEastNorth());
                        if (old != null && (oldA == null || screen2.x < oldA.x - delta || screen2.x > oldA.x + delta || screen2.y < oldA.y - delta || screen2.y > oldA.y + delta)) {
                            g.setColor(trkPnt.customColoring);
                            g.drawLine(screen2.x, screen2.y, screen2.x + dir[trkPnt.dir][0], screen2.y + dir[trkPnt.dir][1]);
                            g.drawLine(screen2.x, screen2.y, screen2.x + dir[trkPnt.dir][2], screen2.y + dir[trkPnt.dir][3]);
                            oldA = screen2;
                        }
                        old = screen2;
                    }
                }
            }
        }
        if (large || hdopcircle) {
            g.setColor(neutralColor);
            for (GpxTrack trk : this.data.tracks) {
                for (Collection collection : trk.trackSegs) {
                    for (WayPoint trkPnt : collection) {
                        c = trkPnt.getCoor();
                        if (Double.isNaN(c.lat()) || Double.isNaN(c.lon())) continue;
                        screen = mv.getPoint(trkPnt.getEastNorth());
                        g.setColor(trkPnt.customColoring);
                        if (hdopcircle && trkPnt.attr.get("hdop") != null) {
                            float hdop = ((Float)trkPnt.attr.get("hdop")).floatValue();
                            if (hdop < 0.0f) {
                                hdop = 0.0f;
                            }
                            int hdopp = mv.getPoint((LatLon)new LatLon((double)trkPnt.getCoor().lat(), (double)(trkPnt.getCoor().lon() + (double)(12.0f * hdop * 360.0f / 4.0E7f)))).x - screen.x;
                            g.drawArc(screen.x - hdopp / 2, screen.y - hdopp / 2, hdopp, hdopp, 0, 360);
                        }
                        if (!large) continue;
                        g.fillRect(screen.x - 1, screen.y - 1, 3, 3);
                    }
                }
            }
        }
        if (!large && lines) {
            g.setColor(neutralColor);
            for (GpxTrack trk : this.data.tracks) {
                for (Collection collection : trk.trackSegs) {
                    for (WayPoint trkPnt : collection) {
                        c = trkPnt.getCoor();
                        if (Double.isNaN(c.lat()) || Double.isNaN(c.lon()) || trkPnt.drawLine) continue;
                        screen = mv.getPoint(trkPnt.getEastNorth());
                        g.drawRect(screen.x, screen.y, 0, 0);
                    }
                }
            }
        }
        if (!large && !lines) {
            g.setColor(neutralColor);
            for (GpxTrack trk : this.data.tracks) {
                for (Collection collection : trk.trackSegs) {
                    for (WayPoint trkPnt : collection) {
                        c = trkPnt.getCoor();
                        if (Double.isNaN(c.lat()) || Double.isNaN(c.lon())) continue;
                        screen = mv.getPoint(trkPnt.getEastNorth());
                        g.setColor(trkPnt.customColoring);
                        g.drawRect(screen.x, screen.y, 0, 0);
                    }
                }
            }
        }
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
        v.visit(this.data.recalculateBounds());
    }

    @Override
    public File getAssociatedFile() {
        return this.data.storageFile;
    }

    @Override
    public void setAssociatedFile(File file) {
        this.data.storageFile = file;
    }

    private static void addToDownload(Area a, Rectangle2D r, Collection<Rectangle2D> results, double max_area) {
        Area tmp = new Area(r);
        tmp.intersect(a);
        if (tmp.isEmpty()) {
            return;
        }
        Rectangle2D bounds = tmp.getBounds2D();
        if (bounds.getWidth() * bounds.getHeight() > max_area) {
            Rectangle2D.Double r2;
            Rectangle2D.Double r1;
            if (bounds.getWidth() > bounds.getHeight()) {
                r1 = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth() / 2.0, bounds.getHeight());
                r2 = new Rectangle2D.Double(bounds.getX() + bounds.getWidth() / 2.0, bounds.getY(), bounds.getWidth() / 2.0, bounds.getHeight());
            } else {
                r1 = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight() / 2.0);
                r2 = new Rectangle2D.Double(bounds.getX(), bounds.getY() + bounds.getHeight() / 2.0, bounds.getWidth(), bounds.getHeight() / 2.0);
            }
            GpxLayer.addToDownload(a, r1, results, max_area);
            GpxLayer.addToDownload(a, r2, results, max_area);
        } else {
            results.add(bounds);
        }
    }

    private void importAudio(File wavFile, MarkerLayer ml, double firstStartTime, Markers markers) {
        String uri = "file:".concat(wavFile.getAbsolutePath());
        ArrayList<WayPoint> waypoints = new ArrayList<WayPoint>();
        boolean timedMarkersOmitted = false;
        boolean untimedMarkersOmitted = false;
        double snapDistance = Main.pref.getDouble("marker.audiofromuntimedwaypoints.distance", 0.001);
        WayPoint wayPointFromTimeStamp = null;
        double firstTime = -1.0;
        if (this.data.tracks != null && !this.data.tracks.isEmpty()) {
            for (GpxTrack track : this.data.tracks) {
                if (track.trackSegs == null) continue;
                for (Collection<WayPoint> seg : track.trackSegs) {
                    Iterator<WayPoint> i$ = seg.iterator();
                    if (i$.hasNext()) {
                        WayPoint w = i$.next();
                        firstTime = w.time;
                    }
                    if (!(firstTime >= 0.0)) continue;
                    break;
                }
                if (!(firstTime >= 0.0)) continue;
                break;
            }
        }
        if (firstTime < 0.0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No GPX track available in layer to associate audio with."), I18n.tr("Error"), 0);
            return;
        }
        if (Main.pref.getBoolean("marker.audiofromexplicitwaypoints", true) && this.data.waypoints != null && !this.data.waypoints.isEmpty()) {
            for (WayPoint w : this.data.waypoints) {
                if (w.time > firstTime) {
                    waypoints.add(w);
                    continue;
                }
                if (!(w.time > 0.0)) continue;
                timedMarkersOmitted = true;
            }
        }
        if (Main.pref.getBoolean("marker.audiofromuntimedwaypoints", true) && this.data.waypoints != null && !this.data.waypoints.isEmpty()) {
            for (WayPoint w : this.data.waypoints) {
                if (waypoints.contains(w)) continue;
                WayPoint wNear = this.nearestPointOnTrack(w.getEastNorth(), snapDistance);
                if (wNear != null) {
                    WayPoint wc = new WayPoint(w.getCoor());
                    wc.time = wNear.time;
                    if (w.attr.containsKey("name")) {
                        wc.attr.put("name", w.getString("name"));
                    }
                    waypoints.add(wc);
                    continue;
                }
                untimedMarkersOmitted = true;
            }
        }
        if (Main.pref.getBoolean("marker.audiofromnamedtrackpoints", false) && this.data.tracks != null && !this.data.tracks.isEmpty()) {
            for (GpxTrack track : this.data.tracks) {
                if (track.trackSegs == null) continue;
                for (Collection<WayPoint> seg : track.trackSegs) {
                    for (WayPoint w : seg) {
                        if (!w.attr.containsKey("name") && !w.attr.containsKey("desc")) continue;
                        waypoints.add(w);
                    }
                }
            }
        }
        if (Main.pref.getBoolean("marker.audiofromwavtimestamps", false) && this.data.tracks != null && !this.data.tracks.isEmpty()) {
            double lastModified = (double)wavFile.lastModified() / 1000.0;
            double duration = AudioUtil.getCalibratedDuration(wavFile);
            double startTime = lastModified - duration;
            startTime = firstStartTime + (startTime - firstStartTime) / Main.pref.getDouble("audio.calibration", "1.0");
            WayPoint w1 = null;
            WayPoint w2 = null;
            block7: for (GpxTrack track : this.data.tracks) {
                if (track.trackSegs == null) continue;
                for (Collection<WayPoint> seg : track.trackSegs) {
                    for (WayPoint w : seg) {
                        if (startTime < w.time) {
                            w2 = w;
                            break;
                        }
                        w1 = w;
                    }
                    if (w2 == null) continue;
                    continue block7;
                }
            }
            if (w1 == null || w2 == null) {
                timedMarkersOmitted = true;
            } else {
                wayPointFromTimeStamp = new WayPoint(w1.getCoor().interpolate(w2.getCoor(), (startTime - w1.time) / (w2.time - w1.time)));
                wayPointFromTimeStamp.time = startTime;
                String name = wavFile.getName();
                int dot = name.lastIndexOf(".");
                if (dot > 0) {
                    name = name.substring(0, dot);
                }
                wayPointFromTimeStamp.attr.put("name", name);
                waypoints.add(wayPointFromTimeStamp);
            }
        }
        if ((Main.pref.getBoolean("marker.audiofromstart") || waypoints.isEmpty()) && this.data.tracks != null && !this.data.tracks.isEmpty()) {
            boolean gotOne = false;
            for (GpxTrack track : this.data.tracks) {
                if (track.trackSegs == null) continue;
                for (Collection<WayPoint> seg : track.trackSegs) {
                    Iterator<WayPoint> i$ = seg.iterator();
                    if (i$.hasNext()) {
                        WayPoint w = i$.next();
                        WayPoint wStart = new WayPoint(w.getCoor());
                        wStart.attr.put("name", "start");
                        wStart.time = w.time;
                        waypoints.add(wStart);
                        gotOne = true;
                    }
                    if (!gotOne) continue;
                    break;
                }
                if (!gotOne) continue;
                break;
            }
        }
        Collections.sort(waypoints, new Comparator<WayPoint>(){

            @Override
            public int compare(WayPoint a, WayPoint b) {
                return a.time <= b.time ? -1 : 1;
            }
        });
        firstTime = -1.0;
        for (WayPoint w : waypoints) {
            if (firstTime < 0.0) {
                firstTime = w.time;
            }
            double offset = w.time - firstTime;
            String name = w.attr.containsKey("name") ? w.getString("name") : (w.attr.containsKey("desc") ? w.getString("desc") : AudioMarker.inventName(offset));
            AudioMarker am = AudioMarker.create(w.getCoor(), name, uri, ml, w.time, offset);
            if (w == wayPointFromTimeStamp) {
                am.timeFromAudio = true;
            }
            ml.data.add(am);
        }
        if (timedMarkersOmitted && !markers.timedMarkersOmitted) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Some waypoints with timestamps from before the start of the track or after the end were omitted or moved to the start."));
            markers.timedMarkersOmitted = timedMarkersOmitted;
        }
        if (untimedMarkersOmitted && !markers.untimedMarkersOmitted) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Some waypoints which were too far from the track to sensibly estimate their time were omitted."));
            markers.untimedMarkersOmitted = untimedMarkersOmitted;
        }
    }

    public WayPoint nearestPointOnTrack(EastNorth P, double tolerance) {
        double PNminsq = tolerance * tolerance;
        EastNorth bestEN = null;
        double bestTime = 0.0;
        double px = P.east();
        double py = P.north();
        double rx = 0.0;
        double ry = 0.0;
        if (this.data.tracks == null) {
            return null;
        }
        for (GpxTrack track : this.data.tracks) {
            if (track.trackSegs == null) continue;
            for (Collection<WayPoint> seg : track.trackSegs) {
                EastNorth c;
                double PRsq;
                double y;
                double x;
                WayPoint R = null;
                for (WayPoint S : seg) {
                    EastNorth c2 = S.getEastNorth();
                    if (R == null) {
                        R = S;
                        rx = c2.east();
                        x = px - rx;
                        double PRsq2 = x * x + (y = py - (ry = c2.north())) * y;
                        if (!(PRsq2 < PNminsq)) continue;
                        PNminsq = PRsq2;
                        bestEN = c2;
                        bestTime = R.time;
                        continue;
                    }
                    double sx = c2.east();
                    double sy = c2.north();
                    double A = sy - ry;
                    double B = rx - sx;
                    double C = -A * rx - B * ry;
                    double RSsq = A * A + B * B;
                    if (RSsq == 0.0) continue;
                    double PNsq = A * px + B * py + C;
                    if ((PNsq = PNsq * PNsq / RSsq) < PNminsq) {
                        x = px - rx;
                        y = py - ry;
                        double PRsq3 = x * x + y * y;
                        x = px - sx;
                        y = py - sy;
                        double PSsq = x * x + y * y;
                        if (PRsq3 - PNsq <= RSsq && PSsq - PNsq <= RSsq) {
                            double RNoverRS = Math.sqrt((PRsq3 - PNsq) / RSsq);
                            double nx = rx - RNoverRS * B;
                            double ny = ry + RNoverRS * A;
                            bestEN = new EastNorth(nx, ny);
                            bestTime = R.time + RNoverRS * (S.time - R.time);
                            PNminsq = PNsq;
                        }
                    }
                    R = S;
                    rx = sx;
                    ry = sy;
                }
                if (R == null || !((PRsq = (x = px - (rx = (c = R.getEastNorth()).east())) * x + (y = py - (ry = c.north())) * y) < PNminsq)) continue;
                PNminsq = PRsq;
                bestEN = c;
                bestTime = R.time;
            }
        }
        if (bestEN == null) {
            return null;
        }
        WayPoint best = new WayPoint(Main.proj.eastNorth2latlon(bestEN));
        best.time = bestTime;
        return best;
    }

    static {
        for (int i = 0; i < colors.length; ++i) {
            GpxLayer.colors[i] = Color.getHSBColor((float)i / 300.0f, 1.0f, 1.0f);
        }
        ll0 = 9;
        sl4 = 5;
        sl9 = 3;
        dir = new int[][]{{sl4, ll0, ll0, sl4}, {-sl9, ll0, sl9, ll0}, {-ll0, sl4, -sl4, ll0}, {-ll0, -sl9, -ll0, sl9}, {-sl4, -ll0, -ll0, -sl4}, {sl9, -ll0, -sl9, -ll0}, {ll0, -sl4, sl4, -ll0}, {ll0, sl9, ll0, -sl9}, {sl4, ll0, ll0, sl4}, {-sl9, ll0, sl9, ll0}, {-ll0, sl4, -sl4, ll0}, {-ll0, -sl9, -ll0, sl9}};
    }

    public class DownloadAlongTrackAction
    extends AbstractAction {
        public DownloadAlongTrackAction() {
            super(I18n.tr("Download from OSM along this track"), ImageProvider.get("downloadalongtrack"));
        }

        public void actionPerformed(ActionEvent e) {
            JPanel msg = new JPanel(new GridBagLayout());
            Integer[] dist = new Integer[]{5000, 500, 50};
            Integer[] area = new Integer[]{20, 10, 5, 1};
            msg.add((Component)new JLabel(I18n.tr("Download everything within:")), GBC.eol());
            String[] s = new String[dist.length];
            for (int i = 0; i < dist.length; ++i) {
                s[i] = I18n.tr("{0} meters", dist[i]);
            }
            JList<String> buffer = new JList<String>(s);
            msg.add(buffer, GBC.eol());
            msg.add((Component)new JLabel(I18n.tr("Maximum area per request:")), GBC.eol());
            s = new String[area.length];
            for (int i = 0; i < area.length; ++i) {
                s[i] = I18n.tr("{0} sq km", area[i]);
            }
            JList<String> maxRect = new JList<String>(s);
            msg.add(maxRect, GBC.eol());
            int ret = JOptionPane.showConfirmDialog(Main.parent, msg, I18n.tr("Download from OSM along this track"), 2, 3);
            switch (ret) {
                case -1: 
                case 2: {
                    return;
                }
            }
            double latsum = 0.0;
            int latcnt = 0;
            for (GpxTrack trk : GpxLayer.this.data.tracks) {
                for (Collection<WayPoint> segment : trk.trackSegs) {
                    for (WayPoint p : segment) {
                        latsum += p.getCoor().lat();
                        ++latcnt;
                    }
                }
            }
            double avglat = latsum / (double)latcnt;
            double scale = Math.cos(Math.toRadians(avglat));
            Integer i = buffer.getSelectedIndex();
            int buffer_dist = dist[i < 0 ? 0 : i];
            double buffer_y = (double)buffer_dist / 100000.0;
            double buffer_x = buffer_y / scale;
            i = maxRect.getSelectedIndex();
            double max_area = (double)area[i < 0 ? 0 : i].intValue() / 10000.0 / scale;
            Area a = new Area();
            Rectangle2D.Double r = new Rectangle2D.Double();
            LatLon previous = null;
            for (GpxTrack trk : GpxLayer.this.data.tracks) {
                for (Collection<WayPoint> segment : trk.trackSegs) {
                    for (WayPoint p : segment) {
                        LatLon c = p.getCoor();
                        if (previous != null && !(c.greatCircleDistance(previous) > (double)buffer_dist)) continue;
                        ((Rectangle2D)r).setRect(c.lon() - buffer_x, c.lat() - buffer_y, 2.0 * buffer_x, 2.0 * buffer_y);
                        a.add(new Area(r));
                        previous = c;
                    }
                }
            }
            ArrayList<Rectangle2D> toDownload = new ArrayList<Rectangle2D>();
            GpxLayer.addToDownload(a, a.getBounds(), toDownload, max_area);
            msg = new JPanel(new GridBagLayout());
            msg.add((Component)new JLabel(I18n.tr("<html>This action will require {0} individual<br>download requests. Do you wish<br>to continue?</html>", toDownload.size())), GBC.eol());
            if (toDownload.size() > 1) {
                ret = JOptionPane.showConfirmDialog(Main.parent, msg, I18n.tr("Download from OSM along this track"), 2, -1);
                switch (ret) {
                    case -1: 
                    case 2: {
                        return;
                    }
                }
            }
            new DownloadOsmTaskList().download(false, (List<Rectangle2D>)toDownload, (ProgressMonitor)new PleaseWaitProgressMonitor(I18n.tr("Download data")));
        }
    }

    public class ConvertToDataLayerAction
    extends AbstractAction {
        public ConvertToDataLayerAction() {
            super(I18n.tr("Convert to data layer"), ImageProvider.get("converttoosm"));
        }

        public void actionPerformed(ActionEvent e) {
            JPanel msg = new JPanel(new GridBagLayout());
            msg.add((Component)new JLabel(I18n.tr("<html>Upload of unprocessed GPS data as map data is considered harmful.<br>If you want to upload traces, look here:")), GBC.eol());
            msg.add((Component)new UrlLabel(I18n.tr("http://www.openstreetmap.org/traces")), GBC.eop());
            if (!ConditionalOptionPaneUtil.showConfirmationDialog("convert_to_data", Main.parent, msg, I18n.tr("Warning"), 2, 2, 0)) {
                return;
            }
            DataSet ds = new DataSet();
            for (GpxTrack trk : GpxLayer.this.data.tracks) {
                for (Collection<WayPoint> segment : trk.trackSegs) {
                    ArrayList<Node> nodes = new ArrayList<Node>();
                    for (WayPoint p : segment) {
                        Node n = new Node(p.getCoor());
                        String timestr = p.getString("time");
                        if (timestr != null) {
                            n.setTimestamp(DateUtils.fromString(timestr));
                        }
                        ds.nodes.add(n);
                        nodes.add(n);
                    }
                    Way w = new Way();
                    w.setNodes(nodes);
                    ds.ways.add(w);
                }
            }
            Main.main.addLayer(new OsmDataLayer(ds, I18n.tr("Converted from: {0}", GpxLayer.this.getName()), GpxLayer.this.getAssociatedFile()));
            Main.main.removeLayer(GpxLayer.this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum colorModes {
        none,
        velocity,
        dilution;

    }

    private class Markers {
        public boolean timedMarkersOmitted = false;
        public boolean untimedMarkersOmitted = false;

        private Markers() {
        }
    }
}

