/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import org.openstreetmap.josm.actions.SaveAction;
import org.openstreetmap.josm.gui.io.AbstractIOTask;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

class SaveLayerTask
extends AbstractIOTask {
    private SaveLayerInfo layerInfo;
    private ProgressMonitor parentMonitor;

    protected SaveLayerTask(SaveLayerInfo layerInfo, ProgressMonitor monitor) {
        if (layerInfo == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "layerInfo"));
        }
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.layerInfo = layerInfo;
        this.parentMonitor = monitor;
    }

    public void run() {
        try {
            this.parentMonitor.subTask(I18n.tr("Saving layer to ''{0}'' ...", this.layerInfo.getFile().toString()));
            this.layerInfo.getLayer().setAssociatedFile(this.layerInfo.getFile());
            if (!new SaveAction().doSave(this.layerInfo.getLayer())) {
                this.setFailed(true);
                return;
            }
            if (!this.isCancelled()) {
                this.layerInfo.getLayer().onPostSaveToFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setLastException(e);
        }
    }

    public void cancel() {
        this.setCancelled(true);
    }
}

