/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.text.SimpleDateFormat;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangesetCellRenderer
extends JLabel
implements ListCellRenderer {
    private ImageIcon icon = ImageProvider.get("data", "changeset");

    public ChangesetCellRenderer() {
        this.setOpaque(true);
    }

    protected String buildToolTipText(Changeset cs) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<strong>").append(I18n.tr("Changeset id:")).append("</strong>").append(cs.getId()).append("<br>");
        if (cs.getCreatedAt() != null) {
            SimpleDateFormat df = new SimpleDateFormat();
            sb.append("<strong>").append(I18n.tr("Created at:")).append("</strong>").append(df.format(cs.getCreatedAt())).append("<br>");
        }
        if (cs.get("comment") != null) {
            sb.append("<strong>").append(I18n.tr("Changeset comment:")).append("</strong>").append(cs.get("comment")).append("<br>");
        }
        return sb.toString();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Changeset cs = (Changeset)value;
        if (isSelected) {
            this.setForeground(UIManager.getColor("List.selectionForeground"));
            this.setBackground(UIManager.getColor("List.selectionBackground"));
        } else {
            this.setForeground(UIManager.getColor("List.foreground"));
            this.setBackground(UIManager.getColor("List.background"));
        }
        if (cs != null) {
            this.setIcon(this.icon);
            StringBuffer sb = new StringBuffer();
            if (cs.get("comment") != null) {
                sb.append(cs.getId()).append(" - ").append(cs.get("comment"));
            } else if (cs.get("name") != null) {
                sb.append(cs.getId()).append(" - ").append(cs.get("name"));
            } else {
                sb.append(I18n.tr("Changeset {0}", cs.getId()));
            }
            this.setText(sb.toString());
            this.setToolTipText(this.buildToolTipText(cs));
        } else {
            this.setText(I18n.tr("No open changeset"));
        }
        return this;
    }
}

