/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpBrowserCommandProcessor;
import org.openstreetmap.josm.tools.I18n;

public class HelpApplication {
    private static final Logger logger = Logger.getLogger(HelpApplication.class.getName());
    private HelpBrowser browser;
    private HelpBrowserCommandProcessor commandProcessor;

    protected void setGeometry(HelpBrowser browser) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        d.width = Math.min(800, d.width - 50);
        Rectangle bounds = new Rectangle(new Point(Toolkit.getDefaultToolkit().getScreenSize().width - d.width, 0), d);
        browser.setBounds(bounds);
    }

    public void start() {
        this.browser = new HelpBrowser();
        this.setGeometry(this.browser);
        this.commandProcessor = new HelpBrowserCommandProcessor(this.browser);
        new Thread(this.commandProcessor).start();
    }

    public static void main(String[] argArray) {
        I18n.init();
        Main.determinePlatformHook();
        Main.platform.preStartupHook();
        List<String> argList = Arrays.asList(argArray);
        HashMap<String, Collection<String>> args = new HashMap<String, Collection<String>>();
        for (String arg : argArray) {
            int i;
            if (!arg.startsWith("--")) {
                arg = "--download=" + arg;
            }
            String key = (i = arg.indexOf(61)) == -1 ? arg.substring(2) : arg.substring(2, i);
            String value = i == -1 ? "" : arg.substring(i + 1);
            LinkedList<String> v = (LinkedList<String>)args.get(key);
            if (v == null) {
                v = new LinkedList<String>();
            }
            v.add(value);
            args.put(key, v);
        }
        Main.pref.init(false);
        if (args.containsKey("language")) {
            I18n.set((String)((Collection)args.get("language")).toArray()[0]);
        } else {
            I18n.set(Main.pref.get("language", null));
        }
        MainApplication.preConstructorInit(args);
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                logger.log(Level.SEVERE, sw.getBuffer().toString());
            }
        });
        new HelpApplication().start();
    }
}

