/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.tools.ImageProvider;

public class SelectionTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    public static final Color BGCOLOR_DOUBLE_ENTRY = new Color(255, 234, 213);
    private HashMap<OsmPrimitiveType, ImageIcon> icons;
    private MemberTableModel model;

    protected void loadIcons() {
        this.icons = new HashMap();
        this.icons.put(OsmPrimitiveType.NODE, ImageProvider.get("data", "node"));
        this.icons.put(OsmPrimitiveType.WAY, ImageProvider.get("data", "way"));
        this.icons.put(OsmPrimitiveType.RELATION, ImageProvider.get("data", "relation"));
    }

    public SelectionTableCellRenderer() {
        this.setIcon(null);
        this.setOpaque(true);
        this.loadIcons();
    }

    public String buildToolTipText(OsmPrimitive primitive) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<strong>id</strong>=").append(primitive.getId()).append("<br>");
        ArrayList<String> keyList = new ArrayList<String>(primitive.keySet());
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            if (i > 0) {
                sb.append("<br>");
            }
            String key = keyList.get(i);
            sb.append("<strong>").append(key).append("</strong>").append("=");
            String value = primitive.get(key);
            while (value.length() != 0) {
                sb.append(value.substring(0, Math.min(50, value.length())));
                if (value.length() > 50) {
                    sb.append("<br>");
                    value = value.substring(50);
                    continue;
                }
                value = "";
            }
        }
        sb.append("</html>");
        return sb.toString();
    }

    protected void reset() {
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.setBorder(null);
        this.setIcon(null);
        this.setToolTipText(null);
    }

    protected void renderBackground(OsmPrimitive primitive, boolean isSelected) {
        Color bgc = Color.WHITE;
        if (isSelected) {
            bgc = BGCOLOR_SELECTED;
        } else if (primitive != null && this.model != null && this.model.getNumMembersWithPrimitive(primitive) > 0) {
            bgc = BGCOLOR_DOUBLE_ENTRY;
        }
        this.setBackground(bgc);
    }

    protected void renderForeground(boolean isSelected) {
        Color fgc = Color.BLACK;
        this.setForeground(fgc);
    }

    protected void renderPrimitive(OsmPrimitive primitive) {
        this.setIcon(this.icons.get((Object)OsmPrimitiveType.from(primitive)));
        this.setText(primitive.getDisplayName(DefaultNameFormatter.getInstance()));
        this.setToolTipText(this.buildToolTipText(primitive));
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.reset();
        this.renderForeground(isSelected);
        this.renderBackground((OsmPrimitive)value, isSelected);
        this.renderPrimitive((OsmPrimitive)value);
        return this;
    }

    public void setMemberTableModel(MemberTableModel model) {
        this.model = model;
    }
}

