/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RelationMemberConflictDecisionType {
    REPLACE,
    REMOVE,
    UNDECIDED;


    public static void prepareLabel(RelationMemberConflictDecisionType decision, JLabel label) {
        switch (decision) {
            case REMOVE: {
                label.setText(I18n.tr("Remove"));
                label.setToolTipText(I18n.tr("Remove this relation member from the relation"));
                break;
            }
            case REPLACE: {
                label.setText(I18n.tr("Replace"));
                label.setToolTipText(I18n.tr("Replace the way this member refers to with the combined way"));
                break;
            }
            case UNDECIDED: {
                label.setText(I18n.tr("Undecided"));
                label.setToolTipText(I18n.tr("Not decided yet"));
            }
        }
    }

    public static void prepareComboBox(RelationMemberConflictDecisionType decision, JComboBox comboBox) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)comboBox.getModel();
        model.removeAllElements();
        switch (decision) {
            case REMOVE: {
                model.addElement(I18n.tr("Remove"));
                comboBox.setToolTipText(I18n.tr("Remove this relation member from the relation"));
                comboBox.setSelectedIndex(0);
                break;
            }
            case REPLACE: {
                model.addElement(I18n.tr("Replace"));
                comboBox.setToolTipText(I18n.tr("Replace the way this member refers to with the combined way"));
                comboBox.setSelectedIndex(0);
                break;
            }
            case UNDECIDED: {
                model.addElement(I18n.tr("Undecided"));
                comboBox.setToolTipText(I18n.tr("Not decided yet"));
                comboBox.setSelectedIndex(0);
            }
        }
    }
}

