/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.properties.PropertiesMergeModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class PropertiesMerger
extends JPanel
implements Observer {
    private static DecimalFormat COORD_FORMATTER = new DecimalFormat("###0.0000");
    public static final Color BGCOLOR_NO_CONFLICT = new Color(234, 234, 234);
    public static final Color BGCOLOR_UNDECIDED = new Color(255, 197, 197);
    public static final Color BGCOLOR_DECIDED = new Color(217, 255, 217);
    private JLabel lblMyVersion;
    private JLabel lblMergedVersion;
    private JLabel lblTheirVersion;
    private JLabel lblMyCoordinates;
    private JLabel lblMergedCoordinates;
    private JLabel lblTheirCoordinates;
    private JLabel lblMyDeletedState;
    private JLabel lblMergedDeletedState;
    private JLabel lblTheirDeletedState;
    private JLabel lblMyVisibleState;
    private JLabel lblMergedVisibleState;
    private JLabel lblTheirVisibleState;
    private final PropertiesMergeModel model = new PropertiesMergeModel();

    protected JLabel buildValueLabel(String name) {
        JLabel lbl = new JLabel();
        lbl.setName(name);
        lbl.setHorizontalAlignment(0);
        lbl.setOpaque(true);
        lbl.setBorder(BorderFactory.createLoweredBevelBorder());
        return lbl;
    }

    protected void buildHeaderRow() {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 1;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(10, 0, 10, 0);
        this.lblMyVersion = new JLabel(I18n.tr("My version"));
        this.lblMyVersion.setToolTipText(I18n.tr("Properties in my dataset, i.e. the local dataset"));
        this.add((Component)this.lblMyVersion, gc);
        gc.gridx = 3;
        gc.gridy = 0;
        this.lblMergedVersion = new JLabel(I18n.tr("Merged version"));
        this.lblMergedVersion.setToolTipText(I18n.tr("Properties in the merged element. They will replace properties in my elements when merge decisions are applied."));
        this.add((Component)this.lblMergedVersion, gc);
        gc.gridx = 5;
        gc.gridy = 0;
        this.lblTheirVersion = new JLabel(I18n.tr("Their version"));
        this.lblTheirVersion.setToolTipText(I18n.tr("Properties in their dataset, i.e. the server dataset"));
        this.add((Component)this.lblTheirVersion, gc);
    }

    protected void buildCoordinateConflictRows() {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 2;
        gc.anchor = 21;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(0, 5, 0, 5);
        this.add((Component)new JLabel(I18n.tr("Coordinates:")), gc);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        this.lblMyCoordinates = this.buildValueLabel("label.mycoordinates");
        this.add((Component)this.lblMyCoordinates, gc);
        gc.gridx = 2;
        gc.gridy = 1;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        KeepMyCoordinatesAction actKeepMyCoordinates = new KeepMyCoordinatesAction();
        this.model.addObserver(actKeepMyCoordinates);
        JButton btnKeepMyCoordinates = new JButton(actKeepMyCoordinates);
        btnKeepMyCoordinates.setName("button.keepmycoordinates");
        this.add((Component)btnKeepMyCoordinates, gc);
        gc.gridx = 3;
        gc.gridy = 1;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        this.lblMergedCoordinates = this.buildValueLabel("label.mergedcoordinates");
        this.add((Component)this.lblMergedCoordinates, gc);
        gc.gridx = 4;
        gc.gridy = 1;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        KeepTheirCoordinatesAction actKeepTheirCoordinates = new KeepTheirCoordinatesAction();
        this.model.addObserver(actKeepTheirCoordinates);
        JButton btnKeepTheirCoordinates = new JButton(actKeepTheirCoordinates);
        this.add((Component)btnKeepTheirCoordinates, gc);
        gc.gridx = 5;
        gc.gridy = 1;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        this.lblTheirCoordinates = this.buildValueLabel("label.theircoordinates");
        this.add((Component)this.lblTheirCoordinates, gc);
        gc.gridx = 3;
        gc.gridy = 2;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(0, 5, 20, 5);
        UndecideCoordinateConflictAction actUndecideCoordinates = new UndecideCoordinateConflictAction();
        this.model.addObserver(actUndecideCoordinates);
        JButton btnUndecideCoordinates = new JButton(actUndecideCoordinates);
        this.add((Component)btnUndecideCoordinates, gc);
    }

    protected void buildDeletedStateConflictRows() {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 3;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 1;
        gc.anchor = 21;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(0, 5, 0, 5);
        this.add((Component)new JLabel(I18n.tr("Deleted State:")), gc);
        gc.gridx = 1;
        gc.gridy = 3;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        this.lblMyDeletedState = this.buildValueLabel("label.mydeletedstate");
        this.add((Component)this.lblMyDeletedState, gc);
        gc.gridx = 2;
        gc.gridy = 3;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        KeepMyDeletedStateAction actKeepMyDeletedState = new KeepMyDeletedStateAction();
        this.model.addObserver(actKeepMyDeletedState);
        JButton btnKeepMyDeletedState = new JButton(actKeepMyDeletedState);
        btnKeepMyDeletedState.setName("button.keepmydeletedstate");
        this.add((Component)btnKeepMyDeletedState, gc);
        gc.gridx = 3;
        gc.gridy = 3;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        this.lblMergedDeletedState = this.buildValueLabel("label.mergeddeletedstate");
        this.add((Component)this.lblMergedDeletedState, gc);
        gc.gridx = 4;
        gc.gridy = 3;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        KeepTheirDeletedStateAction actKeepTheirDeletedState = new KeepTheirDeletedStateAction();
        this.model.addObserver(actKeepTheirDeletedState);
        JButton btnKeepTheirDeletedState = new JButton(actKeepTheirDeletedState);
        btnKeepTheirDeletedState.setName("button.keeptheirdeletedstate");
        this.add((Component)btnKeepTheirDeletedState, gc);
        gc.gridx = 5;
        gc.gridy = 3;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        this.lblTheirDeletedState = this.buildValueLabel("label.theirdeletedstate");
        this.add((Component)this.lblTheirDeletedState, gc);
        gc.gridx = 3;
        gc.gridy = 4;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        UndecideDeletedStateConflictAction actUndecideDeletedState = new UndecideDeletedStateConflictAction();
        this.model.addObserver(actUndecideDeletedState);
        JButton btnUndecideDeletedState = new JButton(actUndecideDeletedState);
        btnUndecideDeletedState.setName("button.undecidedeletedstate");
        this.add((Component)btnUndecideDeletedState, gc);
    }

    protected void buildVisibleStateRows() {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 5;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 1;
        gc.anchor = 21;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(0, 5, 0, 5);
        this.add((Component)new JLabel(I18n.tr("Visible State:")), gc);
        gc.gridx = 1;
        gc.gridy = 5;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        this.lblMyVisibleState = this.buildValueLabel("label.myvisiblestate");
        this.add((Component)this.lblMyVisibleState, gc);
        gc.gridx = 2;
        gc.gridy = 5;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        KeepMyVisibleStateAction actKeepMyVisibleState = new KeepMyVisibleStateAction();
        this.model.addObserver(actKeepMyVisibleState);
        JButton btnKeepMyVisibleState = new JButton(actKeepMyVisibleState);
        btnKeepMyVisibleState.setName("button.keepmyvisiblestate");
        this.add((Component)btnKeepMyVisibleState, gc);
        gc.gridx = 3;
        gc.gridy = 5;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        this.lblMergedVisibleState = this.buildValueLabel("label.mergedvisiblestate");
        this.add((Component)this.lblMergedVisibleState, gc);
        gc.gridx = 4;
        gc.gridy = 5;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        KeepTheirVisibleStateAction actKeepTheirVisibleState = new KeepTheirVisibleStateAction();
        this.model.addObserver(actKeepTheirVisibleState);
        JButton btnKeepTheirVisibleState = new JButton(actKeepTheirVisibleState);
        btnKeepTheirVisibleState.setName("button.keeptheirvisiblestate");
        this.add((Component)btnKeepTheirVisibleState, gc);
        gc.gridx = 5;
        gc.gridy = 5;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        this.lblTheirVisibleState = this.buildValueLabel("label.theirvisiblestate");
        this.add((Component)this.lblTheirVisibleState, gc);
        gc.gridx = 3;
        gc.gridy = 6;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        UndecideVisibleStateConflictAction actUndecideVisibleState = new UndecideVisibleStateConflictAction();
        this.model.addObserver(actUndecideVisibleState);
        JButton btnUndecideVisibleState = new JButton(actUndecideVisibleState);
        btnUndecideVisibleState.setName("button.undecidevisiblestate");
        this.add((Component)btnUndecideVisibleState, gc);
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.buildHeaderRow();
        this.buildCoordinateConflictRows();
        this.buildDeletedStateConflictRows();
        this.buildVisibleStateRows();
    }

    public PropertiesMerger() {
        this.model.addObserver(this);
        this.build();
    }

    public String coordToString(LatLon coord) {
        if (coord == null) {
            return I18n.tr("(none)");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(COORD_FORMATTER.format(coord.lat())).append(",").append(COORD_FORMATTER.format(coord.lon())).append(")");
        return sb.toString();
    }

    public String deletedStateToString(Boolean deleted) {
        if (deleted == null) {
            return I18n.tr("(none)");
        }
        if (deleted.booleanValue()) {
            return I18n.tr("deleted");
        }
        return I18n.tr("not deleted");
    }

    public String visibleStateToString(Boolean visible) {
        if (visible == null) {
            return I18n.tr("(none)");
        }
        if (visible.booleanValue()) {
            return I18n.tr("visible (on the server)");
        }
        return I18n.tr("not visible (on the server)");
    }

    public String visibleStateToStringMerged(Boolean visible) {
        if (visible == null) {
            return I18n.tr("(none)");
        }
        if (visible.booleanValue()) {
            return I18n.tr("Keep a clone of the local version");
        }
        return I18n.tr("Physically delete from local dataset");
    }

    protected void updateCoordinates() {
        this.lblMyCoordinates.setText(this.coordToString(this.model.getMyCoords()));
        this.lblMergedCoordinates.setText(this.coordToString(this.model.getMergedCoords()));
        this.lblTheirCoordinates.setText(this.coordToString(this.model.getTheirCoords()));
        if (!this.model.hasCoordConflict()) {
            this.lblMyCoordinates.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblMergedCoordinates.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblTheirCoordinates.setBackground(BGCOLOR_NO_CONFLICT);
        } else if (!this.model.isDecidedCoord()) {
            this.lblMyCoordinates.setBackground(BGCOLOR_UNDECIDED);
            this.lblMergedCoordinates.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblTheirCoordinates.setBackground(BGCOLOR_UNDECIDED);
        } else {
            this.lblMyCoordinates.setBackground(this.model.isCoordMergeDecision(MergeDecisionType.KEEP_MINE) ? BGCOLOR_DECIDED : BGCOLOR_NO_CONFLICT);
            this.lblMergedCoordinates.setBackground(BGCOLOR_DECIDED);
            this.lblTheirCoordinates.setBackground(this.model.isCoordMergeDecision(MergeDecisionType.KEEP_THEIR) ? BGCOLOR_DECIDED : BGCOLOR_NO_CONFLICT);
        }
    }

    protected void updateDeletedState() {
        this.lblMyDeletedState.setText(this.deletedStateToString(this.model.getMyDeletedState()));
        this.lblMergedDeletedState.setText(this.deletedStateToString(this.model.getMergedDeletedState()));
        this.lblTheirDeletedState.setText(this.deletedStateToString(this.model.getTheirDeletedState()));
        if (!this.model.hasDeletedStateConflict()) {
            this.lblMyDeletedState.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblMergedDeletedState.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblTheirDeletedState.setBackground(BGCOLOR_NO_CONFLICT);
        } else if (!this.model.isDecidedDeletedState()) {
            this.lblMyDeletedState.setBackground(BGCOLOR_UNDECIDED);
            this.lblMergedDeletedState.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblTheirDeletedState.setBackground(BGCOLOR_UNDECIDED);
        } else {
            this.lblMyDeletedState.setBackground(this.model.isDeletedStateDecision(MergeDecisionType.KEEP_MINE) ? BGCOLOR_DECIDED : BGCOLOR_NO_CONFLICT);
            this.lblMergedDeletedState.setBackground(BGCOLOR_DECIDED);
            this.lblTheirDeletedState.setBackground(this.model.isDeletedStateDecision(MergeDecisionType.KEEP_THEIR) ? BGCOLOR_DECIDED : BGCOLOR_NO_CONFLICT);
        }
    }

    protected void updateVisibleState() {
        this.lblMyVisibleState.setText(this.visibleStateToString(this.model.getMyVisibleState()));
        this.lblMergedVisibleState.setText(this.visibleStateToStringMerged(this.model.getMergedVisibleState()));
        this.lblTheirVisibleState.setText(this.visibleStateToString(this.model.getTheirVisibleState()));
        if (!this.model.hasVisibleStateConflict()) {
            this.lblMyVisibleState.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblMergedVisibleState.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblTheirVisibleState.setBackground(BGCOLOR_NO_CONFLICT);
        } else if (!this.model.isDecidedVisibleState()) {
            this.lblMyVisibleState.setBackground(BGCOLOR_UNDECIDED);
            this.lblMergedVisibleState.setBackground(BGCOLOR_NO_CONFLICT);
            this.lblTheirVisibleState.setBackground(BGCOLOR_UNDECIDED);
        } else {
            this.lblMyVisibleState.setBackground(this.model.isVisibleStateDecision(MergeDecisionType.KEEP_MINE) ? BGCOLOR_DECIDED : BGCOLOR_NO_CONFLICT);
            this.lblMergedVisibleState.setBackground(BGCOLOR_DECIDED);
            this.lblTheirVisibleState.setBackground(this.model.isVisibleStateDecision(MergeDecisionType.KEEP_THEIR) ? BGCOLOR_DECIDED : BGCOLOR_NO_CONFLICT);
        }
    }

    public void update(Observable o, Object arg) {
        this.updateCoordinates();
        this.updateDeletedState();
        this.updateVisibleState();
    }

    public PropertiesMergeModel getModel() {
        return this.model;
    }

    class UndecideVisibleStateConflictAction
    extends AbstractAction
    implements Observer {
        public UndecideVisibleStateConflictAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagundecide"));
            this.putValue("ShortDescription", I18n.tr("Undecide conflict between visible state"));
        }

        public void actionPerformed(ActionEvent e) {
            PropertiesMerger.this.model.decideVisibleStateConflict(MergeDecisionType.UNDECIDED);
        }

        public void update(Observable o, Object arg) {
            this.setEnabled(PropertiesMerger.this.model.hasVisibleStateConflict() && PropertiesMerger.this.model.isDecidedVisibleState());
        }
    }

    class KeepTheirVisibleStateAction
    extends AbstractAction
    implements Observer {
        public KeepTheirVisibleStateAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeeptheir"));
            this.putValue("ShortDescription", I18n.tr("Keep their visible state"));
        }

        public void actionPerformed(ActionEvent e) {
            if (this.confirmKeepTheir()) {
                PropertiesMerger.this.model.decideVisibleStateConflict(MergeDecisionType.KEEP_THEIR);
            }
        }

        public void update(Observable o, Object arg) {
            this.setEnabled(PropertiesMerger.this.model.hasVisibleStateConflict() && !PropertiesMerger.this.model.isDecidedVisibleState());
        }

        protected boolean confirmKeepTheir() {
            Object[] options = new String[]{I18n.tr("Yes, purge it"), I18n.tr("No, abort")};
            int ret = JOptionPane.showOptionDialog(null, I18n.tr("<html>JOSM will have to remove your local primitive with id {0}<br>from the dataset.<br>Do you agree?</html>", PropertiesMerger.this.model.getMyPrimitive().getId()), I18n.tr("Remove from dataset"), 0, 3, null, options, options[1]);
            return ret == 0;
        }
    }

    class KeepMyVisibleStateAction
    extends AbstractAction
    implements Observer {
        public KeepMyVisibleStateAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeepmine"));
            this.putValue("ShortDescription", I18n.tr("Keep my visible state"));
        }

        public void actionPerformed(ActionEvent e) {
            if (this.confirmKeepMine()) {
                PropertiesMerger.this.model.decideVisibleStateConflict(MergeDecisionType.KEEP_MINE);
            }
        }

        public void update(Observable o, Object arg) {
            this.setEnabled(PropertiesMerger.this.model.hasVisibleStateConflict() && !PropertiesMerger.this.model.isDecidedVisibleState());
        }

        protected boolean confirmKeepMine() {
            Object[] options = new String[]{I18n.tr("Yes, reset the id"), I18n.tr("No, abort")};
            int ret = JOptionPane.showOptionDialog(null, I18n.tr("<html>To keep your local version, JOSM<br>has to reset the id of primitive {0} to 0.<br>On the next upload the server will assign<br>it a new id.<br>Do yo agree?</html>", PropertiesMerger.this.model.getMyPrimitive().getId()), I18n.tr("Reset id to 0"), 0, 3, null, options, options[1]);
            return ret == 0;
        }
    }

    class UndecideDeletedStateConflictAction
    extends AbstractAction
    implements Observer {
        public UndecideDeletedStateConflictAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagundecide"));
            this.putValue("ShortDescription", I18n.tr("Undecide conflict between deleted state"));
        }

        public void actionPerformed(ActionEvent e) {
            PropertiesMerger.this.model.decideDeletedStateConflict(MergeDecisionType.UNDECIDED);
        }

        public void update(Observable o, Object arg) {
            this.setEnabled(PropertiesMerger.this.model.hasDeletedStateConflict() && PropertiesMerger.this.model.isDecidedDeletedState());
        }
    }

    class KeepTheirDeletedStateAction
    extends AbstractAction
    implements Observer {
        public KeepTheirDeletedStateAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeeptheir"));
            this.putValue("ShortDescription", I18n.tr("Keep their deleted state"));
        }

        public void actionPerformed(ActionEvent e) {
            PropertiesMerger.this.model.decideDeletedStateConflict(MergeDecisionType.KEEP_THEIR);
        }

        public void update(Observable o, Object arg) {
            this.setEnabled(PropertiesMerger.this.model.hasDeletedStateConflict() && !PropertiesMerger.this.model.isDecidedDeletedState());
        }
    }

    class KeepMyDeletedStateAction
    extends AbstractAction
    implements Observer {
        public KeepMyDeletedStateAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeepmine"));
            this.putValue("ShortDescription", I18n.tr("Keep my deleted state"));
        }

        public void actionPerformed(ActionEvent e) {
            PropertiesMerger.this.model.decideDeletedStateConflict(MergeDecisionType.KEEP_MINE);
        }

        public void update(Observable o, Object arg) {
            this.setEnabled(PropertiesMerger.this.model.hasDeletedStateConflict() && !PropertiesMerger.this.model.isDecidedDeletedState());
        }
    }

    class UndecideCoordinateConflictAction
    extends AbstractAction
    implements Observer {
        public UndecideCoordinateConflictAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagundecide"));
            this.putValue("ShortDescription", I18n.tr("Undecide conflict between different coordinates"));
        }

        public void actionPerformed(ActionEvent e) {
            PropertiesMerger.this.model.decideCoordsConflict(MergeDecisionType.UNDECIDED);
        }

        public void update(Observable o, Object arg) {
            this.setEnabled(PropertiesMerger.this.model.hasCoordConflict() && PropertiesMerger.this.model.isDecidedCoord());
        }
    }

    class KeepTheirCoordinatesAction
    extends AbstractAction
    implements Observer {
        public KeepTheirCoordinatesAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeeptheir"));
            this.putValue("ShortDescription", I18n.tr("Keep their coordiates"));
        }

        public void actionPerformed(ActionEvent e) {
            PropertiesMerger.this.model.decideCoordsConflict(MergeDecisionType.KEEP_THEIR);
        }

        public void update(Observable o, Object arg) {
            this.setEnabled(PropertiesMerger.this.model.hasCoordConflict() && !PropertiesMerger.this.model.isDecidedCoord());
        }
    }

    class KeepMyCoordinatesAction
    extends AbstractAction
    implements Observer {
        public KeepMyCoordinatesAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeepmine"));
            this.putValue("ShortDescription", I18n.tr("Keep my coordiates"));
        }

        public void actionPerformed(ActionEvent e) {
            PropertiesMerger.this.model.decideCoordsConflict(MergeDecisionType.KEEP_MINE);
        }

        public void update(Observable o, Object arg) {
            this.setEnabled(PropertiesMerger.this.model.hasCoordConflict() && !PropertiesMerger.this.model.isDecidedCoord());
        }
    }
}

