/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.properties;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.CoordinateConflictResolveCommand;
import org.openstreetmap.josm.command.DeletedStateConflictResolveCommand;
import org.openstreetmap.josm.command.PurgePrimitivesCommand;
import org.openstreetmap.josm.command.UndeletePrimitivesCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.properties.OperationCancelledException;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesMergeModel
extends Observable {
    public static final String RESOLVED_COMPLETELY_PROP = PropertiesMergeModel.class.getName() + ".resolvedCompletely";
    private OsmPrimitive my;
    private LatLon myCoords;
    private LatLon theirCoords;
    private MergeDecisionType coordMergeDecision = MergeDecisionType.UNDECIDED;
    private boolean myDeletedState;
    private boolean theirDeletedState;
    private boolean myVisibleState;
    private boolean theirVisibleState;
    private MergeDecisionType deletedMergeDecision = MergeDecisionType.UNDECIDED;
    private MergeDecisionType visibleMergeDecision;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean resolvedCompletely = false;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void fireCompletelyResolved() {
        boolean oldValue = this.resolvedCompletely;
        this.resolvedCompletely = this.isResolvedCompletely();
        this.support.firePropertyChange(RESOLVED_COMPLETELY_PROP, oldValue, this.resolvedCompletely);
    }

    public boolean isDecidedCoord() {
        return !this.coordMergeDecision.equals((Object)MergeDecisionType.UNDECIDED);
    }

    public boolean isDecidedDeletedState() {
        return !this.deletedMergeDecision.equals((Object)MergeDecisionType.UNDECIDED);
    }

    public boolean isDecidedVisibleState() {
        return !this.visibleMergeDecision.equals((Object)MergeDecisionType.UNDECIDED);
    }

    public boolean isCoordMergeDecision(MergeDecisionType decision) {
        return this.coordMergeDecision.equals((Object)decision);
    }

    public boolean isDeletedStateDecision(MergeDecisionType decision) {
        return this.deletedMergeDecision.equals((Object)decision);
    }

    public boolean isVisibleStateDecision(MergeDecisionType decision) {
        return this.visibleMergeDecision.equals((Object)decision);
    }

    public void populate(OsmPrimitive my, OsmPrimitive their) {
        this.my = my;
        if (my instanceof Node) {
            this.myCoords = ((Node)my).getCoor();
            this.theirCoords = ((Node)their).getCoor();
        } else {
            this.myCoords = null;
            this.theirCoords = null;
        }
        this.myDeletedState = my.isDeleted();
        this.theirDeletedState = their.isDeleted();
        this.myVisibleState = my.isVisible();
        this.theirVisibleState = their.isVisible();
        this.coordMergeDecision = MergeDecisionType.UNDECIDED;
        this.deletedMergeDecision = MergeDecisionType.UNDECIDED;
        this.visibleMergeDecision = MergeDecisionType.UNDECIDED;
        this.setChanged();
        this.notifyObservers();
        this.fireCompletelyResolved();
    }

    public LatLon getMyCoords() {
        return this.myCoords;
    }

    public LatLon getTheirCoords() {
        return this.theirCoords;
    }

    public LatLon getMergedCoords() {
        switch (this.coordMergeDecision) {
            case KEEP_MINE: {
                return this.myCoords;
            }
            case KEEP_THEIR: {
                return this.theirCoords;
            }
            case UNDECIDED: {
                return null;
            }
        }
        return null;
    }

    public void decideCoordsConflict(MergeDecisionType decision) {
        this.coordMergeDecision = decision;
        this.setChanged();
        this.notifyObservers();
        this.fireCompletelyResolved();
    }

    public Boolean getMyDeletedState() {
        return this.myDeletedState;
    }

    public Boolean getTheirDeletedState() {
        return this.theirDeletedState;
    }

    public Boolean getMergedDeletedState() {
        switch (this.deletedMergeDecision) {
            case KEEP_MINE: {
                return this.myDeletedState;
            }
            case KEEP_THEIR: {
                return this.theirDeletedState;
            }
            case UNDECIDED: {
                return null;
            }
        }
        return null;
    }

    public Boolean getMyVisibleState() {
        return this.myVisibleState;
    }

    public Boolean getTheirVisibleState() {
        return this.theirVisibleState;
    }

    public Boolean getMergedVisibleState() {
        switch (this.visibleMergeDecision) {
            case KEEP_MINE: {
                return this.myVisibleState;
            }
            case KEEP_THEIR: {
                return this.theirVisibleState;
            }
            case UNDECIDED: {
                return null;
            }
        }
        return null;
    }

    public void decideDeletedStateConflict(MergeDecisionType decision) throws IllegalArgumentException {
        if (decision == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "decision"));
        }
        this.deletedMergeDecision = decision;
        this.setChanged();
        this.notifyObservers();
        this.fireCompletelyResolved();
    }

    public void decideVisibleStateConflict(MergeDecisionType decision) throws IllegalArgumentException {
        if (decision == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "decision"));
        }
        this.visibleMergeDecision = decision;
        this.setChanged();
        this.notifyObservers();
        this.fireCompletelyResolved();
    }

    public boolean hasCoordConflict() {
        if (this.myCoords == null && this.theirCoords != null) {
            return true;
        }
        if (this.myCoords != null && this.theirCoords == null) {
            return true;
        }
        if (this.myCoords == null && this.theirCoords == null) {
            return false;
        }
        return !this.myCoords.equals(this.theirCoords);
    }

    public boolean hasDeletedStateConflict() {
        return this.myDeletedState != this.theirDeletedState;
    }

    public boolean hasVisibleStateConflict() {
        return this.myVisibleState != this.theirVisibleState;
    }

    public boolean isResolvedCompletely() {
        boolean ret = true;
        if (this.hasCoordConflict()) {
            boolean bl = ret = ret && !this.coordMergeDecision.equals((Object)MergeDecisionType.UNDECIDED);
        }
        if (this.hasDeletedStateConflict()) {
            boolean bl = ret = ret && !this.deletedMergeDecision.equals((Object)MergeDecisionType.UNDECIDED);
        }
        if (this.hasVisibleStateConflict()) {
            ret = ret && !this.visibleMergeDecision.equals((Object)MergeDecisionType.UNDECIDED);
        }
        return ret;
    }

    public List<Command> buildResolveCommand(OsmPrimitive my, OsmPrimitive their) throws OperationCancelledException {
        ArrayList<Command> cmds = new ArrayList<Command>();
        if (this.hasVisibleStateConflict() && this.isDecidedVisibleState()) {
            if (this.isVisibleStateDecision(MergeDecisionType.KEEP_MINE)) {
                try {
                    UndeletePrimitivesCommand cmd = this.createUndeletePrimitiveCommand(my);
                    if (cmd == null) {
                        throw new OperationCancelledException();
                    }
                    cmds.add(cmd);
                }
                catch (OsmTransferException e) {
                    this.handleExceptionWhileBuildingCommand(e);
                    throw new OperationCancelledException(e);
                }
            } else if (this.isVisibleStateDecision(MergeDecisionType.KEEP_THEIR)) {
                cmds.add(new PurgePrimitivesCommand(my));
            }
        }
        if (this.hasCoordConflict() && this.isDecidedCoord()) {
            cmds.add(new CoordinateConflictResolveCommand((Node)my, (Node)their, this.coordMergeDecision));
        }
        if (this.hasDeletedStateConflict() && this.isDecidedDeletedState()) {
            cmds.add(new DeletedStateConflictResolveCommand(my, their, this.deletedMergeDecision));
        }
        return cmds;
    }

    public OsmPrimitive getMyPrimitive() {
        return this.my;
    }

    protected void handleExceptionWhileBuildingCommand(Exception e) {
        e.printStackTrace();
        String msg = e.getMessage() != null ? e.getMessage() : e.toString();
        msg = msg.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>An error occurred while communicating with the server<br>Details: {0}</html>", msg), I18n.tr("Communication with server failed"), 0);
    }

    protected UndeletePrimitivesCommand createUndeletePrimitiveCommand(OsmPrimitive my) throws OsmTransferException {
        if (my instanceof Node) {
            return this.createUndeleteNodeCommand((Node)my);
        }
        if (my instanceof Way) {
            return this.createUndeleteWayCommand((Way)my);
        }
        if (my instanceof Relation) {
            return this.createUndeleteRelationCommand((Relation)my);
        }
        return null;
    }

    protected UndeletePrimitivesCommand createUndeleteNodeCommand(Node node) {
        return new UndeletePrimitivesCommand((OsmPrimitive)node);
    }

    protected boolean confirmUndeleteDependentPrimitives(Way way, ArrayList<OsmPrimitive> dependent) {
        Object[] options = new String[]{I18n.tr("Yes, undelete them too"), I18n.tr("No, cancel operation")};
        int ret = JOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>There are {0} additional nodes used by way {1}<br>which are deleted on the server.<br><br>Do you want to undelete these nodes too?</html>", Long.toString(dependent.size()), Long.toString(way.getId())), I18n.tr("Undelete additional nodes?"), 0, 3, null, options, options[0]);
        switch (ret) {
            case -1: {
                return false;
            }
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    protected boolean confirmUndeleteDependentPrimitives(Relation r, ArrayList<OsmPrimitive> dependent) {
        Object[] options = new String[]{I18n.tr("Yes, undelete them too"), I18n.tr("No, cancel operation")};
        int ret = JOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>There are {0} additional primitives referred to by relation {1}<br>which are deleted on the server.<br><br>Do you want to undelete them too?</html>", Long.toString(dependent.size()), Long.toString(r.getId())), I18n.tr("Undelete dependent primitives?"), 0, 3, null, options, options[0]);
        switch (ret) {
            case -1: {
                return false;
            }
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    protected UndeletePrimitivesCommand createUndeleteWayCommand(Way way) throws OsmTransferException {
        HashMap<Long, Node> candidates = new HashMap<Long, Node>();
        for (Node n : way.getNodes()) {
            if (n.isNew() || candidates.values().contains(n)) continue;
            candidates.put(n.getId(), n);
        }
        MultiFetchServerObjectReader reader = new MultiFetchServerObjectReader();
        reader.append(candidates.values());
        DataSet ds = reader.parseOsm(NullProgressMonitor.INSTANCE);
        ArrayList<OsmPrimitive> toDelete = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive their : ds.allPrimitives()) {
            if (!candidates.keySet().contains(their.getId()) || their.isVisible()) continue;
            toDelete.add((OsmPrimitive)candidates.get(their.getId()));
        }
        if (!toDelete.isEmpty() && !this.confirmUndeleteDependentPrimitives(way, toDelete)) {
            return null;
        }
        toDelete.add(way);
        return new UndeletePrimitivesCommand(toDelete);
    }

    protected UndeletePrimitivesCommand createUndeleteRelationCommand(Relation r) throws OsmTransferException {
        HashMap<Long, OsmPrimitive> candidates = new HashMap<Long, OsmPrimitive>();
        for (RelationMember m : r.getMembers()) {
            if (m.getMember().isNew() || candidates.values().contains(m.getMember())) continue;
            candidates.put(m.getMember().getId(), m.getMember());
        }
        MultiFetchServerObjectReader reader = new MultiFetchServerObjectReader();
        reader.append(candidates.values());
        DataSet ds = reader.parseOsm(NullProgressMonitor.INSTANCE);
        ArrayList<OsmPrimitive> toDelete = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive their : ds.allPrimitives()) {
            if (!candidates.keySet().contains(their.getId()) || their.isVisible()) continue;
            toDelete.add((OsmPrimitive)candidates.get(their.getId()));
        }
        if (!toDelete.isEmpty() && !this.confirmUndeleteDependentPrimitives(r, toDelete)) {
            return null;
        }
        toDelete.add(r);
        return new UndeletePrimitivesCommand(toDelete);
    }
}

