/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.zip.CRC32;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.help.Helpful;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigatableComponent
extends JComponent
implements Helpful {
    public static final int snapDistance = NavigatableComponent.sqr(Main.pref.getInteger("node.snap-distance", 10));
    private double scale = Main.proj.getDefaultZoomInPPD();
    protected EastNorth center = this.calculateDefaultCenter();

    private static int sqr(int a) {
        return a * a;
    }

    public NavigatableComponent() {
        this.setLayout(null);
    }

    protected DataSet getCurrentDataSet() {
        return Main.main.getCurrentDataSet();
    }

    private EastNorth calculateDefaultCenter() {
        Bounds b = Main.proj.getWorldBoundsLatLon();
        double lat = (b.max.lat() + b.min.lat()) / 2.0;
        double lon = (b.max.lon() + b.min.lon()) / 2.0;
        return Main.proj.latlon2eastNorth(new LatLon(lat, lon));
    }

    public Integer getViewID() {
        String x = this.center.east() + "_" + this.center.north() + "_" + this.scale + "_" + this.getWidth() + "_" + this.getHeight() + "_" + this.getProjection().toString();
        CRC32 id = new CRC32();
        id.update(x.getBytes());
        return new Long(id.getValue()).intValue();
    }

    public String getDist100PixelText() {
        double dist = this.getDist100Pixel();
        return dist >= 2000.0 ? Math.round(dist / 100.0) / 10L + " km" : (dist >= 1.0 ? Math.round(dist * 10.0) / 10L + " m" : "< 1 m");
    }

    public double getDist100Pixel() {
        int w = this.getWidth() / 2;
        int h = this.getHeight() / 2;
        LatLon ll1 = this.getLatLon(w - 50, h);
        LatLon ll2 = this.getLatLon(w + 50, h);
        return ll1.greatCircleDistance(ll2);
    }

    public EastNorth getCenter() {
        return this.center;
    }

    public EastNorth getEastNorth(int x, int y) {
        return new EastNorth(this.center.east() + ((double)x - (double)this.getWidth() / 2.0) * this.scale, this.center.north() - ((double)y - (double)this.getHeight() / 2.0) * this.scale);
    }

    public ProjectionBounds getProjectionBounds() {
        return new ProjectionBounds(new EastNorth(this.center.east() - (double)this.getWidth() / 2.0 * this.scale, this.center.north() - (double)this.getHeight() / 2.0 * this.scale), new EastNorth(this.center.east() + (double)this.getWidth() / 2.0 * this.scale, this.center.north() + (double)this.getHeight() / 2.0 * this.scale));
    }

    public ProjectionBounds getMaxProjectionBounds() {
        Bounds b = this.getProjection().getWorldBoundsLatLon();
        return new ProjectionBounds(this.getProjection().latlon2eastNorth(b.min), this.getProjection().latlon2eastNorth(b.max));
    }

    public Bounds getRealBounds() {
        return new Bounds(this.getProjection().eastNorth2latlon(new EastNorth(this.center.east() - (double)this.getWidth() / 2.0 * this.scale, this.center.north() - (double)this.getHeight() / 2.0 * this.scale)), this.getProjection().eastNorth2latlon(new EastNorth(this.center.east() + (double)this.getWidth() / 2.0 * this.scale, this.center.north() + (double)this.getHeight() / 2.0 * this.scale)));
    }

    public LatLon getLatLon(int x, int y) {
        return this.getProjection().eastNorth2latlon(this.getEastNorth(x, y));
    }

    public Point getPoint(EastNorth p) {
        if (null == p) {
            return new Point();
        }
        double x = (p.east() - this.center.east()) / this.scale + (double)(this.getWidth() / 2);
        double y = (this.center.north() - p.north()) / this.scale + (double)(this.getHeight() / 2);
        return new Point((int)x, (int)y);
    }

    public Point getPoint(LatLon latlon) {
        if (latlon == null) {
            return new Point();
        }
        if (latlon instanceof CachedLatLon) {
            return this.getPoint(((CachedLatLon)latlon).getEastNorth());
        }
        return this.getPoint(this.getProjection().latlon2eastNorth(latlon));
    }

    public Point getPoint(Node n) {
        return this.getPoint(n.getEastNorth());
    }

    private void zoomTo(EastNorth newCenter, double newScale) {
        boolean rep = false;
        Bounds b = this.getProjection().getWorldBoundsLatLon();
        CachedLatLon cl = new CachedLatLon(newCenter);
        boolean changed = false;
        double lat = cl.lat();
        double lon = cl.lon();
        if (lat < b.min.lat()) {
            changed = true;
            lat = b.min.lat();
        } else if (lat > b.max.lat()) {
            changed = true;
            lat = b.max.lat();
        }
        if (lon < b.min.lon()) {
            changed = true;
            lon = b.min.lon();
        } else if (lon > b.max.lon()) {
            changed = true;
            lon = b.max.lon();
        }
        if (changed) {
            newCenter = new CachedLatLon(lat, lon).getEastNorth();
        }
        if (!newCenter.equals(this.center)) {
            EastNorth oldCenter = this.center;
            this.center = newCenter;
            rep = true;
            this.firePropertyChange("center", oldCenter, newCenter);
        }
        int width = this.getWidth() / 2;
        int height = this.getHeight() / 2;
        LatLon l1 = new LatLon(b.min.lat(), lon);
        LatLon l2 = new LatLon(b.max.lat(), lon);
        EastNorth e1 = this.getProjection().latlon2eastNorth(l1);
        EastNorth e2 = this.getProjection().latlon2eastNorth(l2);
        double d = e2.north() - e1.north();
        if (d < (double)height * newScale) {
            double newScaleH = d / (double)height;
            e1 = this.getProjection().latlon2eastNorth(new LatLon(lat, b.min.lon()));
            e2 = this.getProjection().latlon2eastNorth(new LatLon(lat, b.max.lon()));
            d = e2.east() - e1.east();
            if (d < (double)width * newScale) {
                newScale = Math.max(newScaleH, d / (double)width);
            }
        } else if (newScale < (d /= l1.greatCircleDistance(l2) * (double)height * 10.0)) {
            newScale = d;
        }
        if (this.scale != newScale) {
            double oldScale = this.scale;
            this.scale = newScale;
            rep = true;
            this.firePropertyChange("scale", oldScale, newScale);
        }
        if (rep) {
            this.repaint();
        }
    }

    public void zoomTo(EastNorth newCenter) {
        this.zoomTo(newCenter, this.scale);
    }

    public void zoomTo(LatLon newCenter) {
        if (newCenter instanceof CachedLatLon) {
            this.zoomTo(((CachedLatLon)newCenter).getEastNorth(), this.scale);
        } else {
            this.zoomTo(this.getProjection().latlon2eastNorth(newCenter), this.scale);
        }
    }

    public void zoomToFactor(double x, double y, double factor) {
        double newScale = this.scale * factor;
        this.zoomTo(new EastNorth(this.center.east() - (x - (double)this.getWidth() / 2.0) * (newScale - this.scale), this.center.north() + (y - (double)this.getHeight() / 2.0) * (newScale - this.scale)), newScale);
    }

    public void zoomToFactor(EastNorth newCenter, double factor) {
        this.zoomTo(newCenter, this.scale * factor);
    }

    public void zoomToFactor(double factor) {
        this.zoomTo(this.center, this.scale * factor);
    }

    public void zoomTo(ProjectionBounds box) {
        int h;
        int w = this.getWidth() - 20;
        if (w < 20) {
            w = 20;
        }
        if ((h = this.getHeight() - 20) < 20) {
            h = 20;
        }
        double scaleX = (box.max.east() - box.min.east()) / (double)w;
        double scaleY = (box.max.north() - box.min.north()) / (double)h;
        double newScale = Math.max(scaleX, scaleY);
        this.zoomTo(box.getCenter(), newScale);
    }

    public void zoomTo(Bounds box) {
        this.zoomTo(new ProjectionBounds(this.getProjection().latlon2eastNorth(box.min), this.getProjection().latlon2eastNorth(box.max)));
    }

    public final Node getNearestNode(Point p) {
        double minDistanceSq = snapDistance;
        Node minPrimitive = null;
        DataSet ds = this.getCurrentDataSet();
        if (ds == null) {
            return null;
        }
        for (Node n : ds.nodes) {
            if (!n.isUsable()) continue;
            Point sp = this.getPoint(n);
            double dist = p.distanceSq(sp);
            if (dist < minDistanceSq) {
                minDistanceSq = dist;
                minPrimitive = n;
                continue;
            }
            if (dist != minDistanceSq || minPrimitive == null || (!n.isNew() || !ds.isSelected(n)) && (ds.isSelected(minPrimitive) || !ds.isSelected(n) && !n.isNew())) continue;
            minPrimitive = n;
        }
        return minPrimitive;
    }

    public final List<WaySegment> getNearestWaySegments(Point p) {
        TreeMap nearest = new TreeMap();
        DataSet ds = this.getCurrentDataSet();
        if (ds == null) {
            return null;
        }
        for (Way w : ds.ways) {
            if (!w.isUsable()) continue;
            Node lastN = null;
            int i = -2;
            for (Node n : w.getNodes()) {
                double b;
                ++i;
                if (n.isDeleted() || n.incomplete) continue;
                if (lastN == null) {
                    lastN = n;
                    continue;
                }
                Point A = this.getPoint(lastN);
                Point B = this.getPoint(n);
                double c = A.distanceSq(B);
                double a = p.distanceSq(B);
                double perDist = a - (a - (b = p.distanceSq(A)) + c) * (a - b + c) / 4.0 / c;
                if (perDist < (double)snapDistance && a < c + (double)snapDistance && b < c + (double)snapDistance) {
                    List<WaySegment> l;
                    if (ds.isSelected(w)) {
                        perDist -= 1.0E-5;
                    }
                    if (nearest.containsKey(perDist)) {
                        l = (List)nearest.get(perDist);
                    } else {
                        l = new LinkedList();
                        nearest.put(perDist, l);
                    }
                    l.add(new WaySegment(w, i));
                }
                lastN = n;
            }
        }
        ArrayList<WaySegment> nearestList = new ArrayList<WaySegment>();
        for (List wss : nearest.values()) {
            nearestList.addAll(wss);
        }
        return nearestList;
    }

    public final WaySegment getNearestWaySegment(Point p, Collection<WaySegment> ignore) {
        List<WaySegment> nearest = this.getNearestWaySegments(p);
        if (nearest == null) {
            return null;
        }
        if (ignore != null) {
            nearest.removeAll(ignore);
        }
        return nearest.isEmpty() ? null : nearest.get(0);
    }

    public final WaySegment getNearestWaySegment(Point p) {
        return this.getNearestWaySegment(p, null);
    }

    public final Way getNearestWay(Point p) {
        WaySegment nearestWaySeg = this.getNearestWaySegment(p);
        return nearestWaySeg == null ? null : nearestWaySeg.way;
    }

    public OsmPrimitive getNearest(Point p) {
        OsmPrimitive osm = this.getNearestNode(p);
        if (osm == null) {
            osm = this.getNearestWay(p);
        }
        return osm;
    }

    public Collection<OsmPrimitive> getNearestCollection(Point p) {
        OsmPrimitive osm = this.getNearest(p);
        if (osm == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(osm);
    }

    public Collection<OsmPrimitive> getAllNearest(Point p) {
        HashSet<OsmPrimitive> nearest = new HashSet<OsmPrimitive>();
        DataSet ds = this.getCurrentDataSet();
        if (ds == null) {
            return null;
        }
        block0: for (Way w : ds.ways) {
            if (!w.isUsable()) continue;
            Node lastN = null;
            for (Node n : w.getNodes()) {
                double b;
                if (!n.isUsable()) continue;
                if (lastN == null) {
                    lastN = n;
                    continue;
                }
                Point A = this.getPoint(lastN);
                Point B = this.getPoint(n);
                double c = A.distanceSq(B);
                double a = p.distanceSq(B);
                double perDist = a - (a - (b = p.distanceSq(A)) + c) * (a - b + c) / 4.0 / c;
                if (perDist < (double)snapDistance && a < c + (double)snapDistance && b < c + (double)snapDistance) {
                    nearest.add(w);
                    continue block0;
                }
                lastN = n;
            }
        }
        for (Node n : ds.nodes) {
            if (!n.isUsable() || !(this.getPoint(n).distanceSq(p) < (double)snapDistance)) continue;
            nearest.add(n);
        }
        return nearest.isEmpty() ? null : nearest;
    }

    public Collection<Node> getNearestNodes(Point p) {
        HashSet<Node> nearest = new HashSet<Node>();
        DataSet ds = this.getCurrentDataSet();
        if (ds == null) {
            return null;
        }
        for (Node n : ds.nodes) {
            if (!n.isUsable() || !(this.getPoint(n).distanceSq(p) < (double)snapDistance)) continue;
            nearest.add(n);
        }
        return nearest.isEmpty() ? null : nearest;
    }

    public final Collection<Node> getNearestNodes(Point p, Collection<Node> ignore) {
        Collection<Node> nearest = this.getNearestNodes(p);
        if (nearest == null) {
            return null;
        }
        if (ignore != null) {
            nearest.removeAll(ignore);
        }
        return nearest.isEmpty() ? null : nearest;
    }

    public Projection getProjection() {
        return Main.proj;
    }

    @Override
    public String helpTopic() {
        String n = this.getClass().getName();
        return n.substring(n.lastIndexOf(46) + 1);
    }
}

