/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MapStatus
extends JPanel
implements Helpful {
    final MapView mv;
    ImageLabel lonText = new ImageLabel("lon", I18n.tr("The geographic longitude at the mouse pointer."), 11);
    ImageLabel nameText = new ImageLabel("name", I18n.tr("The name of the object at the mouse pointer."), 20);
    JTextField helpText = new JTextField();
    ImageLabel latText = new ImageLabel("lat", I18n.tr("The geographic latitude at the mouse pointer."), 10);
    ImageLabel angleText = new ImageLabel("angle", I18n.tr("The angle between the previous and the current way segment."), 6);
    ImageLabel headingText = new ImageLabel("heading", I18n.tr("The (compass) heading of the line segment being drawn."), 6);
    ImageLabel distText = new ImageLabel("dist", I18n.tr("The length of the new way segment being drawn."), 8);
    public Thread thread;
    MouseState mouseState = new MouseState();

    public MapStatus(final MapFrame mapFrame) {
        this.mv = mapFrame.mapView;
        this.mv.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                this.mouseMoved(e);
            }

            public void mouseMoved(MouseEvent e) {
                if (MapStatus.this.mv.center == null) {
                    return;
                }
                if ((e.getModifiersEx() & 0x80) == 0) {
                    CoordinateFormat mCord = CoordinateFormat.getDefaultFormat();
                    LatLon p = MapStatus.this.mv.getLatLon(e.getX(), e.getY());
                    MapStatus.this.latText.setText(p.latToString(mCord));
                    MapStatus.this.lonText.setText(p.lonToString(mCord));
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.latText, GBC.std());
        this.add((Component)this.lonText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.headingText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.angleText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.distText, GBC.std().insets(3, 0, 0, 0));
        this.helpText.setEditable(false);
        this.add((Component)this.nameText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.helpText, GBC.eol().insets(3, 0, 0, 0).fill(2));
        final Collector collector = new Collector(mapFrame);
        this.thread = new Thread((Runnable)collector, "Map Status Collector");
        this.thread.setDaemon(true);
        this.thread.start();
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void eventDispatched(AWTEvent event) {
                    if (event instanceof ComponentEvent && ((ComponentEvent)event).getComponent() == mapFrame.mapView) {
                        Collector collector2 = collector;
                        synchronized (collector2) {
                            MapStatus.this.mouseState.modifiers = ((InputEvent)event).getModifiersEx();
                            if (event instanceof MouseEvent) {
                                MapStatus.this.mouseState.mousePos = ((MouseEvent)event).getPoint();
                            }
                            collector.notify();
                        }
                    }
                }
            }, 56L);
        }
        catch (SecurityException ex) {
            mapFrame.mapView.addMouseMotionListener(new MouseMotionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void mouseMoved(MouseEvent e) {
                    Collector collector2 = collector;
                    synchronized (collector2) {
                        MapStatus.this.mouseState.modifiers = e.getModifiersEx();
                        MapStatus.this.mouseState.mousePos = e.getPoint();
                        collector.notify();
                    }
                }

                public void mouseDragged(MouseEvent e) {
                    this.mouseMoved(e);
                }
            });
            mapFrame.mapView.addKeyListener(new KeyAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void keyPressed(KeyEvent e) {
                    Collector collector2 = collector;
                    synchronized (collector2) {
                        MapStatus.this.mouseState.modifiers = e.getModifiersEx();
                        collector.notify();
                    }
                }

                public void keyReleased(KeyEvent e) {
                    this.keyPressed(e);
                }
            });
        }
    }

    public String helpTopic() {
        return "Statusline";
    }

    public void addMouseListener(MouseListener ml) {
        this.lonText.addMouseListener(ml);
        this.latText.addMouseListener(ml);
    }

    public void setHelpText(String t) {
        this.helpText.setText(t);
        this.helpText.setToolTipText(t);
    }

    public void setAngle(double a) {
        this.angleText.setText(a < 0.0 ? "--" : (double)Math.round(a * 10.0) / 10.0 + " \u00b0");
    }

    public void setHeading(double h) {
        this.headingText.setText(h < 0.0 ? "--" : (double)Math.round(h * 10.0) / 10.0 + " \u00b0");
    }

    public void setDist(double dist) {
        String text = dist > 1000.0 ? (double)Math.round(dist / 100.0) / 10.0 + " km" : (double)Math.round(dist * 10.0) / 10.0 + " m";
        this.distText.setText(dist < 0.0 ? "--" : text);
    }

    class MouseState {
        Point mousePos;
        int modifiers;

        MouseState() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Collector
    implements Runnable {
        private Point oldMousePos;
        private List<JLabel> popupLabels = null;
        private Popup popup;
        private MapFrame parent;

        public Collector(MapFrame parent) {
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                MouseState ms = new MouseState();
                Collector collector = this;
                synchronized (collector) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    ms.modifiers = MapStatus.this.mouseState.modifiers;
                    ms.mousePos = MapStatus.this.mouseState.mousePos;
                }
                if (this.parent != Main.map) {
                    return;
                }
                if (ms.mousePos == null || MapStatus.this.mv.center == null) continue;
                if ((ms.modifiers & 0x80) != 0) {
                    this.popupUpdateLabels();
                    continue;
                }
                try {
                    boolean middleMouseDown;
                    this.statusBarElementUpdate(ms);
                    boolean isAtOldPosition = this.oldMousePos != null && this.oldMousePos.equals(ms.mousePos) && this.popup != null;
                    boolean bl = middleMouseDown = (ms.modifiers & 0x800) != 0;
                    if (middleMouseDown || isAtOldPosition) {
                        Collection<OsmPrimitive> osms = MapStatus.this.mv.getAllNearest(ms.mousePos);
                        if (osms == null) continue;
                        JPanel c = new JPanel(new GridBagLayout());
                        JLabel lbl = new JLabel("<html>" + I18n.tr("Middle click again to cycle through.<br>Hold CTRL to select directly from this list with the mouse.<hr>") + "</html>", null, 0);
                        lbl.setHorizontalAlignment(2);
                        c.add((Component)lbl, GBC.eol().insets(2, 0, 2, 0));
                        if (isAtOldPosition && middleMouseDown) {
                            this.popupCycleSelection(osms, ms.modifiers);
                        }
                        ArrayList<JLabel> lbls = new ArrayList<JLabel>();
                        for (OsmPrimitive osm : osms) {
                            JLabel l = this.popupBuildPrimitiveLabels(osm);
                            lbls.add(l);
                            c.add((Component)l, GBC.eol().fill(2).insets(2, 0, 2, 2));
                        }
                        this.popupShowPopup(this.popupCreatePopup(c, ms), lbls);
                    } else {
                        this.popupHidePopup();
                    }
                    this.oldMousePos = ms.mousePos;
                }
                catch (ConcurrentModificationException x) {
                }
                catch (NullPointerException nullPointerException) {
                }
            }
        }

        private final Popup popupCreatePopup(Component content, MouseState ms) {
            int yPos;
            Point p = MapStatus.this.mv.getLocationOnScreen();
            Dimension scrn = Toolkit.getDefaultToolkit().getScreenSize();
            JScrollPane sp = new JScrollPane(content);
            sp.setHorizontalScrollBarPolicy(31);
            sp.setBorder(BorderFactory.createRaisedBevelBorder());
            Dimension prefsize = sp.getPreferredSize();
            int w = Math.min(prefsize.width, Math.min(800, scrn.width / 2 - 16));
            int h = Math.min(prefsize.height, scrn.height - 10);
            sp.setPreferredSize(new Dimension(w, h));
            int xPos = p.x + ms.mousePos.x + 16;
            if (xPos + w > scrn.width && xPos > scrn.width / 2) {
                xPos = p.x + ms.mousePos.x - 4 - w;
            }
            if ((yPos = p.y + ms.mousePos.y + 16) + h > scrn.height - 5) {
                yPos = Math.max(5, scrn.height - h - 5);
            }
            PopupFactory pf = PopupFactory.getSharedInstance();
            return pf.getPopup(MapStatus.this.mv, sp, xPos, yPos);
        }

        private final void statusBarElementUpdate(MouseState ms) {
            OsmPrimitive osmNearest = MapStatus.this.mv.getNearest(ms.mousePos);
            if (osmNearest != null) {
                MapStatus.this.nameText.setText(osmNearest.getDisplayName(DefaultNameFormatter.getInstance()));
            } else {
                MapStatus.this.nameText.setText(I18n.tr("(no object)"));
            }
        }

        private final void popupCycleSelection(Collection<OsmPrimitive> osms, int mods) {
            DataSet ds = Main.main.getCurrentDataSet();
            OsmPrimitive firstItem = null;
            OsmPrimitive firstSelected = null;
            OsmPrimitive nextSelected = null;
            for (OsmPrimitive osm : osms) {
                if (firstItem == null) {
                    firstItem = osm;
                }
                if (firstSelected != null && nextSelected == null) {
                    nextSelected = osm;
                }
                if (firstSelected != null || !ds.isSelected(osm)) continue;
                firstSelected = osm;
            }
            if ((mods & 0x40) == 0) {
                ds.clearSelection(new OsmPrimitive[0]);
            }
            if (firstSelected == null) {
                ds.addSelected(firstItem);
            } else {
                ds.clearSelection(firstSelected);
                if (nextSelected != null) {
                    ds.addSelected(nextSelected);
                }
            }
            DataSet.fireSelectionChanged(ds.getSelected());
        }

        private final void popupHidePopup() {
            this.popupLabels = null;
            if (this.popup == null) {
                return;
            }
            final Popup staticPopup = this.popup;
            this.popup = null;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    staticPopup.hide();
                }
            });
        }

        private final void popupShowPopup(Popup newPopup, List<JLabel> lbls) {
            final Popup staticPopup = newPopup;
            if (this.popup != null) {
                final Popup staticOldPopup = this.popup;
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        staticPopup.show();
                        staticOldPopup.hide();
                    }
                });
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        staticPopup.show();
                    }
                });
            }
            this.popupLabels = lbls;
            this.popup = newPopup;
        }

        private final void popupUpdateLabels() {
            if (this.popup == null || this.popupLabels == null) {
                return;
            }
            for (JLabel l : this.popupLabels) {
                l.validate();
            }
        }

        private final void popupSetLabelColors(JLabel lbl, OsmPrimitive osm) {
            DataSet ds = Main.main.getCurrentDataSet();
            if (ds.isSelected(osm)) {
                lbl.setBackground(SystemColor.textHighlight);
                lbl.setForeground(SystemColor.textHighlightText);
            } else {
                lbl.setBackground(SystemColor.control);
                lbl.setForeground(SystemColor.controlText);
            }
        }

        private final JLabel popupBuildPrimitiveLabels(final OsmPrimitive osm) {
            StringBuilder text = new StringBuilder();
            String name = osm.getDisplayName(DefaultNameFormatter.getInstance());
            if (osm.isNew() || osm.isModified()) {
                name = "<i><b>" + name + "*</b></i>";
            }
            text.append(name);
            if (!osm.isNew()) {
                text.append(" [id=" + osm.getId() + "]");
            }
            if (osm.getUser() != null) {
                text.append(" [" + I18n.tr("User:") + " " + osm.getUser().getName() + "]");
            }
            for (Map.Entry<String, String> e1 : osm.entrySet()) {
                text.append("<br>" + e1.getKey() + "=" + e1.getValue());
            }
            final JLabel l = new JLabel("<html>" + text.toString() + "</html>", ImageProvider.get(OsmPrimitiveType.from(osm)), 0){

                public void validate() {
                    super.validate();
                    Collector.this.popupSetLabelColors(this, osm);
                }
            };
            l.setOpaque(true);
            this.popupSetLabelColors(l, osm);
            l.setFont(l.getFont().deriveFont(0));
            l.setVerticalTextPosition(1);
            l.setHorizontalAlignment(2);
            l.setCursor(Cursor.getPredefinedCursor(12));
            l.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    l.setBackground(SystemColor.info);
                    l.setForeground(SystemColor.infoText);
                }

                public void mouseExited(MouseEvent e) {
                    Collector.this.popupSetLabelColors(l, osm);
                }

                public void mouseClicked(MouseEvent e) {
                    DataSet ds = Main.main.getCurrentDataSet();
                    ds.toggleSelected(osm);
                    DataSet.fireSelectionChanged(ds.getSelected());
                    l.validate();
                }
            });
            l.addMouseMotionListener(new MouseMotionListener(){

                public void mouseMoved(MouseEvent e) {
                    l.setBackground(SystemColor.info);
                    l.setForeground(SystemColor.infoText);
                }

                public void mouseDragged(MouseEvent e) {
                    l.setBackground(SystemColor.info);
                    l.setForeground(SystemColor.infoText);
                }
            });
            return l;
        }
    }

    class ImageLabel
    extends JPanel {
        private JLabel tf;
        private int chars;

        public ImageLabel(String img, String tooltip, int chars) {
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.decode("#b8cfe5"));
            this.add((Component)new JLabel(ImageProvider.get("statusline/" + img + ".png")), GBC.std().anchor(17).insets(0, 1, 1, 0));
            this.tf = new JLabel();
            this.add((Component)this.tf, GBC.std().fill(1).anchor(17).insets(2, 1, 1, 0));
            this.setToolTipText(tooltip);
            this.chars = chars;
        }

        public void setText(String t) {
            this.tf.setText(t);
        }

        public Dimension getPreferredSize() {
            return new Dimension(25 + this.chars * this.tf.getFontMetrics(this.tf.getFont()).charWidth('0'), super.getPreferredSize().height);
        }

        public Dimension getMinimumSize() {
            return new Dimension(25 + this.chars * this.tf.getFontMetrics(this.tf.getFont()).charWidth('0'), super.getMinimumSize().height);
        }
    }
}

