/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.help.HelpBrowserProxy;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class ExtendedDialog
extends JDialog {
    private int result = 0;
    public static final int DialogNotShown = -99;
    public static final int DialogClosedOtherwise = 0;
    private boolean toggleable = false;
    private String rememberSizePref = "";
    private WindowGeometry defaultWindowGeometry = null;
    private String togglePref = "";
    private String toggleCheckboxText = I18n.tr("Do not show again");
    private JCheckBox toggleCheckbox = null;
    private Component parent;
    private Component content;
    private final String[] bTexts;
    private String[] bToolTipTexts;
    private String[] bIcons;
    private boolean showHelpButton;
    private String helpTopic;
    private boolean placeContentInScrollPane;
    protected Object contentConstraints = GBC.eol().anchor(10).fill(1).insets(5, 10, 5, 0);
    protected ArrayList<JButton> buttons = new ArrayList();

    public ExtendedDialog(Component parent, String title, String[] buttonTexts) {
        super(JOptionPane.getFrameForComponent(parent), title, true);
        this.parent = parent;
        this.bTexts = buttonTexts;
    }

    public ExtendedDialog(Component parent, String title, String[] buttonTexts, boolean modal) {
        super(JOptionPane.getFrameForComponent(parent), title, modal);
        this.parent = parent;
        this.bTexts = buttonTexts;
    }

    public void setButtonIcons(String[] buttonIcons) {
        this.bIcons = buttonIcons;
    }

    public void setToolTipTexts(String[] toolTipTexts) {
        this.bToolTipTexts = toolTipTexts;
    }

    public void setContent(Component content) {
        this.setContent(content, true);
    }

    public void setContent(Component content, boolean placeContentInScrollPane) {
        this.content = content;
        this.placeContentInScrollPane = placeContentInScrollPane;
    }

    public void setContent(String message) {
        this.setContent(ExtendedDialog.string2label(message), false);
    }

    public void showDialog() {
        if (this.toggleCheckState(this.togglePref)) {
            this.result = -99;
            return;
        }
        this.setupDialog();
        this.setVisible(true);
        this.toggleSaveState();
    }

    public int getValue() {
        return this.result;
    }

    @Deprecated
    protected void setupDialog(Component content, String[] buttonIcons) {
        this.setContent(content);
        this.setButtonIcons(buttonIcons);
        this.setupDialog();
    }

    protected void setupDialog() {
        boolean limitedInHeight;
        this.setupEscListener();
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        for (int i = 0; i < this.bTexts.length; ++i) {
            AbstractAction action = new AbstractAction(this.bTexts[i]){

                public void actionPerformed(ActionEvent evt) {
                    ExtendedDialog.this.buttonAction(evt);
                }
            };
            JButton button = new JButton(action);
            if (this.bIcons != null && this.bIcons[i] != null) {
                button.setIcon(ImageProvider.get(this.bIcons[i]));
            }
            if (this.bToolTipTexts != null && i < this.bToolTipTexts.length && this.bToolTipTexts[i] != null) {
                button.setToolTipText(this.bToolTipTexts[i]);
            }
            if (i == 0) {
                this.rootPane.setDefaultButton(button);
            }
            buttonsPanel.add((Component)button, GBC.std().insets(2, 2, 2, 2));
            this.buttons.add(button);
        }
        if (this.showHelpButton) {
            buttonsPanel.add((Component)new JButton(new HelpAction()), GBC.std().insets(2, 2, 2, 2));
            HelpUtil.setHelpContext(this.getRootPane(), this.helpTopic);
        }
        JPanel cp = new JPanel(new GridBagLayout());
        cp.add(this.content, this.contentConstraints);
        if (this.toggleable) {
            this.toggleCheckbox = new JCheckBox(this.toggleCheckboxText);
            boolean showDialog = Main.pref.getBoolean("message." + this.togglePref, true);
            this.toggleCheckbox.setSelected(!showDialog);
            cp.add((Component)this.toggleCheckbox, GBC.eol().anchor(21).insets(5, 5, 5, 5));
        }
        cp.add((Component)buttonsPanel, GBC.eol().anchor(10).insets(5, 5, 5, 5));
        if (this.placeContentInScrollPane) {
            JScrollPane pane = new JScrollPane(cp);
            pane.setBorder(null);
            this.setContentPane(pane);
        } else {
            this.setContentPane(cp);
        }
        this.pack();
        Dimension d = this.getSize();
        Dimension x = this.findMaxDialogSize();
        boolean limitedInWidth = d.width > x.width;
        boolean bl = limitedInHeight = d.height > x.height;
        if (x.width > 0 && d.width > x.width) {
            d.width = x.width;
        }
        if (x.height > 0 && d.height > x.height) {
            d.height = x.height;
        }
        if (!limitedInWidth && limitedInHeight) {
            d.width += new JScrollBar().getPreferredSize().width;
        }
        this.setSize(d);
        this.setLocationRelativeTo(this.parent);
    }

    protected void buttonAction(ActionEvent evt) {
        String a = evt.getActionCommand();
        for (int i = 0; i < this.bTexts.length; ++i) {
            if (!this.bTexts[i].equals(a)) continue;
            this.result = i + 1;
            break;
        }
        this.setVisible(false);
    }

    protected Dimension findMaxDialogSize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension x = new Dimension(Math.round(screenSize.width * 2 / 3), Math.round(screenSize.height * 2 / 3));
        try {
            if (this.parent != null) {
                x = JOptionPane.getFrameForComponent(this.parent).getSize();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return x;
    }

    private void setupEscListener() {
        AbstractAction actionListener = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedDialog.this.result = 0;
                ExtendedDialog.this.setVisible(false);
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", actionListener);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.repaint();
        }
        if (this.rememberSizePref.length() != 0 && this.defaultWindowGeometry != null) {
            if (visible) {
                new WindowGeometry(this.rememberSizePref, this.defaultWindowGeometry).apply(this);
            } else {
                new WindowGeometry(this).remember(this.rememberSizePref);
            }
        }
        super.setVisible(visible);
    }

    public void setRememberWindowGeometry(String pref, WindowGeometry wg) {
        this.rememberSizePref = pref == null ? "" : pref;
        this.defaultWindowGeometry = wg;
    }

    public void toggleEnable(String togglePref) {
        this.toggleable = true;
        this.togglePref = togglePref;
    }

    public void toggleDisable() {
        this.toggleable = false;
    }

    public void setToggleCheckboxText(String text) {
        this.toggleCheckboxText = text;
    }

    private boolean toggleCheckState(String togglePref) {
        boolean bl = this.toggleable = togglePref != null && !togglePref.equals("");
        if (!this.toggleable) {
            return false;
        }
        this.togglePref = togglePref;
        return !Main.pref.getBoolean("message." + togglePref, true);
    }

    private void toggleSaveState() {
        if (!this.toggleable || this.toggleCheckbox == null) {
            return;
        }
        Main.pref.put("message." + this.togglePref, !this.toggleCheckbox.isSelected());
    }

    private static JMultilineLabel string2label(String msg) {
        JMultilineLabel lbl = new JMultilineLabel(msg);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        lbl.setMaxWidth(Math.round(screenSize.width * 1 / 2));
        return lbl;
    }

    public void configureContextsensitiveHelp(String helpTopic, boolean showHelpButton) {
        this.helpTopic = helpTopic;
        this.showHelpButton = showHelpButton;
    }

    class HelpAction
    extends AbstractAction {
        public HelpAction() {
            this.putValue("ShortDescription", I18n.tr("Show help information"));
            this.putValue("Name", I18n.tr("Help"));
            this.putValue("SmallIcon", ImageProvider.get("help"));
        }

        public void actionPerformed(ActionEvent e) {
            HelpBrowserProxy.getInstance().setUrlForHelpTopic(ExtendedDialog.this.helpTopic);
        }
    }
}

