/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNameFormatter
implements NameFormatter {
    private static DefaultNameFormatter instance;
    public static final String[] DEFAULT_NAMING_TAGS_FOR_RELATIONS;
    private static List<String> namingTagsForRelations;

    public static DefaultNameFormatter getInstance() {
        if (instance == null) {
            instance = new DefaultNameFormatter();
        }
        return instance;
    }

    public static List<String> getNamingtagsForRelations() {
        if (namingTagsForRelations == null) {
            namingTagsForRelations = new ArrayList<String>(Main.pref.getCollection("relation.nameOrder", Arrays.asList(DEFAULT_NAMING_TAGS_FOR_RELATIONS)));
        }
        return namingTagsForRelations;
    }

    protected String decorateNameWithId(String name, OsmPrimitive primitive) {
        if (Main.pref.getBoolean("osm-primitives.showid")) {
            return name + I18n.tr(" [id: {0}]", primitive.getId());
        }
        return name;
    }

    @Override
    public String format(Node node) {
        String name = "";
        if (node.incomplete) {
            name = I18n.tr("incomplete");
        } else {
            name = Main.pref.getBoolean("osm-primitives.localize-name", true) ? node.getLocalName() : node.getName();
            if (name == null) {
                name = node.isNew() ? I18n.tr("node") : "" + node.getId();
            }
            name = name + " (" + node.getCoor().latToString(CoordinateFormat.getDefaultFormat()) + ", " + node.getCoor().lonToString(CoordinateFormat.getDefaultFormat()) + ")";
        }
        name = this.decorateNameWithId(name, node);
        return name;
    }

    @Override
    public String format(Way way) {
        String name = "";
        if (way.incomplete) {
            name = I18n.tr("incomplete");
        } else {
            name = Main.pref.getBoolean("osm-primitives.localize-name", true) ? way.getLocalName() : way.getName();
            if (name == null) {
                name = way.get("ref");
            }
            if (name == null) {
                name = way.get("highway") != null ? I18n.tr("highway") : (way.get("railway") != null ? I18n.tr("railway") : (way.get("waterway") != null ? I18n.tr("waterway") : (way.get("landuse") != null ? I18n.tr("landuse") : "")));
            }
            int nodesNo = new HashSet<Node>(way.getNodes()).size();
            String nodes = I18n.trn("{0} node", "{0} nodes", nodesNo, nodesNo);
            name = name + (name.length() > 0 ? " (" + nodes + ")" : nodes);
            if (way.errors != null) {
                name = "*" + name;
            }
        }
        name = this.decorateNameWithId(name, way);
        return name;
    }

    @Override
    public String format(Relation relation) {
        String name;
        if (relation.incomplete) {
            name = I18n.tr("incomplete");
        } else {
            name = relation.get("type");
            if (name == null) {
                name = I18n.tr("relation");
            }
            name = name + " (";
            String nameTag = null;
            HashSet<String> namingTags = new HashSet<String>(DefaultNameFormatter.getNamingtagsForRelations());
            for (String n : relation.keySet()) {
                if (namingTags.contains(n.trim()) && (nameTag = Main.pref.getBoolean("osm-primitives.localize-name", true) ? relation.getLocalName() : relation.getName()) == null) {
                    nameTag = relation.get(n);
                }
                if (nameTag == null) continue;
                break;
            }
            name = nameTag == null ? name + Long.toString(relation.getId()) + ", " : name + "\"" + nameTag + "\", ";
            int mbno = relation.getMembersCount();
            name = name + I18n.trn("{0} member", "{0} members", mbno, mbno) + ")";
            if (relation.errors != null) {
                name = "*" + name;
            }
        }
        name = this.decorateNameWithId(name, relation);
        return name;
    }

    @Override
    public String format(Changeset changeset) {
        return I18n.tr("Changeset {0}", changeset.getId());
    }

    static {
        DEFAULT_NAMING_TAGS_FOR_RELATIONS = new String[]{"name", "ref", "restriction", "note"};
        namingTagsForRelations = null;
    }
}

