/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ConditionalOptionPaneUtil {
    public static final int DIALOG_DISABLED_OPTION = Integer.MIN_VALUE;

    private ConditionalOptionPaneUtil() {
    }

    public static boolean getDialogShowingEnabled(String prefKey) {
        return Main.pref.getBoolean("message." + prefKey, true);
    }

    public static void setDialogShowingEnabled(String prefKey, boolean enabled) {
        Main.pref.put("message." + prefKey, enabled);
    }

    public static int showOptionDialog(String preferenceKey, Component parent, Object message, String title, int optionType, int messageType, Object[] options, Object defaultOption) throws HeadlessException {
        if (!ConditionalOptionPaneUtil.getDialogShowingEnabled(preferenceKey)) {
            return Integer.MIN_VALUE;
        }
        MessagePanel pnl = new MessagePanel(preferenceKey, message);
        int ret = JOptionPane.showOptionDialog(parent, pnl, title, optionType, messageType, null, options, defaultOption);
        pnl.remeberDialogShowingEnabled();
        return ret;
    }

    public static boolean showConfirmationDialog(String preferenceKey, Component parent, Object message, String title, int optionType, int messageType, int trueOption) throws HeadlessException {
        if (!ConditionalOptionPaneUtil.getDialogShowingEnabled(preferenceKey)) {
            return true;
        }
        MessagePanel pnl = new MessagePanel(preferenceKey, message);
        int ret = JOptionPane.showConfirmDialog(parent, pnl, title, optionType, messageType);
        pnl.remeberDialogShowingEnabled();
        return ret == trueOption;
    }

    public static void showMessageDialog(String preferenceKey, Component parent, Object message, String title, int messageType) {
        if (!ConditionalOptionPaneUtil.getDialogShowingEnabled(preferenceKey)) {
            return;
        }
        MessagePanel pnl = new MessagePanel(preferenceKey, message);
        JOptionPane.showMessageDialog(parent, pnl, title, messageType);
        pnl.remeberDialogShowingEnabled();
    }

    private static class MessagePanel
    extends JPanel {
        JCheckBox cbShowDialog;
        String preferenceKey;

        public MessagePanel(String preferenceKey, Object message) {
            this.preferenceKey = preferenceKey;
            this.cbShowDialog = new JCheckBox(I18n.tr("Do not show again"));
            this.cbShowDialog.setSelected(!ConditionalOptionPaneUtil.getDialogShowingEnabled(preferenceKey));
            this.setLayout(new GridBagLayout());
            if (message instanceof Component) {
                this.add((Component)message, GBC.eop());
            } else {
                this.add((Component)new JLabel(message.toString()), GBC.eop());
            }
            this.add((Component)this.cbShowDialog, GBC.eol());
        }

        public boolean getDialogShowingEnabled() {
            return this.cbShowDialog.isSelected();
        }

        public void remeberDialogShowingEnabled() {
            ConditionalOptionPaneUtil.setDialogShowingEnabled(this.preferenceKey, !this.getDialogShowingEnabled());
        }
    }
}

