/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;

public class BoundingXYVisitor
extends AbstractVisitor {
    private ProjectionBounds bounds = null;

    public void visit(Node n) {
        this.visit(n.getEastNorth());
    }

    public void visit(Way w) {
        if (w.incomplete) {
            return;
        }
        for (Node n : w.getNodes()) {
            this.visit(n);
        }
    }

    public void visit(Relation e) {
        for (RelationMember m : e.getMembers()) {
            if (m.isRelation()) continue;
            m.getMember().visit(this);
        }
    }

    public void visit(Bounds b) {
        if (b != null) {
            this.visit(b.min);
            this.visit(b.max);
        }
    }

    public void visit(ProjectionBounds b) {
        if (b != null) {
            this.visit(b.min);
            this.visit(b.max);
        }
    }

    public void visit(LatLon latlon) {
        if (latlon != null) {
            if (latlon instanceof CachedLatLon) {
                this.visit(((CachedLatLon)latlon).getEastNorth());
            } else {
                this.visit(Main.proj.latlon2eastNorth(latlon));
            }
        }
    }

    public void visit(EastNorth eastNorth) {
        if (eastNorth != null) {
            if (this.bounds == null) {
                this.bounds = new ProjectionBounds(eastNorth);
            } else {
                this.bounds.extend(eastNorth);
            }
        }
    }

    public boolean hasExtend() {
        return this.bounds != null && !this.bounds.min.equals(this.bounds.max);
    }

    public ProjectionBounds getBounds() {
        return this.bounds;
    }

    public void enlargeBoundingBox() {
        this.enlargeBoundingBox(0.002);
    }

    public void enlargeBoundingBox(double enlargeDegree) {
        if (this.bounds == null) {
            return;
        }
        LatLon minLatlon = Main.proj.eastNorth2latlon(this.bounds.min);
        LatLon maxLatlon = Main.proj.eastNorth2latlon(this.bounds.max);
        this.bounds = new ProjectionBounds(Main.proj.latlon2eastNorth(new LatLon(minLatlon.lat() - enlargeDegree, minLatlon.lon() - enlargeDegree)), Main.proj.latlon2eastNorth(new LatLon(maxLatlon.lat() + enlargeDegree, maxLatlon.lon() + enlargeDegree)));
    }

    public String toString() {
        return "BoundingXYVisitor[" + this.bounds + "]";
    }
}

