/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.CopyList;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Way
extends OsmPrimitive {
    private Node[] nodes = new Node[0];
    public boolean isMappaintArea = false;
    public Integer mappaintDrawnAreaCode = 0;

    public List<Node> getNodes() {
        return new CopyList<Node>(this.nodes);
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes == null ? new Node[0] : nodes.toArray(new Node[nodes.size()]);
        this.clearCached();
    }

    public int getNodesCount() {
        return this.nodes.length;
    }

    public Node getNode(int index) {
        return this.nodes[index];
    }

    public boolean containsNode(Node node) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (!this.nodes[i].equals(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void clearCached() {
        super.clearCached();
        this.isMappaintArea = false;
        this.mappaintDrawnAreaCode = 0;
    }

    public ArrayList<Pair<Node, Node>> getNodePairs(boolean sort) {
        ArrayList<Pair<Node, Node>> chunkSet = new ArrayList<Pair<Node, Node>>();
        if (this.incomplete) {
            return chunkSet;
        }
        Node lastN = null;
        for (Node n : this.nodes) {
            if (lastN == null) {
                lastN = n;
                continue;
            }
            Pair<Node, Node> np = new Pair<Node, Node>(lastN, n);
            if (sort) {
                Pair.sort(np);
            }
            chunkSet.add(np);
            lastN = n;
        }
        return chunkSet;
    }

    @Override
    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    protected Way(long id, boolean allowNegative) {
        super(id, allowNegative);
    }

    public Way() {
        super(0L, false);
    }

    public Way(Way original) {
        super(original.getUniqueId(), true);
        this.cloneFrom(original);
    }

    public Way(long id) throws IllegalArgumentException {
        super(id, false);
    }

    public Way(WayData data, DataSet dataSet) {
        super(data);
        this.load(data, dataSet);
    }

    @Override
    public void load(PrimitiveData data, DataSet dataSet) {
        super.load(data, dataSet);
        WayData wayData = (WayData)data;
        Node marker = new Node(0L);
        HashMap<Long, Node> foundNodes = new HashMap<Long, Node>();
        for (Long nodeId : wayData.getNodes()) {
            foundNodes.put(nodeId, marker);
        }
        for (Node node : dataSet.nodes) {
            if (foundNodes.get(node.getUniqueId()) != marker) continue;
            foundNodes.put(node.getUniqueId(), node);
        }
        ArrayList<Node> newNodes = new ArrayList<Node>(wayData.getNodes().size());
        for (Long nodeId : wayData.getNodes()) {
            Node node = (Node)foundNodes.get(nodeId);
            if (node != marker) {
                newNodes.add((Node)foundNodes.get(nodeId));
                continue;
            }
            throw new AssertionError((Object)"Data consistency problem - way with missing node detected");
        }
        this.setNodes(newNodes);
    }

    @Override
    public WayData save() {
        WayData data = new WayData();
        this.saveCommonAttributes(data);
        for (Node node : this.getNodes()) {
            data.getNodes().add(node.getUniqueId());
        }
        return data;
    }

    @Override
    public void cloneFrom(OsmPrimitive osm) {
        super.cloneFrom(osm);
        Way otherWay = (Way)osm;
        this.nodes = new Node[otherWay.nodes.length];
        System.arraycopy(otherWay.nodes, 0, this.nodes, 0, otherWay.nodes.length);
    }

    public String toString() {
        if (this.incomplete) {
            return "{Way id=" + this.getId() + " version=" + this.getVersion() + " (incomplete)}";
        }
        return "{Way id=" + this.getId() + " version=" + this.getVersion() + " nodes=" + Arrays.toString(this.nodes) + "}";
    }

    @Override
    public boolean hasEqualSemanticAttributes(OsmPrimitive other) {
        if (other == null || !(other instanceof Way)) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(other)) {
            return false;
        }
        Way w = (Way)other;
        return Arrays.equals(this.nodes, w.nodes);
    }

    @Override
    public int compareTo(OsmPrimitive o) {
        if (o instanceof Relation) {
            return 1;
        }
        return o instanceof Way ? Long.valueOf(this.getId()).compareTo(o.getId()) : -1;
    }

    public void removeNode(Node n) {
        int i;
        if (this.incomplete) {
            return;
        }
        boolean closed = this.lastNode() == n && this.firstNode() == n;
        List<Node> copy = this.getNodes();
        while ((i = copy.indexOf(n)) >= 0) {
            copy.remove(i);
        }
        i = copy.size();
        if (closed && i > 2) {
            this.addNode(this.firstNode());
        } else if (i >= 2 && i <= 3 && copy.get(0) == copy.get(i - 1)) {
            copy.remove(i - 1);
        }
        this.setNodes(copy);
    }

    public void removeNodes(Collection<? extends OsmPrimitive> selection) {
        if (this.incomplete) {
            return;
        }
        for (OsmPrimitive osmPrimitive : selection) {
            if (!(osmPrimitive instanceof Node)) continue;
            this.removeNode((Node)osmPrimitive);
        }
    }

    public void addNode(Node n) throws IllegalStateException {
        if (n == null) {
            return;
        }
        if (this.incomplete) {
            throw new IllegalStateException(I18n.tr("Cannot add node {0} to incomplete way {1}.", n.getId(), this.getId()));
        }
        this.clearCached();
        Node[] newNodes = new Node[this.nodes.length + 1];
        System.arraycopy(this.nodes, 0, newNodes, 0, this.nodes.length);
        newNodes[this.nodes.length] = n;
        this.nodes = newNodes;
    }

    public void addNode(int offs, Node n) throws IllegalStateException, IndexOutOfBoundsException {
        if (n == null) {
            return;
        }
        if (this.incomplete) {
            throw new IllegalStateException(I18n.tr("Cannot add node {0} to incomplete way {1}.", n.getId(), this.getId()));
        }
        this.clearCached();
        Node[] newNodes = new Node[this.nodes.length + 1];
        System.arraycopy(this.nodes, 0, newNodes, 0, offs);
        System.arraycopy(this.nodes, offs, newNodes, offs + 1, this.nodes.length - offs);
        newNodes[offs] = n;
        this.nodes = newNodes;
    }

    public boolean isClosed() {
        if (this.incomplete) {
            return false;
        }
        return this.nodes.length >= 3 && this.lastNode() == this.firstNode();
    }

    public Node lastNode() {
        if (this.incomplete || this.nodes.length == 0) {
            return null;
        }
        return this.nodes[this.nodes.length - 1];
    }

    public Node firstNode() {
        if (this.incomplete || this.nodes.length == 0) {
            return null;
        }
        return this.nodes[0];
    }

    public boolean isFirstLastNode(Node n) {
        if (this.incomplete || this.nodes.length == 0) {
            return false;
        }
        return n == this.firstNode() || n == this.lastNode();
    }

    @Override
    public String getDisplayName(NameFormatter formatter) {
        return formatter.format(this);
    }
}

