/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TigerUtils {
    public static boolean isTigerTag(String tag) {
        return tag.indexOf("tiger:") != -1;
    }

    public static boolean tagIsInt(String name) {
        return name.equals("tiger:tlid");
    }

    public static Object tagObj(String name) {
        if (TigerUtils.tagIsInt(name)) {
            return new Integer(name);
        }
        return name;
    }

    public static String combineTags(String name, Set<String> values) {
        TreeSet<Object> resultSet = new TreeSet<Object>();
        for (String value : values) {
            for (String part : value.split(":")) {
                resultSet.add(TigerUtils.tagObj(part));
            }
        }
        String combined = "";
        for (Object e : resultSet) {
            if (combined.length() > 0) {
                combined = combined + ":";
            }
            combined = combined + e;
        }
        return combined;
    }

    public static String combineTags(String name, String t1, String t2) {
        TreeSet<String> set = new TreeSet<String>();
        set.add(t1);
        set.add(t2);
        return TigerUtils.combineTags(name, set);
    }
}

