/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrimitiveData
implements Tagged {
    private final Map<String, String> keys = new HashMap<String, String>();
    private boolean modified;
    private boolean visible;
    private boolean deleted;
    private long id;
    private User user;
    private int version;
    private int timestamp;

    public PrimitiveData() {
        this.id = OsmPrimitive.generateUniqueId();
    }

    public PrimitiveData(PrimitiveData data) {
        this.keys.putAll(data.keys);
        this.modified = data.modified;
        this.visible = data.visible;
        this.deleted = data.deleted;
        this.id = data.id;
        this.user = data.user;
        this.version = data.version;
        this.timestamp = data.timestamp;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public Map<String, String> getKeys() {
        return this.keys;
    }

    public void clearOsmId() {
        this.id = OsmPrimitive.generateUniqueId();
    }

    public abstract PrimitiveData makeCopy();

    public abstract OsmPrimitive makePrimitive(DataSet var1);

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id).append(this.keys);
        if (this.modified) {
            builder.append("M");
        }
        if (this.visible) {
            builder.append("V");
        }
        if (this.deleted) {
            builder.append("D");
        }
        return builder.toString();
    }

    @Override
    public String get(String key) {
        return this.keys.get(key);
    }

    @Override
    public boolean hasKeys() {
        return !this.keys.isEmpty();
    }

    @Override
    public Collection<String> keySet() {
        return this.keys.keySet();
    }

    @Override
    public void put(String key, String value) {
        this.keys.put(key, value);
    }

    @Override
    public void remove(String key) {
        this.keys.remove(key);
    }

    @Override
    public void removeAll() {
        this.keys.clear();
    }

    @Override
    public void setKeys(Map<String, String> keys) {
        this.keys.clear();
        this.keys.putAll(keys);
    }

    public static <T extends PrimitiveData> List<T> getFilteredList(Collection<T> list, OsmPrimitiveType type) {
        ArrayList<PrimitiveData> ret = new ArrayList<PrimitiveData>();
        for (PrimitiveData p : list) {
            if (!type.getDataClass().isInstance(p)) continue;
            ret.add(p);
        }
        return ret;
    }

    protected void setKeysAsList(String ... keys) {
        assert (keys.length % 2 == 0);
        for (int i = 0; i < keys.length / 2; ++i) {
            this.keys.put(keys[i * 2], keys[i * 2 + 1]);
        }
    }
}

