/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OsmPrimitiveType {
    NODE("node", Node.class, NodeData.class),
    WAY("way", Way.class, WayData.class),
    RELATION("relation", Relation.class, RelationData.class);

    private final String apiTypeName;
    private final Class<? extends OsmPrimitive> osmClass;
    private final Class<? extends PrimitiveData> dataClass;

    private OsmPrimitiveType(String apiTypeName, Class<? extends OsmPrimitive> osmClass, Class<? extends PrimitiveData> dataClass) {
        this.apiTypeName = apiTypeName;
        this.osmClass = osmClass;
        this.dataClass = dataClass;
    }

    public String getAPIName() {
        return this.apiTypeName;
    }

    public Class<? extends OsmPrimitive> getOsmClass() {
        return this.osmClass;
    }

    public Class<? extends PrimitiveData> getDataClass() {
        return this.dataClass;
    }

    public static OsmPrimitiveType fromApiTypeName(String typeName) {
        for (OsmPrimitiveType type : OsmPrimitiveType.values()) {
            if (!type.getAPIName().equals(typeName)) continue;
            return type;
        }
        throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' is not a valid type name. Got ''{1}''.", "typeName", typeName));
    }

    public static OsmPrimitiveType from(OsmPrimitive obj) {
        return OsmPrimitiveType.from(obj.getClass());
    }

    public static OsmPrimitiveType from(Class<? extends OsmPrimitive> cls) {
        if (cls.equals(Node.class)) {
            return NODE;
        }
        if (cls.equals(Way.class)) {
            return WAY;
        }
        if (cls.equals(Relation.class)) {
            return RELATION;
        }
        throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' is not an acceptable class. Got ''{1}''.", "cls", cls.toString()));
    }

    public static OsmPrimitiveType fromData(Class<? extends PrimitiveData> cls) {
        if (cls.equals(NodeData.class)) {
            return NODE;
        }
        if (cls.equals(WayData.class)) {
            return WAY;
        }
        if (cls.equals(RelationData.class)) {
            return RELATION;
        }
        throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' is not an acceptable class. Got ''{1}''.", "cls", cls.toString()));
    }

    public static OsmPrimitiveType fromData(PrimitiveData data) {
        return OsmPrimitiveType.fromData(data.getClass());
    }

    public static OsmPrimitiveType from(String value) {
        if (value == null) {
            return null;
        }
        for (OsmPrimitiveType type : OsmPrimitiveType.values()) {
            if (!type.getAPIName().equalsIgnoreCase(value)) continue;
            return type;
        }
        return null;
    }
}

