/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSet
implements Cloneable {
    public String version;
    public QuadBuckets<Node> nodes = new QuadBuckets();
    public QuadBuckets<Way> ways = new QuadBuckets();
    public Collection<Relation> relations = new LinkedList<Relation>();
    public Collection<DataSource> dataSources = new LinkedList<DataSource>();
    public static Collection<SelectionChangedListener> selListeners = new LinkedList<SelectionChangedListener>();
    LinkedHashSet<OsmPrimitive> selectedPrimitives = new LinkedHashSet();

    public List<OsmPrimitive> allPrimitives() {
        LinkedList<OsmPrimitive> o = new LinkedList<OsmPrimitive>();
        o.addAll(this.nodes);
        o.addAll(this.ways);
        o.addAll(this.relations);
        return o;
    }

    public Collection<OsmPrimitive> allNonDeletedPrimitives() {
        LinkedList<OsmPrimitive> o = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osm : this.allPrimitives()) {
            if (!osm.isVisible() || osm.isDeleted()) continue;
            o.add(osm);
        }
        return o;
    }

    public Collection<OsmPrimitive> allNonDeletedCompletePrimitives() {
        LinkedList<OsmPrimitive> o = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osm : this.allPrimitives()) {
            if (!osm.isVisible() || osm.isDeleted() || osm.incomplete) continue;
            o.add(osm);
        }
        return o;
    }

    public Collection<OsmPrimitive> allNonDeletedPhysicalPrimitives() {
        LinkedList<OsmPrimitive> o = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osm : this.allPrimitives()) {
            if (!osm.isVisible() || osm.isDeleted() || osm.incomplete || osm instanceof Relation) continue;
            o.add(osm);
        }
        return o;
    }

    public void addPrimitive(OsmPrimitive primitive) {
        if (primitive instanceof Node) {
            this.nodes.add((Node)primitive);
        } else if (primitive instanceof Way) {
            this.ways.add((Way)primitive);
        } else if (primitive instanceof Relation) {
            this.relations.add((Relation)primitive);
        }
    }

    public OsmPrimitive addPrimitive(PrimitiveData data) {
        if (data instanceof NodeData) {
            Node node = new Node((NodeData)data, this);
            this.nodes.add(node);
            return node;
        }
        if (data instanceof WayData) {
            Way way = new Way((WayData)data, this);
            this.ways.add(way);
            return way;
        }
        if (data instanceof RelationData) {
            Relation relation = new Relation((RelationData)data, this);
            this.relations.add(relation);
            return relation;
        }
        throw new AssertionError();
    }

    public void removePrimitive(OsmPrimitive primitive) {
        if (primitive == null) {
            return;
        }
        if (primitive instanceof Node) {
            this.nodes.remove(primitive);
        } else if (primitive instanceof Way) {
            this.ways.remove(primitive);
        } else if (primitive instanceof Relation) {
            this.relations.remove(primitive);
        }
        this.selectedPrimitives.remove(primitive);
    }

    public void removePrimitive(long id, OsmPrimitiveType type) {
        this.removePrimitive(this.getPrimitiveById(id, type));
    }

    public Collection<OsmPrimitive> getSelectedNodesAndWays() {
        LinkedList<OsmPrimitive> sel = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osm : this.selectedPrimitives) {
            if (!(osm instanceof Way) && !(osm instanceof Node)) continue;
            sel.add(osm);
        }
        return sel;
    }

    public Collection<OsmPrimitive> getSelected() {
        return new ArrayList<OsmPrimitive>(this.selectedPrimitives);
    }

    public Collection<OsmPrimitive> getSelectedNodes() {
        return this.getSelected(this.nodes);
    }

    public Collection<OsmPrimitive> getSelectedWays() {
        return this.getSelected(this.ways);
    }

    public Collection<OsmPrimitive> getSelectedRelations() {
        return this.getSelected(this.relations);
    }

    public void setFiltered(Collection<? extends OsmPrimitive> selection) {
        this.clearFiltered(this.nodes);
        this.clearFiltered(this.ways);
        this.clearFiltered(this.relations);
        for (OsmPrimitive osmPrimitive : selection) {
            osmPrimitive.setFiltered(true);
        }
    }

    public void setFiltered(OsmPrimitive ... osm) {
        if (osm.length == 1 && osm[0] == null) {
            this.setFiltered(new OsmPrimitive[0]);
            return;
        }
        this.clearFiltered(this.nodes);
        this.clearFiltered(this.ways);
        this.clearFiltered(this.relations);
        for (OsmPrimitive o : osm) {
            if (o == null) continue;
            o.setFiltered(true);
        }
    }

    public void setDisabled(Collection<? extends OsmPrimitive> selection) {
        this.clearDisabled(this.nodes);
        this.clearDisabled(this.ways);
        this.clearDisabled(this.relations);
        for (OsmPrimitive osmPrimitive : selection) {
            osmPrimitive.setDisabled(true);
        }
    }

    public boolean toggleSelected(OsmPrimitive osm) {
        if (!this.selectedPrimitives.remove(osm)) {
            this.selectedPrimitives.add(osm);
        }
        return true;
    }

    public boolean isSelected(OsmPrimitive osm) {
        return this.selectedPrimitives.contains(osm);
    }

    public void setDisabled(OsmPrimitive ... osm) {
        if (osm.length == 1 && osm[0] == null) {
            this.setDisabled(new OsmPrimitive[0]);
            return;
        }
        this.clearDisabled(this.nodes);
        this.clearDisabled(this.ways);
        this.clearDisabled(this.relations);
        for (OsmPrimitive o : osm) {
            if (o == null) continue;
            o.setDisabled(true);
        }
    }

    public void setSelected(Collection<? extends OsmPrimitive> selection, boolean fireSelectionChangeEvent) {
        this.selectedPrimitives = new LinkedHashSet<OsmPrimitive>(selection);
        if (fireSelectionChangeEvent) {
            DataSet.fireSelectionChanged(selection);
        }
    }

    public void setSelected(Collection<? extends OsmPrimitive> selection) {
        this.setSelected(selection, true);
    }

    public void addSelected(Collection<? extends OsmPrimitive> selection) {
        this.addSelected(selection, true);
    }

    public void addSelected(OsmPrimitive ... osm) {
        this.addSelected(Arrays.asList(osm));
    }

    public void addSelected(Collection<? extends OsmPrimitive> selection, boolean fireSelectionChangeEvent) {
        this.selectedPrimitives.addAll(selection);
        if (fireSelectionChangeEvent) {
            DataSet.fireSelectionChanged(selection);
        }
    }

    public void setSelected(OsmPrimitive ... osm) {
        if (osm.length == 1 && osm[0] == null) {
            this.setSelected(new OsmPrimitive[0]);
            return;
        }
        List<OsmPrimitive> list = Arrays.asList(osm);
        this.setSelected(list);
        DataSet.fireSelectionChanged(list);
    }

    private void clearFiltered(Collection<? extends OsmPrimitive> list) {
        if (list == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : list) {
            osmPrimitive.setFiltered(false);
        }
    }

    private void clearDisabled(Collection<? extends OsmPrimitive> list) {
        if (list == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : list) {
            osmPrimitive.setDisabled(false);
        }
    }

    public void clearSelection(OsmPrimitive ... osm) {
        this.clearSelection(Arrays.asList(osm));
    }

    private void clearSelection(Collection<? extends OsmPrimitive> list) {
        if (list == null) {
            return;
        }
        this.selectedPrimitives.removeAll(list);
    }

    private Collection<OsmPrimitive> getSelected(Collection<? extends OsmPrimitive> list) {
        if (list == null) {
            return new LinkedList<OsmPrimitive>();
        }
        LinkedHashSet<OsmPrimitive> sel = new LinkedHashSet<OsmPrimitive>(this.selectedPrimitives);
        sel.retainAll(list);
        return sel;
    }

    public static void fireSelectionChanged(Collection<? extends OsmPrimitive> sel) {
        for (SelectionChangedListener l : selListeners) {
            l.selectionChanged(sel);
        }
    }

    public DataSet clone() {
        DataSet ds = new DataSet();
        for (Node n : this.nodes) {
            ds.nodes.add(new Node(n));
        }
        for (Way w : this.ways) {
            ds.ways.add(new Way(w));
        }
        for (Relation e : this.relations) {
            ds.relations.add(new Relation(e));
        }
        for (DataSource source : this.dataSources) {
            ds.dataSources.add(new DataSource(source.bounds, source.origin));
        }
        ds.version = this.version;
        return ds;
    }

    public Area getDataSourceArea() {
        if (this.dataSources.isEmpty()) {
            return null;
        }
        Area a = new Area();
        for (DataSource source : this.dataSources) {
            a.add(new Area(source.bounds.asRect()));
        }
        return a;
    }

    public static OsmPrimitive[] sort(Collection<? extends OsmPrimitive> list) {
        OsmPrimitive[] selArr = new OsmPrimitive[list.size()];
        final HashMap h = new HashMap();
        selArr = list.toArray(selArr);
        Arrays.sort(selArr, new Comparator<OsmPrimitive>(){

            @Override
            public int compare(OsmPrimitive a, OsmPrimitive b) {
                if (a.getClass() == b.getClass()) {
                    int res;
                    String bs;
                    String as = (String)h.get(a);
                    if (as == null) {
                        as = a.getName() != null ? a.getName() : Long.toString(a.getId());
                        h.put(a, as);
                    }
                    if ((bs = (String)h.get(b)) == null) {
                        bs = b.getName() != null ? b.getName() : Long.toString(b.getId());
                        h.put(b, bs);
                    }
                    if ((res = as.compareTo(bs)) != 0) {
                        return res;
                    }
                }
                return a.compareTo(b);
            }
        });
        return selArr;
    }

    public OsmPrimitive getPrimitiveById(long id, OsmPrimitiveType type) {
        return this.getPrimitiveById(id, type, false);
    }

    public OsmPrimitive getPrimitiveById(long id, OsmPrimitiveType type, boolean createNew) {
        Collection<OsmPrimitive> primitives = null;
        switch (type) {
            case NODE: {
                primitives = this.nodes;
                break;
            }
            case WAY: {
                primitives = this.ways;
                break;
            }
            case RELATION: {
                primitives = this.relations;
            }
        }
        for (OsmPrimitive osmPrimitive : primitives) {
            if (osmPrimitive.getUniqueId() != id) continue;
            return osmPrimitive;
        }
        if (createNew) {
            OsmPrimitive result = null;
            switch (type) {
                case NODE: {
                    result = new Node(id, true);
                    break;
                }
                case WAY: {
                    result = new Way(id, true);
                    break;
                }
                case RELATION: {
                    result = new Relation(id, true);
                }
            }
            this.addPrimitive(result);
            return result;
        }
        return null;
    }

    public Set<Long> getPrimitiveIds() {
        HashSet<Long> ret = new HashSet<Long>();
        for (OsmPrimitive osmPrimitive : this.nodes) {
            ret.add(osmPrimitive.getId());
        }
        for (OsmPrimitive osmPrimitive : this.ways) {
            ret.add(osmPrimitive.getId());
        }
        for (OsmPrimitive osmPrimitive : this.relations) {
            ret.add(osmPrimitive.getId());
        }
        return ret;
    }

    protected void deleteWay(Way way) {
        way.setNodes(null);
        way.setDeleted(true);
    }

    public void unlinkNodeFromWays(Node node) {
        for (Way way : this.ways) {
            List<Node> nodes = way.getNodes();
            if (!nodes.remove(node)) continue;
            if (nodes.size() < 2) {
                this.deleteWay(way);
                continue;
            }
            way.setNodes(nodes);
        }
    }

    public void unlinkPrimitiveFromRelations(OsmPrimitive primitive) {
        for (Relation relation : this.relations) {
            Iterator<RelationMember> it = relation.getMembers().iterator();
            while (it.hasNext()) {
                RelationMember member = it.next();
                if (!member.getMember().equals(primitive)) continue;
                it.remove();
            }
        }
    }

    public void unlinkReferencesToPrimitive(OsmPrimitive referencedPrimitive) {
        if (referencedPrimitive instanceof Node) {
            this.unlinkNodeFromWays((Node)referencedPrimitive);
            this.unlinkPrimitiveFromRelations(referencedPrimitive);
        } else {
            this.unlinkPrimitiveFromRelations(referencedPrimitive);
        }
    }

    public List<Relation> getParentRelations(Relation child) {
        ArrayList<Relation> parents = new ArrayList<Relation>();
        if (child == null) {
            return parents;
        }
        block0: for (Relation parent : this.relations) {
            if (parent == child) continue;
            for (RelationMember member : parent.getMembers()) {
                if (!member.refersTo(child)) continue;
                parents.add(parent);
                continue block0;
            }
        }
        return parents;
    }

    public boolean isModified() {
        for (Node n : this.nodes) {
            if (!n.isModified()) continue;
            return true;
        }
        for (Way w : this.ways) {
            if (!w.isModified()) continue;
            return true;
        }
        for (Relation r : this.relations) {
            if (!r.isModified()) continue;
            return true;
        }
        return false;
    }

    public Set<Relation> getReferringRelations(Collection<? extends OsmPrimitive> primitives) {
        HashSet<Relation> ret = new HashSet<Relation>();
        if (primitives == null) {
            return ret;
        }
        HashSet<? extends OsmPrimitive> referred = primitives instanceof Set ? (HashSet<? extends OsmPrimitive>)primitives : new HashSet<OsmPrimitive>(primitives);
        referred.remove(null);
        for (Relation r : this.relations) {
            if (r.isDeleted() || r.incomplete) continue;
            Set<OsmPrimitive> memberPrimitives = r.getMemberPrimitives();
            memberPrimitives.retainAll(referred);
            if (memberPrimitives.isEmpty()) continue;
            ret.add(r);
        }
        return ret;
    }
}

