/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackreferencedDataSet {
    private DataSet source;
    private Map<OsmPrimitive, Set<OsmPrimitive>> referers;
    private boolean built = false;

    public BackreferencedDataSet(DataSet source) {
        if (source == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null."));
        }
        this.source = source;
        int size = source.ways.size() + source.relations.size();
        this.referers = new HashMap<OsmPrimitive, Set<OsmPrimitive>>(size, 0.75f);
    }

    protected void remember(OsmPrimitive parent, OsmPrimitive child) {
        Set<OsmPrimitive> parents = this.referers.get(child);
        if (parents != null) {
            parents.add(parent);
            return;
        }
        parents = new HashSet<OsmPrimitive>();
        parents.add(parent);
        this.referers.put(child, parents);
    }

    public void build() {
        for (Way w : this.source.ways) {
            for (Node n : w.getNodes()) {
                this.remember(w, n);
            }
        }
        for (Relation r : this.source.relations) {
            for (RelationMember m : r.getMembers()) {
                this.remember(r, m.getMember());
            }
        }
        this.built = true;
    }

    public Set<OsmPrimitive> getParents(OsmPrimitive child) {
        HashSet parents = this.referers.get(child);
        return parents == null ? new HashSet() : parents;
    }

    public Set<OsmPrimitive> getParents(Collection<? extends OsmPrimitive> children) {
        if (children == null) {
            return Collections.emptySet();
        }
        children.remove(null);
        HashSet<OsmPrimitive> parents = new HashSet<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : children) {
            if (this.referers.get(osmPrimitive) == null) continue;
            parents.addAll((Collection<OsmPrimitive>)this.referers.get(osmPrimitive));
        }
        return parents;
    }

    public boolean hasParents(OsmPrimitive child) {
        return !this.getParents(child).isEmpty();
    }

    public DataSet getSource() {
        return this.source;
    }

    public Set<RelationToChildReference> getRelationToChildReferences(OsmPrimitive child) {
        Set<Relation> parents = OsmPrimitive.getFilteredSet(this.getParents(child), Relation.class);
        HashSet<RelationToChildReference> references = new HashSet<RelationToChildReference>();
        for (Relation parent : parents) {
            for (int i = 0; i < parent.getMembersCount(); ++i) {
                if (!parent.getMember(i).refersTo(child)) continue;
                references.add(new RelationToChildReference(parent, i, parent.getMember(i)));
            }
        }
        return references;
    }

    public Set<RelationToChildReference> getRelationToChildReferences(Collection<? extends OsmPrimitive> children) {
        HashSet<RelationToChildReference> references = new HashSet<RelationToChildReference>();
        for (OsmPrimitive osmPrimitive : children) {
            references.addAll(this.getRelationToChildReferences(osmPrimitive));
        }
        return references;
    }

    public boolean isBuilt() {
        return this.built;
    }

    public static class RelationToChildReference {
        private Relation parent;
        private int position;
        private String role;
        private OsmPrimitive child;

        public RelationToChildReference(Relation parent, int position, String role, OsmPrimitive child) {
            this.parent = parent;
            this.position = position;
            this.role = role;
            this.child = child;
        }

        public RelationToChildReference(Relation parent, int position, RelationMember member) {
            this.parent = parent;
            this.position = position;
            this.role = member.getRole();
            this.child = member.getMember();
        }

        public Relation getParent() {
            return this.parent;
        }

        public int getPosition() {
            return this.position;
        }

        public String getRole() {
            return this.role;
        }

        public OsmPrimitive getChild() {
            return this.child;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.child == null ? 0 : this.child.hashCode());
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            result = 31 * result + this.position;
            result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RelationToChildReference other = (RelationToChildReference)obj;
            if (this.child == null ? other.child != null : !this.child.equals(other.child)) {
                return false;
            }
            if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
                return false;
            }
            if (this.position != other.position) {
                return false;
            }
            return !(this.role == null ? other.role != null : !this.role.equals(other.role));
        }
    }
}

