/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import org.openstreetmap.josm.data.coor.LatLon;

public class QuadTiling {
    public static int NR_LEVELS = 24;
    public static double WORLD_PARTS = 1 << NR_LEVELS;
    public static int MAX_OBJECTS_PER_LEVEL = 16;
    public static int TILES_PER_LEVEL_SHIFT = 2;
    public static int TILES_PER_LEVEL = 1 << TILES_PER_LEVEL_SHIFT;
    public static int X_PARTS = 360;
    public static int X_BIAS = -180;
    public static int Y_PARTS = 180;
    public static int Y_BIAS = -90;

    public static LatLon tile2LatLon(long quad) {
        double x_unit = X_PARTS / 2;
        double y_unit = Y_PARTS / 2;
        long shift = NR_LEVELS * 2 - 2;
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < NR_LEVELS; ++i) {
            long bits = quad >> (int)shift & 3L;
            if ((bits & 2L) != 0L) {
                x += x_unit;
            }
            if ((bits & 1L) != 0L) {
                y += y_unit;
            }
            x_unit /= 2.0;
            y_unit /= 2.0;
            shift -= 2L;
        }
        return new LatLon(y += (double)Y_BIAS, x += (double)X_BIAS);
    }

    static long xy2tile(long x, long y) {
        long tile = 0L;
        for (int i = NR_LEVELS - 1; i >= 0; --i) {
            long xbit = x >> i & 1L;
            long ybit = y >> i & 1L;
            tile <<= 2;
            tile |= xbit << 1 | ybit;
        }
        return tile;
    }

    static long coorToTile(LatLon coor) {
        return QuadTiling.quadTile(coor);
    }

    static long lon2x(double lon) {
        long ret = (long)Math.floor((lon + 180.0) * WORLD_PARTS / 360.0);
        if ((double)ret == WORLD_PARTS) {
            --ret;
        }
        return ret;
    }

    static long lat2y(double lat) {
        long ret = (long)Math.floor((lat + 90.0) * WORLD_PARTS / 180.0);
        if ((double)ret == WORLD_PARTS) {
            --ret;
        }
        return ret;
    }

    public static long quadTile(LatLon coor) {
        return QuadTiling.xy2tile(QuadTiling.lon2x(coor.lon()), QuadTiling.lat2y(coor.lat()));
    }

    public static int index(int level, long quad) {
        long mask = 3L;
        int total_shift = TILES_PER_LEVEL_SHIFT * (NR_LEVELS - level - 1);
        return (int)(mask & quad >> total_shift);
    }

    public static int index(LatLon coor, int level) {
        if (coor == null) {
            return 0;
        }
        long quad = QuadTiling.coorToTile(coor);
        return QuadTiling.index(level, quad);
    }
}

