/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.Coordinate;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.tools.I18n;

public class LatLon
extends Coordinate {
    private static DecimalFormat cDmsMinuteFormatter = new DecimalFormat("00");
    private static DecimalFormat cDmsSecondFormatter = new DecimalFormat("00.0");
    private static DecimalFormat cDdFormatter = new DecimalFormat("###0.0000");

    public static String dms(double pCoordinate) {
        double tAbsCoord = Math.abs(pCoordinate);
        int tDegree = (int)tAbsCoord;
        double tTmpMinutes = (tAbsCoord - (double)tDegree) * 60.0;
        int tMinutes = (int)tTmpMinutes;
        double tSeconds = (tTmpMinutes - (double)tMinutes) * 60.0;
        return tDegree + "\u00b0" + cDmsMinuteFormatter.format(tMinutes) + "'" + cDmsSecondFormatter.format(tSeconds) + "\"";
    }

    public LatLon(double lat, double lon) {
        super(lon, lat);
    }

    public LatLon(LatLon coor) {
        super(coor.lon(), coor.lat());
    }

    public double lat() {
        return this.y;
    }

    public String latToString(CoordinateFormat d) {
        switch (d) {
            case DECIMAL_DEGREES: {
                return cDdFormatter.format(this.y);
            }
            case DEGREES_MINUTES_SECONDS: {
                return LatLon.dms(this.y) + (this.y < 0.0 ? I18n.tr("S") : I18n.tr("N"));
            }
        }
        return "ERR";
    }

    public double lon() {
        return this.x;
    }

    public String lonToString(CoordinateFormat d) {
        switch (d) {
            case DECIMAL_DEGREES: {
                return cDdFormatter.format(this.x);
            }
            case DEGREES_MINUTES_SECONDS: {
                return LatLon.dms(this.x) + (this.x < 0.0 ? I18n.tr("W") : I18n.tr("E"));
            }
        }
        return "ERR";
    }

    public boolean equalsEpsilon(LatLon other) {
        double p = 1.0E-12;
        return Math.abs(this.lat() - other.lat()) <= 1.0E-12 && Math.abs(this.lon() - other.lon()) <= 1.0E-12;
    }

    public boolean isOutSideWorld() {
        Bounds b = Main.proj.getWorldBoundsLatLon();
        return this.lat() < b.min.lat() || this.lat() > b.max.lat() || this.lon() < b.min.lon() || this.lon() > b.max.lon();
    }

    public boolean isWithin(Bounds b) {
        return this.lat() >= b.min.lat() && this.lat() <= b.max.lat() && this.lon() > b.min.lon() && this.lon() < b.max.lon();
    }

    public double greatCircleDistance(LatLon other) {
        return Math.acos(Math.sin(Math.toRadians(this.lat())) * Math.sin(Math.toRadians(other.lat())) + Math.cos(Math.toRadians(this.lat())) * Math.cos(Math.toRadians(other.lat())) * Math.cos(Math.toRadians(other.lon() - this.lon()))) * 6378135.0;
    }

    public double heading(LatLon other) {
        double rv;
        if (other.lat() == this.lat()) {
            rv = other.lon() > this.lon() ? 1.5707963267948966 : 4.71238898038469;
        } else {
            rv = Math.atan((other.lon() - this.lon()) / (other.lat() - this.lat()));
            if (rv < 0.0) {
                rv += Math.PI;
            }
            if (other.lon() < this.lon()) {
                rv += Math.PI;
            }
        }
        return rv;
    }

    public String toDisplayString() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(5);
        return "lat=" + nf.format(this.lat()) + "\u00b0, lon=" + nf.format(this.lon()) + "\u00b0";
    }

    public LatLon interpolate(LatLon ll2, double proportion) {
        return new LatLon(this.lat() + proportion * (ll2.lat() - this.lat()), this.lon() + proportion * (ll2.lon() - this.lon()));
    }

    public LatLon getCenter(LatLon ll2) {
        return new LatLon((this.lat() + ll2.lat()) / 2.0, (this.lon() + ll2.lon()) / 2.0);
    }

    public String toString() {
        return "LatLon[lat=" + this.lat() + ",lon=" + this.lon() + "]";
    }
}

