/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class UndoRedoHandler
implements Layer.LayerChangeListener {
    public final LinkedList<Command> commands = new LinkedList();
    private final Stack<Command> redoCommands = new Stack();
    public final LinkedList<OsmDataLayer.CommandQueueListener> listenerCommands = new LinkedList();

    public UndoRedoHandler() {
        Layer.listeners.add(this);
    }

    public void addNoRedraw(Command c) {
        c.executeCommand();
        this.commands.add(c);
        this.redoCommands.clear();
    }

    public void afterAdd() {
        if (Main.map != null && Main.map.mapView.getActiveLayer() instanceof OsmDataLayer) {
            OsmDataLayer data = (OsmDataLayer)Main.map.mapView.getActiveLayer();
            data.fireDataChange();
        }
        this.fireCommandsChanged();
        DataSet.fireSelectionChanged(Main.main.getCurrentDataSet().getSelected());
    }

    public void add(Command c) {
        this.addNoRedraw(c);
        this.afterAdd();
    }

    public void undo() {
        if (this.commands.isEmpty()) {
            return;
        }
        Command c = this.commands.removeLast();
        c.undoCommand();
        this.redoCommands.push(c);
        if (Main.map != null && Main.map.mapView.getActiveLayer() instanceof OsmDataLayer) {
            OsmDataLayer data = (OsmDataLayer)Main.map.mapView.getActiveLayer();
            data.fireDataChange();
        }
        this.fireCommandsChanged();
        Main.main.getCurrentDataSet().setSelected(new OsmPrimitive[0]);
    }

    public void redo() {
        if (this.redoCommands.isEmpty()) {
            return;
        }
        Command c = this.redoCommands.pop();
        c.executeCommand();
        this.commands.add(c);
        if (Main.map != null && Main.map.mapView.getActiveLayer() instanceof OsmDataLayer) {
            OsmDataLayer data = (OsmDataLayer)Main.map.mapView.getActiveLayer();
            data.fireDataChange();
        }
        this.fireCommandsChanged();
    }

    public void fireCommandsChanged() {
        for (OsmDataLayer.CommandQueueListener l : this.listenerCommands) {
            l.commandChanged(this.commands.size(), this.redoCommands.size());
        }
    }

    public void clean() {
        this.redoCommands.clear();
        this.commands.clear();
        this.fireCommandsChanged();
    }

    public void clean(Layer layer) {
        if (layer == null) {
            return;
        }
        boolean changed = false;
        Iterator it = this.commands.iterator();
        while (it.hasNext()) {
            if (!((Command)it.next()).invalidBecauselayerRemoved(layer)) continue;
            it.remove();
            changed = true;
        }
        it = this.redoCommands.iterator();
        while (it.hasNext()) {
            if (!((Command)it.next()).invalidBecauselayerRemoved(layer)) continue;
            it.remove();
            changed = true;
        }
        if (changed) {
            this.fireCommandsChanged();
        }
    }

    public void layerRemoved(Layer oldLayer) {
        this.clean(oldLayer);
    }

    public void layerAdded(Layer newLayer) {
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }
}

