/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeItem;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagConflictResolveCommand
extends ConflictResolveCommand {
    private static final Logger logger = Logger.getLogger(TagConflictResolveCommand.class.getName());
    private Conflict<OsmPrimitive> conflict;
    private final List<TagMergeItem> mergeItems;

    public int getNumDecidedConflicts() {
        int n = 0;
        for (TagMergeItem item : this.mergeItems) {
            if (item.getMergeDecision().equals((Object)MergeDecisionType.UNDECIDED)) continue;
            ++n;
        }
        return n;
    }

    public TagConflictResolveCommand(OsmPrimitive my, OsmPrimitive their, List<TagMergeItem> mergeItems) {
        this.conflict = new Conflict<OsmPrimitive>(my, their);
        this.mergeItems = mergeItems;
    }

    @Override
    public MutableTreeNode description() {
        String msg = "";
        switch (OsmPrimitiveType.from(this.conflict.getMy())) {
            case NODE: {
                msg = I18n.marktr("Resolve {0} tag conflicts in node {1}");
                break;
            }
            case WAY: {
                msg = I18n.marktr("Resolve {0} tag conflicts in way {1}");
                break;
            }
            case RELATION: {
                msg = I18n.marktr("Resolve {0} tag conflicts in relation {1}");
            }
        }
        return new DefaultMutableTreeNode(new JLabel(I18n.tr(msg, this.getNumDecidedConflicts(), this.conflict.getMy().getId()), ImageProvider.get("data", "object"), 0));
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        for (TagMergeItem item : this.mergeItems) {
            if (item.getMergeDecision().equals((Object)MergeDecisionType.UNDECIDED)) continue;
            item.applyToMyPrimitive(this.conflict.getMy());
        }
        this.rememberConflict(this.conflict);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add(this.conflict.getMy());
    }
}

