/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveCommand
extends Command {
    private Collection<Node> nodes = new LinkedList<Node>();
    private double x;
    private double y;
    private List<OldState> oldState = new LinkedList<OldState>();

    public MoveCommand(OsmPrimitive osm, double x, double y) {
        this(Collections.singleton(osm), x, y);
    }

    public MoveCommand(Collection<OsmPrimitive> objects, double x, double y) {
        this.x = x;
        this.y = y;
        this.nodes = AllNodesVisitor.getAllNodes(objects);
        for (Node n : this.nodes) {
            OldState os = new OldState();
            os.latlon = new LatLon(n.getCoor());
            os.modified = n.isModified();
            this.oldState.add(os);
        }
    }

    public void moveAgain(double x, double y) {
        for (Node n : this.nodes) {
            n.setEastNorth(n.getEastNorth().add(x, y));
        }
        this.x += x;
        this.y += y;
    }

    @Override
    public boolean executeCommand() {
        for (Node n : this.nodes) {
            n.setEastNorth(n.getEastNorth().add(this.x, this.y));
            n.setModified(true);
        }
        return true;
    }

    @Override
    public void undoCommand() {
        Iterator<OldState> it = this.oldState.iterator();
        for (Node n : this.nodes) {
            OldState os = it.next();
            n.setCoor(os.latlon);
            n.setModified(os.modified);
        }
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        for (OsmPrimitive osmPrimitive : this.nodes) {
            modified.add(osmPrimitive);
        }
    }

    @Override
    public MutableTreeNode description() {
        return new DefaultMutableTreeNode(new JLabel(I18n.trn("Move {0} node", "Move {0} nodes", this.nodes.size(), this.nodes.size()), ImageProvider.get("data", "node"), 0));
    }

    public Collection<Node> getMovedNodes() {
        return this.nodes;
    }

    public static class OldState {
        LatLon latlon;
        boolean modified;
    }
}

