/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Command {
    private Map<OsmPrimitive, PrimitiveData> cloneMap = new HashMap<OsmPrimitive, PrimitiveData>();
    private OsmDataLayer layer;

    public Command() {
        this.layer = Main.map.mapView.getEditLayer();
    }

    public Command(OsmDataLayer layer) throws IllegalArgumentException {
        if (layer == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null", "layer"));
        }
        this.layer = layer;
    }

    public boolean executeCommand() {
        CloneVisitor visitor = new CloneVisitor();
        HashSet<OsmPrimitive> all = new HashSet<OsmPrimitive>();
        this.fillModifiedData(all, all, all);
        for (OsmPrimitive osm : all) {
            osm.visit(visitor);
        }
        this.cloneMap = visitor.orig;
        return true;
    }

    public void undoCommand() {
        for (Map.Entry<OsmPrimitive, PrimitiveData> e : this.cloneMap.entrySet()) {
            e.getKey().load(e.getValue(), this.layer.data);
        }
    }

    public boolean invalidBecauselayerRemoved(Layer oldLayer) {
        if (!(oldLayer instanceof OsmDataLayer)) {
            return false;
        }
        return this.layer == oldLayer;
    }

    public PrimitiveData getOrig(OsmPrimitive osm) {
        PrimitiveData o = this.cloneMap.get(osm);
        if (o != null) {
            return o;
        }
        Main.debug("unable to find osm with id: " + osm.getId() + " hashCode: " + osm.hashCode());
        for (OsmPrimitive t : this.cloneMap.keySet()) {
            PrimitiveData to = this.cloneMap.get(t);
            Main.debug("now: " + t.getId() + " hashCode: " + t.hashCode());
            Main.debug("orig: " + to.getId() + " hashCode: " + to.hashCode());
        }
        return o;
    }

    protected OsmDataLayer getLayer() {
        return this.layer;
    }

    public abstract void fillModifiedData(Collection<OsmPrimitive> var1, Collection<OsmPrimitive> var2, Collection<OsmPrimitive> var3);

    public abstract MutableTreeNode description();

    private static final class CloneVisitor
    extends AbstractVisitor {
        public Map<OsmPrimitive, PrimitiveData> orig = new HashMap<OsmPrimitive, PrimitiveData>();

        private CloneVisitor() {
        }

        public void visit(Node n) {
            this.orig.put(n, n.save());
        }

        public void visit(Way w) {
            this.orig.put(w, w.save());
        }

        public void visit(Relation e) {
            this.orig.put(e, e.save());
        }
    }
}

