/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.upload;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiPreconditionCheckerHook
implements UploadHook {
    @Override
    public boolean checkUpload(APIDataSet apiData) {
        OsmApi api = OsmApi.getOsmApi();
        try {
            api.initialize(NullProgressMonitor.INSTANCE);
            long maxNodes = 0L;
            if (api.getCapabilities().isDefined("waynodes", "maximum")) {
                maxNodes = api.getCapabilities().getLong("waynodes", "maximum");
            }
            long maxElements = 0L;
            if (api.getCapabilities().isDefined("changesets", "maximum_elements")) {
                maxElements = api.getCapabilities().getLong("changesets", "maximum_elements");
            }
            if (maxNodes > 0L) {
                if (!this.checkMaxNodes(apiData.getPrimitivesToAdd(), maxNodes)) {
                    return false;
                }
                if (!this.checkMaxNodes(apiData.getPrimitivesToUpdate(), maxNodes)) {
                    return false;
                }
                if (!this.checkMaxNodes(apiData.getPrimitivesToDelete(), maxNodes)) {
                    return false;
                }
            }
            if (maxElements > 0L) {
                int total = 0;
                total = apiData.getPrimitivesToAdd().size() + apiData.getPrimitivesToUpdate().size() + apiData.getPrimitivesToDelete().size();
                if ((long)total > maxElements) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Current number of changes exceeds the max. number of changes, current is {0}, max is {1}", total, maxElements), I18n.tr("API Capabilities Violation"), 0);
                    return false;
                }
            }
        }
        catch (OsmApiInitializationException e) {
            ExceptionDialogUtil.explainOsmTransferException(e);
            return false;
        }
        return true;
    }

    private boolean checkMaxNodes(Collection<OsmPrimitive> primitives, long maxNodes) {
        for (OsmPrimitive osmPrimitive : primitives) {
            for (Map.Entry<String, String> e : osmPrimitive.entrySet()) {
                if (e.getValue().length() <= 255) continue;
                if (osmPrimitive.isDeleted()) {
                    System.out.println(I18n.tr("Warning: automatically truncating value of tag ''{0}'' on deleted primitive {1}", e.getKey(), Long.toString(osmPrimitive.getId())));
                    osmPrimitive.put(e.getKey(), e.getValue().substring(0, 255));
                    continue;
                }
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Length of value for tag ''{0}'' on primitive {1} exceeds the max. allowed length {2}. Values length is {3}.", e.getKey(), Long.toString(osmPrimitive.getId()), 255, e.getValue().length()), I18n.tr("Precondition Violation"), 0);
                Main.main.getCurrentDataSet().setSelected(Collections.singleton(osmPrimitive));
                return false;
            }
            if (!(osmPrimitive instanceof Way) || (long)((Way)osmPrimitive).getNodesCount() <= maxNodes) continue;
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("{0} nodes in way {1} exceed the max. allowed number of nodes {2}", ((Way)osmPrimitive).getNodesCount(), Long.toString(osmPrimitive.getId()), maxNodes), I18n.tr("API Capabilities Violation"), 0);
            Main.main.getCurrentDataSet().setSelected(Collections.singleton(osmPrimitive));
            return false;
        }
        return true;
    }
}

