/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchAction
extends JosmAction {
    public static final int DEFAULT_SEARCH_HISTORY_SIZE = 10;
    public static final LinkedList<SearchSetting> searchHistory = new LinkedList();
    private static SearchSetting lastSearch = null;

    public SearchAction() {
        super(I18n.tr("Search..."), "dialogs/search", I18n.tr("Search for objects."), Shortcut.registerShortcut("system:find", I18n.tr("Search..."), 70, 1), true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SearchSetting se;
        if (!this.isEnabled()) {
            return;
        }
        if (Main.map == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Can't search because there is no loaded data."), I18n.tr("Warning"), 2);
            return;
        }
        SearchSetting s = lastSearch;
        if (s == null) {
            s = new SearchSetting("", SearchMode.replace, false, false);
        }
        if ((se = SearchAction.showSearchDialog(s)) != null) {
            SearchAction.searchWithHistory(se);
        }
    }

    public static SearchSetting showSearchDialog(SearchSetting initialValues) {
        JLabel label = new JLabel(initialValues instanceof Filter ? I18n.tr("Please enter a filter string.") : I18n.tr("Please enter a search string."));
        JTextField input = new JTextField(initialValues.text);
        input.selectAll();
        input.requestFocusInWindow();
        JRadioButton replace = new JRadioButton(I18n.tr("replace selection"), initialValues.mode == SearchMode.replace);
        JRadioButton add = new JRadioButton(I18n.tr("add to selection"), initialValues.mode == SearchMode.add);
        JRadioButton remove = new JRadioButton(I18n.tr("remove from selection"), initialValues.mode == SearchMode.remove);
        JRadioButton in_selection = new JRadioButton(I18n.tr("find in selection"), initialValues.mode == SearchMode.in_selection);
        ButtonGroup bg = new ButtonGroup();
        bg.add(replace);
        bg.add(add);
        bg.add(remove);
        bg.add(in_selection);
        JCheckBox caseSensitive = new JCheckBox(I18n.tr("case sensitive"), initialValues.caseSensitive);
        JCheckBox regexSearch = new JCheckBox(I18n.tr("regular expression"), initialValues.regexSearch);
        JPanel left = new JPanel(new GridBagLayout());
        left.add((Component)label, GBC.eop());
        left.add((Component)input, GBC.eop().fill(2));
        left.add((Component)replace, GBC.eol());
        DataSet ds = Main.main.getCurrentDataSet();
        left.add((Component)add, GBC.eol());
        left.add((Component)remove, GBC.eol());
        left.add((Component)in_selection, GBC.eop());
        left.add((Component)caseSensitive, GBC.eol());
        left.add((Component)regexSearch, GBC.eol());
        JPanel right = new JPanel();
        JLabel description = new JLabel("<html><ul><li>" + I18n.tr("<b>Baker Street</b> - 'Baker' and 'Street' in any key or name.") + "</li>" + "<li>" + I18n.tr("<b>\"Baker Street\"</b> - 'Baker Street' in any key or name.") + "</li>" + "<li>" + I18n.tr("<b>name:Bak</b> - 'Bak' anywhere in the name.") + "</li>" + "<li>" + I18n.tr("<b>type=route</b> - key 'type' with value exactly 'route'.") + "</li>" + "<li>" + I18n.tr("<b>type=*</b> - key 'type' with any value. Try also <b>*=value</b>, <b>type=</b>, <b>*=*</b>, <b>*=</b>") + "</li>" + "<li>" + I18n.tr("<b>-name:Bak</b> - not 'Bak' in the name.") + "</li>" + "<li>" + I18n.tr("<b>foot:</b> - key=foot set to any value.") + "</li>" + "<li>" + I18n.tr("<u>Special targets:</u>") + "</li>" + "<li>" + I18n.tr("<b>type:</b> - type of the object (<b>node</b>, <b>way</b>, <b>relation</b>)") + "</li>" + "<li>" + I18n.tr("<b>user:</b>... - all objects changed by user") + "</li>" + "<li>" + I18n.tr("<b>id:</b>... - object with given ID (0 for new objects)") + "</li>" + "<li>" + I18n.tr("<b>nodes:</b>... - object with given number of nodes") + "</li>" + "<li>" + I18n.tr("<b>modified</b> - all changed objects") + "</li>" + "<li>" + I18n.tr("<b>selected</b> - all selected objects") + "</li>" + "<li>" + I18n.tr("<b>incomplete</b> - all incomplete objects") + "</li>" + "<li>" + I18n.tr("<b>untagged</b> - all untagged objects") + "</li>" + "<li>" + I18n.tr("<b>child <i>expr</i></b> - all children of objects matching the expression") + "</li>" + "<li>" + I18n.tr("<b>parent <i>expr</i></b> - all parents of objects matching the expression") + "</li>" + "<li>" + I18n.tr("Use <b>|</b> or <b>OR</b> to combine with logical or") + "</li>" + "<li>" + I18n.tr("Use <b>\"</b> to quote operators (e.g. if key contains :)") + "</li>" + "<li>" + I18n.tr("Use <b>(</b> and <b>)</b> to group expressions") + "</li>" + "</ul></html>");
        description.setFont(description.getFont().deriveFont(0));
        right.add(description);
        JPanel p = new JPanel();
        p.add(left);
        p.add(right);
        ExtendedDialog dialog = new ExtendedDialog(Main.parent, initialValues instanceof Filter ? I18n.tr("Filter") : I18n.tr("Search"), new String[]{initialValues instanceof Filter ? I18n.tr("Submit filter") : I18n.tr("Start Search"), I18n.tr("Cancel")});
        dialog.setButtonIcons(new String[]{"dialogs/search.png", "cancel.png"});
        dialog.setContent(p);
        dialog.showDialog();
        int result = dialog.getValue();
        if (result != 1) {
            return null;
        }
        SearchMode mode = replace.isSelected() ? SearchMode.replace : (add.isSelected() ? SearchMode.add : (remove.isSelected() ? SearchMode.remove : SearchMode.in_selection));
        initialValues.text = input.getText();
        initialValues.mode = mode;
        initialValues.caseSensitive = caseSensitive.isSelected();
        initialValues.regexSearch = regexSearch.isSelected();
        return initialValues;
    }

    public static void searchWithHistory(SearchSetting s) {
        if (searchHistory.isEmpty() || !s.equals(searchHistory.getFirst())) {
            searchHistory.addFirst(new SearchSetting(s));
        }
        while (searchHistory.size() > Main.pref.getInteger("search.history-size", 10)) {
            searchHistory.removeLast();
        }
        lastSearch = new SearchSetting(s);
        SearchAction.search(s);
    }

    public static void searchWithoutHistory(SearchSetting s) {
        lastSearch = new SearchSetting(s);
        SearchAction.search(s);
    }

    public static Integer getSelection(SearchSetting s, Collection<OsmPrimitive> sel, Function f) {
        Integer foundMatches = 0;
        try {
            String searchText = s.text;
            if (s instanceof Filter) {
                searchText = "(" + s.text + ")" + (((Filter)s).applyForChildren != false ? "| child (" + s.text + ")" : "");
                searchText = (((Filter)s).inverted != false ? "-" : "") + "(" + searchText + ")";
            }
            SearchCompiler.Match matcher = SearchCompiler.compile(searchText, s.caseSensitive, s.regexSearch);
            foundMatches = 0;
            for (OsmPrimitive osm : Main.main.getCurrentDataSet().allNonDeletedCompletePrimitives()) {
                if (s.mode == SearchMode.replace) {
                    if (matcher.match(osm)) {
                        sel.add(osm);
                        foundMatches = foundMatches + 1;
                        continue;
                    }
                    sel.remove(osm);
                    continue;
                }
                if (s.mode == SearchMode.add && !f.isSomething(osm).booleanValue() && matcher.match(osm)) {
                    sel.add(osm);
                    foundMatches = foundMatches + 1;
                    continue;
                }
                if (s.mode == SearchMode.remove && f.isSomething(osm).booleanValue() && matcher.match(osm)) {
                    sel.remove(osm);
                    foundMatches = foundMatches + 1;
                    continue;
                }
                if (s.mode != SearchMode.in_selection || !f.isSomething(osm).booleanValue() || matcher.match(osm)) continue;
                sel.remove(osm);
                foundMatches = foundMatches + 1;
            }
        }
        catch (SearchCompiler.ParseError e) {
            JOptionPane.showMessageDialog(Main.parent, e.getMessage(), I18n.tr("Error"), 0);
        }
        return foundMatches;
    }

    public static void search(String search, SearchMode mode, boolean caseSensitive, boolean regexSearch) {
        SearchAction.search(new SearchSetting(search, mode, caseSensitive, regexSearch));
    }

    public static void search(SearchSetting s) {
        final DataSet ds = Main.main.getCurrentDataSet();
        Collection<OsmPrimitive> sel = ds.getSelected();
        int foundMatches = SearchAction.getSelection(s, sel, new Function(){

            public Boolean isSomething(OsmPrimitive o) {
                return ds.isSelected(o);
            }
        });
        ds.setSelected(sel);
        if (foundMatches == 0) {
            String msg = null;
            if (s.mode == SearchMode.replace) {
                msg = I18n.tr("No match found for ''{0}''", s.text);
            } else if (s.mode == SearchMode.add) {
                msg = I18n.tr("Nothing added to selection by searching for ''{0}''", s.text);
            } else if (s.mode == SearchMode.remove) {
                msg = I18n.tr("Nothing removed from selection by searching for ''{0}''", s.text);
            } else if (s.mode == SearchMode.in_selection) {
                msg = I18n.tr("Nothing found in selection by searching for ''{0}''", s.text);
            }
            Main.map.statusLine.setHelpText(msg);
            JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr("Warning"), 2);
        } else {
            Main.map.statusLine.setHelpText(I18n.tr("Found {0} matches", foundMatches));
        }
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getEditLayer() != null);
    }

    public static class SearchSetting {
        public String text;
        public SearchMode mode;
        public boolean caseSensitive;
        public boolean regexSearch;

        public SearchSetting(String text, SearchMode mode, boolean caseSensitive, boolean regexSearch) {
            this.caseSensitive = caseSensitive;
            this.regexSearch = regexSearch;
            this.mode = mode;
            this.text = text;
        }

        public SearchSetting(SearchSetting original) {
            this.caseSensitive = original.caseSensitive;
            this.regexSearch = original.regexSearch;
            this.mode = original.mode;
            this.text = original.text;
        }

        public String toString() {
            String cs = this.caseSensitive ? I18n.tr("CS") : I18n.tr("CI");
            String rx = this.regexSearch ? ", " + I18n.tr("RX") : "";
            return "\"" + this.text + "\" (" + cs + rx + ", " + (Object)((Object)this.mode) + ")";
        }

        public boolean equals(Object other) {
            if (!(other instanceof SearchSetting)) {
                return false;
            }
            SearchSetting o = (SearchSetting)other;
            return o.caseSensitive == this.caseSensitive && o.regexSearch == this.regexSearch && o.mode.equals((Object)this.mode) && o.text.equals(this.text);
        }
    }

    public static interface Function {
        public Boolean isSomething(OsmPrimitive var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchMode {
        replace,
        add,
        remove,
        in_selection;

    }
}

