/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitWayAction
extends JosmAction {
    private Way selectedWay;
    private List<Node> selectedNodes;

    public SplitWayAction() {
        super(I18n.tr("Split Way"), "splitway", I18n.tr("Split a way at the selected node."), Shortcut.registerShortcut("tools:splitway", I18n.tr("Tool: {0}", I18n.tr("Split Way")), 80, 3), true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<OsmPrimitive> selection = this.getCurrentDataSet().getSelected();
        if (!this.checkSelection(selection)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("The current selection cannot be used for splitting."), I18n.tr("Warning"), 2);
            return;
        }
        this.selectedWay = null;
        this.selectedNodes = null;
        AbstractVisitor splitVisitor = new AbstractVisitor(){

            public void visit(Node n) {
                if (SplitWayAction.this.selectedNodes == null) {
                    SplitWayAction.this.selectedNodes = new LinkedList();
                }
                SplitWayAction.this.selectedNodes.add(n);
            }

            public void visit(Way w) {
                SplitWayAction.this.selectedWay = w;
            }

            public void visit(Relation e) {
            }
        };
        for (OsmPrimitive p : selection) {
            p.visit(splitVisitor);
        }
        if (this.selectedWay == null && this.selectedNodes != null) {
            HashMap<Way, Integer> wayOccurenceCounter = new HashMap<Way, Integer>();
            for (Node node : this.selectedNodes) {
                block2: for (Way w : this.getCurrentDataSet().ways) {
                    int last;
                    if (!w.isUsable() || (last = w.getNodesCount() - 1) <= 0) continue;
                    boolean circular = w.isClosed();
                    int i = 0;
                    for (Node wn : w.getNodes()) {
                        if ((circular || i > 0 && i < last) && node.equals(wn)) {
                            Integer old = (Integer)wayOccurenceCounter.get(w);
                            wayOccurenceCounter.put(w, old == null ? 1 : old + 1);
                            continue block2;
                        }
                        ++i;
                    }
                }
            }
            if (wayOccurenceCounter.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.trn("The selected node is not in the middle of any way.", "The selected nodes are not in the middle of any way.", this.selectedNodes.size()), I18n.tr("Warning"), 2);
                return;
            }
            for (Map.Entry entry : wayOccurenceCounter.entrySet()) {
                if (!((Integer)entry.getValue()).equals(this.selectedNodes.size())) continue;
                if (this.selectedWay != null) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.trn("There is more than one way using the node you selected. Please select the way also.", "There is more than one way using the nodes you selected. Please select the way also.", this.selectedNodes.size()), I18n.tr("Warning"), 2);
                    return;
                }
                this.selectedWay = (Way)entry.getKey();
            }
            if (this.selectedWay == null) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The selected nodes do not share the same way."), I18n.tr("Warning"), 2);
                return;
            }
        } else if (this.selectedWay != null && this.selectedNodes != null) {
            HashSet<Node> nds = new HashSet<Node>(this.selectedNodes);
            for (Node node : this.selectedWay.getNodes()) {
                nds.remove(node);
            }
            if (!nds.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.trn("The selected way does not contain the selected node.", "The selected way does not contain all the selected nodes.", this.selectedNodes.size()), I18n.tr("Warning"), 2);
                return;
            }
        }
        this.splitWay();
    }

    private boolean checkSelection(Collection<? extends OsmPrimitive> selection) {
        boolean way = false;
        boolean node = false;
        for (OsmPrimitive osmPrimitive : selection) {
            if (osmPrimitive instanceof Way && !way) {
                way = true;
                continue;
            }
            if (osmPrimitive instanceof Node) {
                node = true;
                continue;
            }
            return false;
        }
        return node;
    }

    private void splitWay() {
        HashSet<Node> nodeSet = new HashSet<Node>(this.selectedNodes);
        LinkedList<List> wayChunks = new LinkedList<List>();
        ArrayList<Node> currentWayChunk = new ArrayList<Node>();
        wayChunks.add(currentWayChunk);
        Iterator<Node> it = this.selectedWay.getNodes().iterator();
        while (it.hasNext()) {
            Node currentNode = it.next();
            boolean atEndOfWay = currentWayChunk.isEmpty() || !it.hasNext();
            currentWayChunk.add(currentNode);
            if (!nodeSet.contains(currentNode) || atEndOfWay) continue;
            currentWayChunk = new ArrayList();
            currentWayChunk.add(currentNode);
            wayChunks.add(currentWayChunk);
        }
        List lastWayChunk = (List)wayChunks.get(wayChunks.size() - 1);
        if (wayChunks.size() >= 2 && ((List)wayChunks.get(0)).get(0) == lastWayChunk.get(lastWayChunk.size() - 1) && !nodeSet.contains(((List)wayChunks.get(0)).get(0))) {
            if (wayChunks.size() == 2) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You must select two or more nodes to split a circular way."), I18n.tr("Warning"), 2);
                return;
            }
            lastWayChunk.remove(lastWayChunk.size() - 1);
            lastWayChunk.addAll((Collection)wayChunks.get(0));
            wayChunks.remove(wayChunks.size() - 1);
            wayChunks.set(0, lastWayChunk);
        }
        if (wayChunks.size() < 2) {
            if (((List)wayChunks.get(0)).get(0) == ((List)wayChunks.get(0)).get(((List)wayChunks.get(0)).size() - 1)) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You must select two or more nodes to split a circular way."), I18n.tr("Warning"), 2);
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The way cannot be split at the selected nodes. (Hint: Select nodes in the middle of the way.)"), I18n.tr("Warning"), 2);
            }
            return;
        }
        ArrayList<Command> commandList = new ArrayList<Command>(wayChunks.size());
        ArrayList<Way> newSelection = new ArrayList<Way>(wayChunks.size());
        Iterator chunkIt = wayChunks.iterator();
        Way changedWay = new Way(this.selectedWay);
        changedWay.setNodes((List)chunkIt.next());
        commandList.add(new ChangeCommand(this.selectedWay, changedWay));
        newSelection.add(this.selectedWay);
        ArrayList<Way> newWays = new ArrayList<Way>();
        while (chunkIt.hasNext()) {
            Way wayToAdd = new Way();
            wayToAdd.setKeys(this.selectedWay.getKeys());
            newWays.add(wayToAdd);
            wayToAdd.setNodes((List)chunkIt.next());
            commandList.add(new AddCommand(wayToAdd));
            newSelection.add(wayToAdd);
        }
        Boolean warnmerole = false;
        Boolean warnme = false;
        for (Relation r : this.getCurrentDataSet().relations) {
            if (!r.isUsable()) continue;
            Relation c = null;
            String type = r.get("type");
            if (type == null) {
                type = "";
            }
            int i = 0;
            for (RelationMember rm : r.getMembers()) {
                if (rm.isWay() && rm.getMember() == this.selectedWay) {
                    if (!"route".equals(type) && !"multipolygon".equals(type)) {
                        warnme = true;
                    }
                    if (c == null) {
                        c = new Relation(r);
                    }
                    int j = i;
                    boolean backwards = "backward".equals(rm.getRole());
                    for (Way wayToAdd : newWays) {
                        RelationMember em = new RelationMember(rm.getRole(), wayToAdd);
                        if (em.hasRole() && !"multipolygon".equals(type)) {
                            warnmerole = true;
                        }
                        ++j;
                        if (backwards) {
                            c.addMember(i, em);
                            continue;
                        }
                        c.addMember(j, em);
                    }
                    i = j;
                }
                ++i;
            }
            if (c == null) continue;
            commandList.add(new ChangeCommand(r, c));
        }
        if (warnmerole.booleanValue()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>A role based relation membership was copied to all new ways.<br>You should verify this and correct it when necessary.</html>"), I18n.tr("Warning"), 2);
        } else if (warnme.booleanValue()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>A relation membership was copied to all new ways.<br>You should verify this and correct it when necessary.</html>"), I18n.tr("Warning"), 2);
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Split way {0} into {1} parts", this.selectedWay.getDisplayName(DefaultNameFormatter.getInstance()), wayChunks.size()), commandList));
        this.getCurrentDataSet().setSelected(newSelection);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(this.checkSelection(selection));
    }
}

