/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class OpenLocationAction
extends JosmAction {
    public OpenLocationAction() {
        super(I18n.tr("Open Location..."), "openlocation", I18n.tr("Open an URL."), Shortcut.registerShortcut("system:open_location", I18n.tr("File: {0}", I18n.tr("Open Location...")), 76, 2), true);
    }

    protected void restoreUploadAddressHistory(HistoryComboBox cbHistory) {
        LinkedList<String> cmtHistory = new LinkedList<String>(Main.pref.getCollection(this.getClass().getName() + ".uploadAddressHistory", new LinkedList<String>()));
        Collections.reverse(cmtHistory);
        cbHistory.setPossibleItems(cmtHistory);
    }

    protected void remindUploadAddressHistory(HistoryComboBox cbHistory) {
        cbHistory.addCurrentItemToHistory();
        Main.pref.putCollection(this.getClass().getName() + ".uploadAddressHistory", cbHistory.getHistory());
    }

    public void actionPerformed(ActionEvent e) {
        JCheckBox layer = new JCheckBox(I18n.tr("Separate Layer"));
        layer.setToolTipText(I18n.tr("Select if the data should be downloaded in a new layer"));
        layer.setSelected(Main.pref.getBoolean("download.newlayer"));
        JPanel all = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.anchor = 23;
        all.add((Component)new JLabel(I18n.tr("Enter URL to download:")), gc);
        HistoryComboBox uploadAdresses = new HistoryComboBox();
        uploadAdresses.setToolTipText(I18n.tr("Enter an URL from where data should be downloaded"));
        this.restoreUploadAddressHistory(uploadAdresses);
        gc.gridy = 1;
        all.add((Component)uploadAdresses, gc);
        gc.gridy = 2;
        gc.fill = 1;
        gc.weighty = 1.0;
        all.add((Component)layer, gc);
        ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Download Location"), new String[]{I18n.tr("Download URL"), I18n.tr("Cancel")});
        dialog.setContent(all, false);
        dialog.setButtonIcons(new String[]{"download.png", "cancel.png"});
        dialog.setToolTipTexts(new String[]{I18n.tr("Start downloading data"), I18n.tr("Close dialog and cancel downloading")});
        dialog.configureContextsensitiveHelp("/Action/OpenLocation", true);
        dialog.showDialog();
        if (dialog.getValue() != 1) {
            return;
        }
        this.remindUploadAddressHistory(uploadAdresses);
        this.openUrl(layer.isSelected(), uploadAdresses.getText());
    }

    public void openUrl(boolean new_layer, String url) {
        new DownloadOsmTask().loadUrl(new_layer, url, null);
    }
}

