/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.actions.AbstractMergeAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.MergeSourceBuildingVisitor;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeSelectionAction
extends AbstractMergeAction {
    public MergeSelectionAction() {
        super(I18n.tr("Merge selection"), "dialogs/mergedown", I18n.tr("Merge the currently selected primitives into another layer"), Shortcut.registerShortcut("system:mergeselection", I18n.tr("Edit: {0}", I18n.tr("Merge selection")), 77, 2, 1), true);
    }

    public void mergeSelected(DataSet source) {
        List<Layer> targetLayers = LayerListDialog.getInstance().getModel().getPossibleMergeTargets(this.getEditLayer());
        if (targetLayers.isEmpty()) {
            this.warnNoTargetLayersForSourceLayer(this.getEditLayer());
            return;
        }
        Layer targetLayer = this.askTargetLayer(targetLayers);
        if (targetLayer == null) {
            return;
        }
        MergeSourceBuildingVisitor builder = new MergeSourceBuildingVisitor(this.getEditLayer().data);
        ((OsmDataLayer)targetLayer).mergeFrom(builder.build());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.getEditLayer() == null || this.getEditLayer().data.getSelected().isEmpty()) {
            return;
        }
        this.mergeSelected(this.getEditLayer().data);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

