/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinNodeWayAction
extends JosmAction {
    public JoinNodeWayAction() {
        super(I18n.tr("Join Node to Way"), "joinnodeway", I18n.tr("Join a node into the nearest way segments"), Shortcut.registerShortcut("tools:joinnodeway", I18n.tr("Tool: {0}", I18n.tr("Join Node to Way")), 74, 3), true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> sel = this.getCurrentDataSet().getSelected();
        if (sel.size() != 1 || !(sel.iterator().next() instanceof Node)) {
            return;
        }
        Node node = (Node)sel.iterator().next();
        List<WaySegment> wss = Main.map.mapView.getNearestWaySegments(Main.map.mapView.getPoint(node));
        HashMap insertPoints = new HashMap();
        for (WaySegment ws : wss) {
            List<Integer> is;
            if (insertPoints.containsKey(ws.way)) {
                is = (List)insertPoints.get(ws.way);
            } else {
                is = new ArrayList();
                insertPoints.put(ws.way, is);
            }
            if (ws.way.getNode(ws.lowerIndex) == node || ws.way.getNode(ws.lowerIndex + 1) == node) continue;
            is.add(ws.lowerIndex);
        }
        LinkedList<Command> cmds = new LinkedList<Command>();
        for (Map.Entry insertPoint : insertPoints.entrySet()) {
            Way w = (Way)insertPoint.getKey();
            List<Node> nodesToAdd = w.getNodes();
            List is = (List)insertPoint.getValue();
            JoinNodeWayAction.pruneSuccsAndReverse(is);
            Iterator i$ = is.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                nodesToAdd.add(i + 1, node);
            }
            Way wnew = new Way(w);
            wnew.setNodes(nodesToAdd);
            cmds.add(new ChangeCommand(w, wnew));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Join Node and Line"), cmds));
        Main.map.repaint();
    }

    private static void pruneSuccsAndReverse(List<Integer> is) {
        HashSet<Integer> is2 = new HashSet<Integer>();
        for (int i : is) {
            if (is2.contains(i - 1) || is2.contains(i + 1)) continue;
            is2.add(i);
        }
        is.clear();
        is.addAll(is2);
        Collections.sort(is);
        Collections.reverse(is);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

